% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coords.R
\name{lookup_coords}
\alias{lookup_coords}
\title{Get coordinates of specified location.}
\usage{
lookup_coords(address, components = NULL, apikey = NULL, ...)
}
\arguments{
\item{address}{Desired location typically in the form of place
name, subregion, e.g., address = "lawrence, KS". Also accepts the
name of countries, e.g., address = "usa", address = "brazil" or
states, e.g., address = "missouri" or cities, e.g., address =
"chicago". In most cases using only address should be sufficient.}

\item{components}{Unit of analysis for address e.g., components =
"country:US". Potential components include postal_code, country,
administrative_area, locality, route.}

\item{apikey}{A valid Google Maps API key. If NULL, \code{lookup_coords()} will
look for a relevant API key stored as an environment variable (e.g.,
\code{GOOGLE_MAPS_KEY}).}

\item{...}{Additional arguments passed as parameters in the HTTP
request}
}
\value{
Object of class coords.
}
\description{
Convenience function for looking up latitude/longitude coordinate
information for a given location. Returns data as a special
"coords" object, which is specifically designed to interact
smoothly with other relevant package functions. NOTE: USE OF THIS FUNCTION
REQUIRES A VALID GOOGLE MAPS API KEY.
}
\details{
Since Google Maps implemented stricter API requirements, sending
requests to Google's API isn't very convenient. To enable basic uses
without requiring a Google Maps API key, a number of the major cities
throughout the word and the following two larger locations are
baked into this function: 'world' and 'usa'. If 'world' is supplied then
a bounding box of maximum latitutde/longitude values, i.e.,
\code{c(-180, -90, 180, 90)}, and a center point \code{c(0, 0)} are
returned. If 'usa' is supplied then estimates of the United States'
bounding box and mid-point are returned. To specify a city, provide the
city name followed by a space and then the US state abbreviation or
country name. To see a list of all included cities, enter
\code{rtweet:::citycoords} in the R console to see coordinates data.
}
\examples{

\dontrun{

## get coordinates associated with the following addresses/components
sf <- lookup_coords("san francisco, CA", "country:US")
usa <- lookup_coords("usa")
lnd <- lookup_coords("london")
bz <- lookup_coords("brazil")

}

}
\seealso{
Other geo: 
\code{\link{lat_lng}()}
}
\concept{geo}
