% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draws.R
\name{stanreg-draws-formats}
\alias{stanreg-draws-formats}
\alias{as_draws}
\alias{as_draws_matrix}
\alias{as_draws_array}
\alias{as_draws_df}
\alias{as_draws_rvars}
\alias{as_draws_list}
\alias{as_draws.stanreg}
\alias{as_draws_matrix.stanreg}
\alias{as_draws_array.stanreg}
\alias{as_draws_df.stanreg}
\alias{as_draws_list.stanreg}
\alias{as_draws_rvars.stanreg}
\title{Create a \code{draws} object from a \code{stanreg} object}
\usage{
\method{as_draws}{stanreg}(x, ...)

\method{as_draws_matrix}{stanreg}(x, ...)

\method{as_draws_array}{stanreg}(x, ...)

\method{as_draws_df}{stanreg}(x, ...)

\method{as_draws_list}{stanreg}(x, ...)

\method{as_draws_rvars}{stanreg}(x, ...)
}
\arguments{
\item{x}{A \code{stanreg} object returned by one of the \pkg{rstanarm}
modeling functions.}

\item{...}{Arguments (e.g., \code{pars}, \code{regex_pars}) passed internally to
\code{\link{as.matrix.stanreg}} or \code{as.array.stanreg}.}
}
\value{
A \code{draws} object from the
  \pkg{\link[posterior:posterior-package]{posterior}} package. See the
  \pkg{posterior} package documentation and vignettes for details on working
  with these objects.
}
\description{
Convert a \code{stanreg} object to a format supported by the
\pkg{\link[posterior:posterior-package]{posterior}} package.
}
\details{
To subset iterations, chains, or draws, use
  \code{\link[posterior:subset_draws]{subset_draws}} after making the
  \code{draws} object. To subset variables use \code{...} to pass the \code{pars}
  and/or \code{regex_pars} arguments to \code{as.matrix.stanreg} or
  \code{as.array.stanreg} (these are called internally by
  \code{as_draws.stanreg}), or use
  \code{\link[posterior:subset_draws]{subset_draws}} after making the
  \code{draws} object.
}
\examples{
fit <- stan_glm(mpg ~ wt + as.factor(cyl), data = mtcars)
as_draws_matrix(fit) # matrix format combines all chains 
as_draws_df(fit, regex_pars = "cyl")
posterior::summarize_draws(as_draws_array(fit))

}
