% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SDMXAgencyScheme.R,
%   R/SDMXAgencyScheme-methods.R
\docType{class}
\name{SDMXAgencyScheme}
\alias{SDMXAgencyScheme}
\alias{SDMXAgencyScheme-class}
\alias{SDMXAgencyScheme,SDMXAgencyScheme-method}
\title{Class "SDMXAgencyScheme"}
\usage{
SDMXAgencyScheme(xmlObj, namespaces)
}
\arguments{
\item{xmlObj}{object of class "XMLInternalDocument derived from XML package}

\item{namespaces}{object of class "data.frame" given the list of namespace URIs}
}
\value{
an object of class "SDMXAgencyScheme"
}
\description{
A basic abstract class to handle a SDMXAgencyScheme
}
\section{Slots}{

\describe{
\item{\code{id}}{Object of class "character" giving the ID of the concept scheme (required)}

\item{\code{agencyID}}{Object of class "character" giving the AgencyID}

\item{\code{version}}{Object of class "character" giving the version}

\item{\code{uri}}{Object of class "character" giving the concept uri}

\item{\code{urn}}{Object of class "character" giving the concept urn}

\item{\code{isExternalReference}}{Object of class "logical" indicating if the concept scheme is an external reference}

\item{\code{isFinal}}{Object of class "logical" indicating if the concept scheme is final}

\item{\code{validFrom}}{Object of class "character" indicating the start validity period}

\item{\code{validTo}}{Object of class "character" indicating the end validity period}

\item{\code{Name}}{Object of class "list" giving the agency scheme name (by language) - required}

\item{\code{Description}}{Object of class "list" giving the agency scheme description (by language)}

\item{\code{agencies}}{object of class "list" giving the list of \code{SDMXAgency}}
}}

\seealso{
\link{readSDMX}
}
\author{
Emmanuel Blondel, \email{emmanuel.blondel1@gmail.com}
}
