% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-body.R
\name{register_parser}
\alias{register_parser}
\alias{registered_parsers}
\title{Manage parsers}
\usage{
register_parser(alias, parser, fixed = NULL, regex = NULL, verbose = TRUE)

registered_parsers()
}
\arguments{
\item{alias}{An alias to map parser from the \verb{@parser} plumber tag to the global parsers list.}

\item{parser}{The parser function to be added. This build the parser function. See Details for more information.}

\item{fixed}{A character vector of fixed string to be matched against a request \code{content-type} to use \code{parser}.}

\item{regex}{A character vector of \link{regex} string to be matched against a request \code{content-type} to use \code{parser}.}

\item{verbose}{Logical value which determines if a warning should be
displayed when alias in map are overwritten.}
}
\description{
A parser is responsible for decoding the raw body content of a request into
a list of arguments that can be mapped to endpoint function arguments.
For instance, \code{\link[=parser_json]{parser_json()}} parse content-type \code{application/json}.
}
\details{
When \code{parser} is evaluated, it should return a parser function.
Parser matching is done first by \code{content-type} header matching with \code{fixed} then by using
regular expressions with \code{regex}. Note that plumber strips \verb{; charset*} from \code{content-type} header before matching.

Plumber will try to use \code{\link[=parser_json]{parser_json()}} (if available) when no \code{content-type} header is found and
the request body starts with \verb{\{} or \code{[}.

Functions signature should include \code{value}, \code{...} and
possibly \code{content_type}, \code{filename}. Other parameters may be provided
if you want to use the headers from \code{\link[webutils:parse_multipart]{webutils::parse_multipart()}}.

Parser function structure is something like below.\if{html}{\out{<div class="r">}}\preformatted{function(parser_arguments_here) \{
  # return a function to parse a raw value
  function(value, ...) \{
    # do something with raw value
  \}
\}
}\if{html}{\out{</div>}}
}
\section{Functions}{
\itemize{
\item \code{registered_parsers}: Return all registered parsers
}}

\examples{
# `content-type` header is mostly used to look up charset and adjust encoding
parser_dcf <- function(...) {
  function(value, content_type = "text/x-dcf", ...) {
    charset <- get_character_set(content_type)
    value <- rawToChar(value)
    Encoding(value) <- charset
    read.dcf(value, ...)
  }
}

# Could also leverage existing parsers
parser_dcf <- function(...) {
  parser_read_file(function(tmpfile) {
    read.dcf(tmpfile, ...)
  })
}

# Register the newly created parser
\dontrun{register_parser("dcf", parser_dcf, fixed = "text/x-dcf")}
}
