% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgKitten.R
\name{kitten}
\alias{kitten}
\title{Create a very simple package}
\usage{
kitten(name = "anRpackage", path = ".", author, maintainer, email,
  license = "GPL (>= 2)", puppy = TRUE, bunny = TRUE)
}
\arguments{
\item{name}{The name of the package to be created, defaults to \dQuote{anPackage}}

\item{path}{The path to the location where the package is to be
created, defaults to the current directory.}

\item{author}{The name of the author, defaults to the result of
\code{\link[whoami]{fullname}} (or \dQuote{Your Name} as fallback).}

\item{maintainer}{The name of the maintainer, also defaults to
\code{\link[whoami]{fullname}} or \code{author} if the latter is given.}

\item{email}{The maintainer email address, defaults to
\code{\link[whoami]{email_address}} (or \dQuote{your@email.com} as fallback).}

\item{license}{The license of the new package, defaults to \dQuote{GPL-2}.}

\item{puppy}{Toggle whether \code{tinytest::puppy} add unit testing, default
to true (but conditional on \code{tinytest} being installed).}

\item{bunny}{Toggle whether \code{roxygen2} should be used for the
the creation of Rd files from R, default is true (but also conditional on
\code{roxygen2} being install).}
}
\value{
Nothing is returned as the function is invoked for its
side effect of creating a new package.
}
\description{
The \code{kitten} function creates an (almost) empty example
package.
}
\details{
The \code{kitten} function can be used to initialize a simple
package.  It is created with the minimal number of files. What
distinguished it from the function \code{package.skeleton()} in
base R (which it actually calls) is that the resulting package
passes \code{R CMD check cleanly}.

Because every time you create a new package which does \emph{not}
pass \code{R CMD check}, a kitten experiences an existential
trauma. Just think about the kittens.
}
\author{
Dirk Eddelbuettel
}
