% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_collinearity.R
\name{check_collinearity}
\alias{check_collinearity}
\alias{check_collinearity.glmmTMB}
\title{Check for multicollinearity of model terms}
\usage{
check_collinearity(x, ...)

\method{check_collinearity}{glmmTMB}(
  x,
  component = c("all", "conditional", "count", "zi", "zero_inflated"),
  ...
)
}
\arguments{
\item{x}{A model object (that should at least respond to \code{vcov()},
and if possible, also to \code{model.matrix()} - however, it also should
work without \code{model.matrix()}).}

\item{...}{Currently not used.}

\item{component}{For models with zero-inflation component, multicollinearity
can be checked for the conditional model (count component,
\code{component = "conditional"} or \code{component = "count"}),
zero-inflation component (\code{component = "zero_inflated"} or
\code{component = "zi"}) or both components (\code{component = "all"}).
Following model-classes are currently supported: \code{hurdle},
\code{zeroinfl}, \code{zerocount}, \code{MixMod} and \code{glmmTMB}.}
}
\value{
A data frame with three columns: The name of the model term, the
  variance inflation factor and the factor by which the standard error
  is increased due to possible correlation with other terms.
}
\description{
\code{check_collinearity()} checks regression models for
  multicollinearity by calculating the variance inflation factor (VIF).
}
\details{
The variance inflation factor is a measure to analyze the magnitude
  of multicollinearity of model terms. A VIF less than 5 indicates
  a low correlation of that predictor with other predictors. A value between
  5 and 10 indicates a moderate correlation, while VIF values larger than 10
  are a sign for high, not tolerable correlation of model predictors. The
  \emph{Increased SE} column in the output indicates how much larger
  the standard error is due to the correlation with other predictors.
  \cr \cr
  An informative blog post about collinearity can be found
  \href{https://janhove.github.io/analysis/2019/09/11/collinearity}{here}.
}
\note{
There is also a \href{https://easystats.github.io/see/articles/performance.html}{\code{plot()}-method} implemented in the \href{https://easystats.github.io/see/}{\pkg{see}-package}.
}
\examples{
m <- lm(mpg ~ wt + cyl + gear + disp, data = mtcars)
check_collinearity(m)

# plot results
x <- check_collinearity(m)
plot(x)
}
\references{
James, G., Witten, D., Hastie, T., & Tibshirani, R. (Hrsg.). (2013). An introduction to statistical learning: with applications in R. New York: Springer.
}
