% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regression.R
\name{MSE}
\alias{MSE}
\title{Mean Square Error Loss}
\usage{
MSE(y_pred, y_true)
}
\arguments{
\item{y_pred}{Estimated target values vector}

\item{y_true}{Ground truth (correct) target values vector}
}
\value{
Mean Square Error Loss
}
\description{
Compute the mean squared error regression loss.
}
\examples{
data(cars)
reg <- lm(log(dist) ~ log(speed), data = cars)
MSE(y_pred = exp(reg$fitted.values), y_true = cars$dist)
}

