% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/where.R
\name{make.where}
\alias{make.where}
\title{Creates a \code{where} argument}
\usage{
make.where(data, keyword = c("missing", "all", "none", "observed"))
}
\arguments{
\item{data}{A \code{data.frame} with the source data}

\item{keyword}{An optional keyword, one of \code{"missing"} (missing
values are imputed), \code{"observed"} (observed values are imputed),
\code{"all"} and \code{"none"}. The default
is \code{keyword = "missing"}}
}
\value{
A matrix with logical
}
\description{
This helper function creates a valid \code{where} matrix. The
\code{where} matrix is an argument to the \code{mice} function.
It has the same size as \code{data} and specifies which values
are to be imputed (\code{TRUE}) or nor (\code{FALSE}).
}
\examples{
head(make.where(nhanes), 3)
}
\seealso{
\code{\link{make.blocks}}, \code{\link{make.predictorMatrix}}
}
