% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_classification.R
\name{fbeta_score}
\alias{fbeta_score}
\title{F-beta Score}
\usage{
fbeta_score(actual, predicted, beta = 1)
}
\arguments{
\item{actual}{The ground truth binary numeric vector containing 1 for the positive
class and 0 for the negative class.}

\item{predicted}{The predicted binary numeric vector containing 1 for the positive
class and 0 for the negative class. Each element represents the
prediction for the corresponding element in \code{actual}.}

\item{beta}{A non-negative real number controlling how close the F-beta score is to 
either Precision or Recall. When \code{beta} is at the default of 1, 
the F-beta Score is exactly an equally weighted harmonic mean.
The F-beta score will weight toward Precision when \code{beta} is less 
than one.  The F-beta score will weight toward Recall when \code{beta} is
greater than one.}
}
\description{
\code{fbeta_score} computes a weighted harmonic mean of Precision and Recall.
                   The \code{beta} parameter controls the weighting.
}
\examples{
actual <- c(1, 1, 1, 0, 0, 0)
predicted <- c(1, 0, 1, 1, 1, 1)
recall(actual, predicted)
}
\seealso{
\code{\link{precision}} \code{\link{recall}}
}
