% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowMads.R, R/rowSds.R
\name{rowMads}
\alias{rowMads}
\alias{colMads}
\alias{rowSds}
\alias{colSds}
\title{Standard deviation estimates for each row (column) in a matrix}
\usage{
rowMads(x, rows = NULL, cols = NULL, center = NULL, constant = 1.4826,
  na.rm = FALSE, dim. = dim(x), ..., useNames = TRUE)

colMads(x, rows = NULL, cols = NULL, center = NULL, constant = 1.4826,
  na.rm = FALSE, dim. = dim(x), ..., useNames = TRUE)

rowSds(x, rows = NULL, cols = NULL, na.rm = FALSE, refine = TRUE,
  center = NULL, dim. = dim(x), ..., useNames = TRUE)

colSds(x, rows = NULL, cols = NULL, na.rm = FALSE, refine = TRUE,
  center = NULL, dim. = dim(x), ..., useNames = TRUE)
}
\arguments{
\item{x}{An NxK \code{\link[base]{matrix}} or, if \code{dim.} is specified,
an N * K \code{\link[base]{vector}}.}

\item{rows}{A \code{\link[base]{vector}} indicating subset of rows to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}

\item{cols}{A \code{\link[base]{vector}} indicating subset of columns to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}

\item{center}{(optional) The center, defaults to the row means for the
SD estimators and row medians for the MAD estimators.}

\item{constant}{A scale factor.  See \code{\link[stats]{mad}} for details.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, missing values are
excluded.}

\item{dim.}{An \code{\link[base]{integer}} \code{\link[base]{vector}} of
length two specifying the dimension of \code{x}, also when not a
\code{\link[base]{matrix}}.  \emph{Comment:} The reason for this argument
being named with a period at the end is purely technical (we get a run-time
error if we try to name it \code{dim}).}

\item{...}{Additional arguments passed to \code{rowMeans()} and
\code{rowSums()}.}

\item{useNames}{If \code{\link[base:logical]{TRUE}} (default), names
attributes of the result are set, otherwise not.}

\item{refine}{If \code{\link[base:logical]{TRUE}}, `center` is NULL, and
\code{x} is \code{\link[base]{numeric}}, then extra effort is used to
calculate the average with greater numerical precision, otherwise not.}
}
\value{
Returns a \code{\link[base]{numeric}} \code{\link[base]{vector}} of
length N (K).
}
\description{
Standard deviation estimates for each row (column) in a matrix.
}
\seealso{
\code{\link[stats]{sd}}, \code{\link[stats]{mad}} and
\code{\link[stats:cor]{var}}.  \code{\link{rowIQRs}}().
}
\author{
Henrik Bengtsson
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
