% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hommc.R
\name{fitHighOrderMultivarMC}
\alias{fitHighOrderMultivarMC}
\title{Function to fit Higher Order Multivariate Markov chain}
\usage{
fitHighOrderMultivarMC(seqMat, order = 2, Norm = 2)
}
\arguments{
\item{seqMat}{a matrix or a data frame where each column 
is a categorical sequence}

\item{order}{Multivariate Markov chain order. Default is 2.}

\item{Norm}{Norm to be used. Default is 2.}
}
\value{
an hommc object
}
\description{
Given a matrix of categorical sequences it fits 
             Higher Order Multivariate Markov chain.
}
\examples{
data <- matrix(c('2', '1', '3', '3', '4', '3', '2', '1', '3', '3', '2', '1', 
               c('2', '4', '4', '4', '4', '2', '3', '3', '1', '4', '3', '3')), 
               ncol = 2, byrow = FALSE)
               
fitHighOrderMultivarMC(data, order = 2, Norm = 2)                

}
\references{
W.-K. Ching et al. / Linear Algebra and its Applications
}
\author{
Giorgio Spedicato, Deepak Yadav
}
