% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nem.R
\name{nem}
\alias{nem}
\title{Negative Eigenvalue Magnitude}
\usage{
nem(data)
}
\arguments{
\item{data}{an \eqn{(n\times p)} matrix whose rows are observations.}
}
\value{
a nonnegative NEM value.
}
\description{
Negative Eigenvalue Magnitude (NEM) is a measure of distortion for the data 
whether they are lying in Euclidean manner or not. When the value is exactly 0, it means 
the data is Euclidean. On the other hand, when NEM is far away from 0, it means not Euclidean. 
The concept of NEM is closely related to the definiteness of a Gram matrix.
}
\examples{
## use simple example of iris dataset 
data(iris) 
mydat = as.matrix(iris[,1:4])

## calculate NEM
nem(mydat)

}
\references{
\insertRef{pekalska_noneuclidean_2006}{maotai}
}
