% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_linter_from_xpath.R
\name{make_linter_from_xpath}
\alias{make_linter_from_xpath}
\title{Create a linter from an XPath}
\usage{
make_linter_from_xpath(
  xpath,
  lint_message,
  type = c("warning", "style", "error"),
  level = c("expression", "file")
)
}
\arguments{
\item{xpath}{Character string, an XPath identifying R code to lint.
See \code{\link[xmlparsedata:xml_parse_data]{xmlparsedata::xml_parse_data()}} and \code{\link[=get_source_expressions]{get_source_expressions()}}.}

\item{lint_message}{The message to be included as the \code{message}
to the \code{Lint} object. If \code{lint_message} is a character vector the same length as \code{xml},
the \code{i}-th lint will be given the \code{i}-th message.}

\item{type}{type of lint.}

\item{level}{Which level of expression is being tested? \code{"expression"}
means an individual expression, while \code{"file"} means all expressions
in the current file are available.}
}
\description{
Create a linter from an XPath
}
\examples{
number_linter <- make_linter_from_xpath("//NUM_CONST", "This is a number.")
lint(text = "1 + 2", linters = number_linter())
}
