% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_table_theme.R, R/export_table.R
\name{apply_table_theme}
\alias{apply_table_theme}
\alias{export_table}
\title{Data frame and Tables Pretty Formatting}
\usage{
apply_table_theme(out, x, theme = "default", sub_header_positions = NULL)

export_table(
  x,
  sep = " | ",
  header = "-",
  cross = NULL,
  empty_line = NULL,
  digits = 2,
  protect_integers = TRUE,
  missing = "",
  width = NULL,
  format = NULL,
  title = NULL,
  caption = title,
  subtitle = NULL,
  footer = NULL,
  align = NULL,
  group_by = NULL,
  zap_small = FALSE,
  table_width = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{out}{A \code{tinytable} object.}

\item{x}{A data frame. May also be a list of data frames, to export multiple
data frames into multiple tables.}

\item{theme}{The theme to apply to the table. One of \code{"default"}, \code{"grid"},
\code{"striped"}, \code{"bootstrap"}, or \code{"darklines"}.}

\item{sub_header_positions}{A vector of row positions to apply a border to.
Currently particular for internal use of other \emph{easystats} packages.}

\item{sep}{Column separator.}

\item{header}{Header separator. Can be \code{NULL}.}

\item{cross}{Character that is used where separator and header lines cross.}

\item{empty_line}{Separator used for empty lines. If \code{NULL}, line remains
empty (i.e. filled with whitespaces).}

\item{digits}{Number of digits for rounding or significant figures. May also
be \code{"signif"} to return significant figures or \code{"scientific"}
to return scientific notation. Control the number of digits by adding the
value as suffix, e.g. \code{digits = "scientific4"} to have scientific
notation with 4 decimal places, or \code{digits = "signif5"} for 5
significant figures (see also \code{\link[=signif]{signif()}}).}

\item{protect_integers}{Should integers be kept as integers (i.e., without
decimals)?}

\item{missing}{Value by which \code{NA} values are replaced. By default, an
empty string (i.e. \code{""}) is returned for \code{NA}.}

\item{width}{Refers to the width of columns (with numeric values). Can be
either \code{NULL}, a number or a named numeric vector. If \code{NULL}, the width for
each column is adjusted to the minimum required width. If a number, columns
with numeric values will have the minimum width specified in \code{width}. If
a named numeric vector, value names are matched against column names, and
for each match, the specified width is used (see 'Examples'). Only applies
to text-format (see \code{format}).}

\item{format}{Name of output-format, as string. If \code{NULL} (or \code{"text"}),
returned output is used for basic printing. Can be one of \code{NULL} (the
default) resp. \code{"text"} for plain text, \code{"markdown"} (or
\code{"md"}) for markdown and \code{"html"} for HTML output.}

\item{title, caption, subtitle}{Table title (same as caption) and subtitle, as strings. If \code{NULL},
no title or subtitle is printed, unless it is stored as attributes (\code{table_title},
or its alias \code{table_caption}, and \code{table_subtitle}). If \code{x} is a list of
data frames, \code{caption} may be a list of table captions, one for each table.}

\item{footer}{Table footer, as string. For markdown-formatted tables, table
footers, due to the limitation in markdown rendering, are actually just a
new text line under the table. If \code{x} is a list of data frames, \code{footer}
may be a list of table captions, one for each table.}

\item{align}{Column alignment. For markdown-formatted tables, the default
\code{align = NULL} will right-align numeric columns, while all other
columns will be left-aligned. If \code{format = "html"}, the default is
left-align first column and center all remaining. May be a string to
indicate alignment rules for the complete table, like \code{"left"},
\code{"right"}, \code{"center"} or \code{"firstleft"} (to left-align first
column, center remaining); or maybe a string with abbreviated alignment
characters, where the length of the string must equal the number of columns,
for instance, \code{align = "lccrl"} would left-align the first column, center
the second and third, right-align column four and left-align the fifth
column. For HTML-tables, may be one of \code{"center"}, \code{"left"} or
\code{"right"}.}

\item{group_by}{Name of column in \code{x} that indicates grouping for tables.
Only applies when \code{format = "html"}. \code{group_by} is passed down
to \code{gt::gt(groupname_col = group_by)}.}

\item{zap_small}{Logical, if \code{TRUE}, small values are rounded after
\code{digits} decimal places. If \code{FALSE}, values with more decimal
places than \code{digits} are printed in scientific notation.}

\item{table_width}{Numeric, or \code{"auto"}, indicating the width of the complete
table. If \code{table_width = "auto"} and the table is wider than the current
width (i.e. line length) of the console (or any other source for textual
output, like markdown files), the table is split into two parts. Else,
if \code{table_width} is numeric and table rows are larger than \code{table_width},
the table is split into two parts.}

\item{verbose}{Toggle messages and warnings.}

\item{...}{Currently not used.}
}
\value{
A data frame in character format.
}
\description{
Data frame and Tables Pretty Formatting
}
\note{
The values for \code{caption}, \code{subtitle} and \code{footer} can also be provided
as attributes of \code{x}, e.g. if \code{caption = NULL} and \code{x} has attribute
\code{table_caption}, the value for this attribute will be used as table caption.
\code{table_subtitle} is the attribute for \code{subtitle}, and \code{table_footer} for
\code{footer}.
}
\examples{
export_table(head(iris))
export_table(head(iris), cross = "+")
export_table(head(iris), sep = " ", header = "*", digits = 1)

# split longer tables
export_table(head(iris), table_width = 30)

\donttest{
# colored footers
data(iris)
x <- as.data.frame(iris[1:5, ])
attr(x, "table_footer") <- c("This is a yellow footer line.", "yellow")
export_table(x)

attr(x, "table_footer") <- list(
  c("\nA yellow line", "yellow"),
  c("\nAnd a red line", "red"),
  c("\nAnd a blue line", "blue")
)
export_table(x)

attr(x, "table_footer") <- list(
  c("Without the ", "yellow"),
  c("new-line character ", "red"),
  c("we can have multiple colors per line.", "blue")
)
export_table(x)
}

# column-width
d <- data.frame(
  x = c(1, 2, 3),
  y = c(100, 200, 300),
  z = c(10000, 20000, 30000)
)
export_table(d)
export_table(d, width = 8)
export_table(d, width = c(x = 5, z = 10))
export_table(d, width = c(x = 5, y = 5, z = 10), align = "lcr")
}
\seealso{
Vignettes
\href{https://easystats.github.io/insight/articles/display.html}{Formatting, printing and exporting tables}
and \href{https://easystats.github.io/parameters/articles/model_parameters_formatting.html}{Formatting model parameters}.
}
