% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure.info.R
\name{are_adjacent}
\alias{are_adjacent}
\alias{are.connected}
\title{Are two vertices adjacent?}
\usage{
are_adjacent(graph, v1, v2)
}
\arguments{
\item{graph}{The graph.}

\item{v1}{The first vertex, tail in directed graphs.}

\item{v2}{The second vertex, head in directed graphs.}
}
\value{
A logical scalar, \code{TRUE} is a \code{(v1, v2)} exists in the
  graph.
}
\description{
The order of the vertices only matters in directed graphs,
where the existence of a directed \code{(v1, v2)} edge is queried.
}
\examples{
ug <- make_ring(10)
ug
are_adjacent(ug, 1, 2)
are_adjacent(ug, 2, 1)

dg <- make_ring(10, directed = TRUE)
dg
are_adjacent(ug, 1, 2)
are_adjacent(ug, 2, 1)
}
\seealso{
Other structural queries: \code{\link{[.igraph}},
  \code{\link{[[.igraph}}, \code{\link{adjacent_vertices}},
  \code{\link{ends}}, \code{\link{get.edge.ids}},
  \code{\link{gorder}}, \code{\link{gsize}},
  \code{\link{head_of}}, \code{\link{incident_edges}},
  \code{\link{incident}}, \code{\link{is_directed}},
  \code{\link{neighbors}}, \code{\link{tail_of}}
}
\concept{structural queries}
