/* This is Knut Petras' smolyak.c from SMOLPACK, 
 * modified by Chong Gu to steal the nodes and 
 * weights of the cubature for use in the
 * R package gss.
 *
 * The program implements the delayed Smolyak cubature
 * as discussed in the references by Knut Petras:
 *
 *     [1] Asymptotically minimal Smolyak cubature, 2000
 *     [2] Fast Calculation of Coefficients in the Smolyak Algorithm
 * 
 * Chong Gu, January 27, 2002, at Purdue.
 */

# include <math.h>
# include <stdio.h>
# include <stdlib.h>

/* replace # include "smolyak.h" by one line -- C. Gu */
# define maxdim 40
/* replace # include "smolyak.h" by one line -- C. Gu */

#define uniw 256    /* total # of nodes of quadrature formulae       */
#define fn 9        /* # of different basic formula                  */ 
#define gesfn 50    /* # of basic formulae  (incl. multiplicities)   */ 

static double quafo;                         /* cubature result             */
static double x[maxdim];                     /* function argument           */ 
static double xnu[fn][uniw],dnu[fn][uniw];   /* Delta-parameter             */
static double fsumme, wsum, wprod, summe;    /* working var's               */
static int d, q;                             /* cubature formula parameter  */
static int n[fn], ninv[fn], sw[gesfn];       /* working var's               */
       int count, wcount;       /* counter of f-calls and coefficient calls */

static int indeces[maxdim], argind[maxdim]; /* formula and nodal indeces    */
static int indsum[maxdim][maxdim];     /* parameter for 'divide et conquer' */

static int anzw[uniw], 
  lookind[fn][uniw], 
  invlook[fn][uniw], maxind;          /* tree parameter              */  

static int wind[maxdim];      /* Parameter for slow coefficient calculation */

static double (*f)(int, double x[]);         /* integrand (global)          */
static void formula(int,int);                /* sub-formula "between  
				                  two dimensions"    */
static double eval(int);                     /* sub-formula calculator      */
static double fsum(int);                     /* sum(f(+-x_nu))      
				                  (use of symmetry)         */

/* get pt and wt from formula1, eval1, fsum1 -- C. Gu */
static double wtt;
static void formula1(int, int, double *pt, double *wt);
static void eval1(int, double *pt, double *wt);
static void fsum1(int, double *pt, double *wt);
/* get pt and wt from formula1, eval1, fsum1 -- C. Gu */

static void init();                          /* initialization              */

static double calccoeff(int);                /* coefficient calculator      */
/* static double calccoeff2(int,int); */      /* coefficient calculator (slow)   */
static double wl(int, int, int);             /* 'divide                     */
static double we(int, int, int);             /*         and                 */
static void sumind(int, int);                /*            conquer'         */


/***************  tree definitions: *************************/

struct tnode {
  int empty;
  double *coeff;
  int *belegt;
  struct tnode *left;
  struct tnode *right;
};

static struct tnode *root;
 
static double coeff();                   /* tree manager            */

static struct tnode *talloc(void);       /* node generator          */
static void frei(struct tnode *p);       /* tree eraser             */
 

/* Start of R interface -- C. Gu */
double f_dummy(int dd, double x[])
{
    count++;
    return 1;
}
void size_smolyak(int *dd, int *qq, int *size)
/********************** get size  ***************************/
{
    d=*dd;
    q=*qq;
    f=f_dummy;
    init();
    formula(1,q-d);
    frei(root);
    *size = count;
}

void quad_smolyak(int *dd, int *qq, double *pt, double *wt)
/********************** get pt and wt  ***************************/
{
    d=*dd;
    q=*qq;
    f=f_dummy;
    init();
    formula1(1,q-d,pt,wt);
    frei(root);
}
/* End of R interface -- C. Gu */


double int_smolyak(int dd, int qq, double(*ff)(int,double xx[]), int size)
/********************** main program  ***************************/
     /*** for formula parameter  dd<40, qq-dd<48 ******/
{
 /* make parameter global:       */
  d=dd;
  q=qq;
  f=ff;
    /* Initialisation            */
  init();

  /* call of Smolyak algorithm   */
  formula(1,q-d);
  /* free space                  */
  frei(root);
 /* statistics ( if desired )    */
  /*  if (size) {                                   
    printf("%i function calls and ", count);      
    printf("%i coefficient calculations \n", wcount);}*/

  return quafo;
}

void formula(int k,int l)
     /* If k==d: evaluation.                         */
     /* Else:                                        */
     /*    determine the required  formula           */
     /* l is the index sum that may be distributed   */
     /* to the remaining dimensions                  */
{
  int i;
  if (k==d+1)
    {
      quafo =  quafo + eval(0);
    }
  else
    for (i=0; (i<=l) ; i++)
      /* Use only non-dummy-formulae                 */
      if (sw[i]<fn) {
	indeces[k] = sw[i];
	formula(k+1,l-i);
      };
}

/* get pt and wt from formula1 -- C. Gu */
void formula1(int k,int l, double *pt, double *wt)
{
    int i;
    if (k==d+1)
    {
	eval1(0,pt,wt);
    }
    else
	for (i=0; (i<=l) ; i++)
	    if (sw[i]<fn) {
		indeces[k] = sw[i];
		formula1(k+1,l-i,pt,wt);
	    };
}
/* get pt and wt from formula1 -- C. Gu */

double eval(int k)
     /* Calculates value of a product formula         */
{
  int i;
  double dummy;
  if (k==0) 
    {summe=0;
    dummy=eval(1);}
  else if (k==d+1)
    /* summation corresponding to one coefficient      */
    /* USUAL if uncommented  :                         */
    /*  summe = summe + calccoeff2(0,q-d) * fsum(0);   */
    /* DAC if uncommented    :                         */
    /*  summe = summe + calccoeff(q-d) * fsum(0);      */
    /* TREE (recommended method):                      */
  summe = summe +    coeff() * fsum(0); 
    /* all coefficients 1 (speed test)                 */
    /* summe = summe +  fsum(0);                       */
  else
    /* choice of the nodes                             */
    for (i=0; i<=n[indeces[k]]; i++)
      { 
	argind[k]=i;
	dummy=eval(k+1);
      };
  return summe;
}

/* get pt and wt from eval1 -- C. Gu */
void eval1(int k, double *pt, double *wt)
{
    int i;
    if (k==0)     eval1(1,pt,wt);
    else if (k==d+1) {
	wtt = coeff(); 
	fsum1(0,pt,wt); 
    }
    else 
	for (i=0; i<=n[indeces[k]]; i++)
	{ 
	    argind[k]=i;
	    eval1(k+1,pt,wt);
	};
}
/* get pt and wt from eval1 -- C. Gu */


/********************** Coefficients ************************/
/* Tree-functions: */

double coeff ( )
     /* looks for existing coefficient or calls its
	calculation                                         */
{
  int i,j;
  struct tnode *p, *pt;
  p=root;

    /* Initialisation                               */
  for (i=0; i<maxind; i++) anzw[i]=0;
  
    /* Frequency   anzw[  ] of 1-dim nodes          */
  for (i=1; i<=d; i++) anzw[lookind[indeces[i]][argind[i]]]++;
						
    /* Search in the tree according to anzw[..]     */
  for (j=maxind-1; j>=1; j--){
     
    /* anzw[j]  to the L E F T                                      */ 
    if (p->left==NULL){  /* if node not existing, node generation : */
      p->left = (struct tnode *) calloc(maxdim, sizeof(struct tnode));
      pt=(p->left+anzw[j]);
      pt->left=pt->right=NULL;
      pt->empty = 1;
      p=pt;}
    else
      p=(p->left+anzw[j]);
    
    /* one to the  R I G H T                                      */ 
    if (p->right==NULL){         /* if node not existing:         */
      pt=talloc();               /*    node generation            */
      pt->empty=1;
      pt->left=pt->right=NULL;
      if (j==1){                 /* leaf with coefficient         */
	pt->coeff=(double *) calloc(maxdim, sizeof(double));   
	pt->belegt=(int *) calloc(maxdim, sizeof(int));
	pt->empty=0;
      };
      p->right=pt;
    }; 
    p=p->right;
  }
  
   if (!*(p->belegt+anzw[0])){ /* evtl. coeff.-calc. necessary    */
     wcount++;
     *(p->coeff +anzw[0]) = calccoeff(q-d);
     *(p->belegt+anzw[0]) =1;
   };  
   return *(p->coeff +anzw[0]);
}

void frei(struct tnode *p)
       /* tree eraser         */
{
  if (!(p->empty)) {
    free (p->coeff); free (p->belegt);};
  if (!(p->left ==NULL)) frei(p->left);
  if (!(p->right ==NULL)) frei(p->right);
  free(p);
}

struct tnode *talloc(void)
     /* Space for new tree-node        */
{
  return (struct tnode *) malloc (sizeof(struct tnode));
}

/******** tree-functions finished ******/


void sumind(int r, int s)
     /* Calculation of sums of formula indices at division     
	of dimension r...s                                  */ 
{
  int q;
  if (s==r)
    indsum[r][s] = ninv[indeces[r]];
  else
    {
      q=(r+s)/2;
      sumind(r,q);
      sumind(q+1,s);
      indsum[r][s] = indsum[r][q] + indsum[q+1][s];
    };
}

 
double calccoeff (int l)
{
  sumind(1,d);         /* calculation of parameters of subdivision */
  return wl(1,d,l);    /* start of 'divide and conquer'            */ 
}

double wl(int r,int s, int l)
     /* sums in dimension s...r with sum of formula numbers    <=l */
{
 double sum=0;
  int i,q, p;
  if (r==s) /* one-dimensional */
    { 
      p=lookind[indeces[r]][argind[r]];
      for (i=ninv[indeces[r]]; i<=l; i++) {     
	  if (sw[i]<fn) {
	    if (i==0) sum+= dnu[0][0];
	    else {
	      if (indeces[r]==0) sum+=dnu[sw[i]][0];
	      else {
		sum+=dnu[sw[i]][invlook[sw[i]][p]];
	      }
	    }
	  }
      }
      return sum;
    }
  else /* dimension reduction */
    {
      q=(r+s)/2;
      for (i=indsum[r][q]; i<=l-indsum[q+1][s]; i++)
	sum+=we(r,q,i)*wl(q+1,s,l-i);
      return sum;
    };
}
      
double we(int r,int s, int l)
     /* sums in dimension s...r with sum of formula numbers    <=l */
{
  double sum=0;
  int i,q;
  if (r==s) {  /* one-dimensional */
    if (sw[l]<fn) {
      if (sw[l]==0) return dnu[0][0];
      else 
	if (indeces[r]==0) return dnu[sw[l]][0];
	else return dnu[sw[l]]
	       [invlook[sw[l]][lookind[indeces[r]][argind[r]]]];}
    else return 0;
  }
  else     /* dimension reduction */
    {
      q=(r+s)/2;
      for (i=indsum[r][q]; i<=l-indsum[q+1][s]; i++)
	sum+=we(r,q,i)*we(q+1,s,l-i);
      return sum;
    }
}





/********** method USUAL: (slow) ******************************/
/*

double calccoeff2 (int k, int l)
{
  int i;
  double dummy;
  if (k==0) 
    {
      wsum=0;
      wcount++;
      dummy=calccoeff2(1,l);}
  else if (k==d+1)
    {
      wprod = 1;
      for (i=1; i<=d; i++)
	if (indeces[i]==0)
	  wprod *= dnu[wind[i]][0];
	else
	  wprod *= 
	    dnu[wind[i]][invlook[wind[i]][lookind[indeces[i]][argind[i]]]];
      wsum+=wprod;
    }
  else
    {
      i=indeces[k];
      while (ninv[i]<=l){
	wind[k]=i;
	dummy=calccoeff2(k+1, l-ninv[i]);
	i++;}
    }
  return wsum;
}

*/
/************* coefficients finished     **********************/

/**************************************************************/

/************ sums of functions values sum(f(+/- x_i)) ********/

double fsum (int k)
{
  double dummy;
  if (k==0)
    {
      fsumme = 0;
      dummy=fsum(1);
    }
  else if (k==d+1)
    {
      fsumme+=(*f)(d,x);
    }
  else
    if (indeces[k]==0) /* differentiate 'central node', others */
      { 
	x[k-1]=0.5;
	dummy=fsum(k+1);
      }
    else
      {
	x[k-1]= xnu[indeces[k]][2*argind[k]+1];
	dummy=fsum(k+1);
	x[k-1] = 1-x[k-1];
	dummy=fsum(k+1);
      }  
  return fsumme;
}

/* get pt and wt from fsum1 -- C. Gu */
void fsum1 (int k, double *pt, double *wt)
{
    int i;
    if (k==0)       fsum1(1,pt,wt);
    else if (k==d+1)
    {
	for(i=0;i<d;i++) pt[d*count+i]=x[i];
	wt[count]=wtt;
	fsumme+=(*f)(d,x);
    }
    else
	if (indeces[k]==0)
	{ 
	    x[k-1]=0.5;
	    fsum1(k+1,pt,wt);
	}
	else
	{
	    x[k-1]= xnu[indeces[k]][2*argind[k]+1];
	    fsum1(k+1,pt,wt);
	    x[k-1] = 1-x[k-1];
	    fsum1(k+1,pt,wt);
	}  
}
/* get pt and wt from fsum1 -- C. Gu */


/**************************************************************/

/* initialisation  */

void init()
{ 
  int i, j, formfakt, maxform;
  int nj[fn]  ={1,3,7,15,31,63}; /* # nodes of different basic formulae */
  int freq[fn]={1,2,3, 6,12,24}; /* frequencies of basic formulae       */
  
   /* some parameter calculations           */
  n[0]=0;
  j=0;
  ninv[0]=0;
  for (i=1; i<fn; i++){
    n[i]=(nj[i]-nj[i-1]-2)/2;
    j=j+freq[i-1];
    ninv[i]=j;}

  for (i=0; i<gesfn; i++) sw[i]=fn;
  for (i=0; i<fn; i++) sw[ninv[i]]=i;
      
  /* output quantities                     */
  wcount=0;
  count=0;
  quafo=0; 
  
  
  /* number of the 'largest' used formula  */
  i=q-d;
  maxform=0;
  while (i>=ninv[maxform+1]) maxform=maxform+1;

  /* total number of used 1-dim nodes      */
  maxind = (nj[maxform]+1)/2;

 /* table of  1-dim nodal numbers 0..maxind-1  corresponding 
     to a  combination  formula number/nodal number
     and inverse formula                                      */
  lookind[0][0] = 0;
  for (i=1; i<=maxform; i++) {
    formfakt=pow(2, maxform-i);
    for (j=0; j<(nj[i]+1)/4; j++)  lookind[i][j] = formfakt*(2*j+1);
    /* in a linear ordering of all used nodes, the (2j+1)-th 
       node of the i-th basic formula is lookind[i][j]-th node   */
    for (j=0; j<(nj[i]+1)/2; j++)  invlook[i][formfakt*j] = j;
    /* the lookind[i][2^(maxform-i)]-th node in a linear 
       ordering of all used nodes is the j-th node of the 
       i-th basic formula. Note that maxrorm is the number
       of used different basic formulae                          */ 
  };

  
  /* root of the coefficient TREE      */
  root=talloc();
  root->empty=1;
  root->left=root->right=NULL;

  /* one dimensional formulae (Deltas) */


xnu[0][0] = 0.5;
dnu[0][0] = 1.0;
xnu[1][0] =  5.000000000000000E-001;
xnu[1][1] =  8.8729833462074168851793E-001;
dnu[1][0] = -5.5555555555555555555556E-001;
dnu[1][1] =  2.7777777777777777777778E-001;
xnu[2][0] =  5.0000000000000000000000E-001;
xnu[2][1] =  7.1712187467340127900104E-001;
xnu[2][2] =  8.8729833462074168851793E-001;
xnu[2][3] =  9.8024563435401014171175E-001;
dnu[2][0] = -2.1898617511520737327189E-001;
dnu[2][1] =  2.0069870738798111145253E-001;
dnu[2][2] = -1.4353373284361105741349E-001;
dnu[2][3] =  5.2328113013233632596912E-002;
xnu[3][0] =  5.0000000000000000000000E-001;
xnu[3][1] =  6.1169334321448344081410E-001;
xnu[3][2] =  7.1712187467340127900104E-001;
xnu[3][3] =  8.1055147336861320147034E-001;
xnu[3][4] =  8.8729833462074168851793E-001;
xnu[3][5] =  9.4422961643612849944521E-001;
xnu[3][6] =  9.8024563435401014171175E-001;
xnu[3][7] =  9.9691598160637751110426E-001;
dnu[3][0] = -1.1270301943013372747934E-001;
dnu[3][1] =  1.0957842920079374820185E-001;
dnu[3][2] = -1.0038444269948660093556E-001;
dnu[3][3] =  8.5755954568195690393677E-002;
dnu[3][4] = -6.7036417312274610184300E-002;
dnu[3][5] =  4.6463597657562268842947E-002;
dnu[3][6] = -2.6526471514693762748452E-002;
dnu[3][7] =  8.5008598149701301695137E-003;
xnu[4][0] =  5.0000000000000000000000E-001;
xnu[4][1] =  5.5624447156659331287292E-001;
xnu[4][2] =  6.1169334321448344081410E-001;
xnu[4][3] =  6.6556769662898841654632E-001;
xnu[4][4] =  7.1712187467340127900104E-001;
xnu[4][5] =  7.6565987182218781198605E-001;
xnu[4][6] =  8.1055147336861320147034E-001;
xnu[4][7] =  8.5124810324576353930490E-001;
xnu[4][8] =  8.8729833462074168851793E-001;
xnu[4][9] =  9.1836296908443436775138E-001;
xnu[4][10] =  9.4422961643612849944521E-001;
xnu[4][11] =  9.6482742871487002833506E-001;
xnu[4][12] =  9.8024563435401014171175E-001;
xnu[4][13] =  9.9076557477687005343368E-001;
xnu[4][14] =  9.9691598160637751110426E-001;
xnu[4][15] =  9.9954906248383379883111E-001;
dnu[4][0] = -5.6377621538718997889636E-002;
dnu[4][1] =  5.5978436510476728440072E-002;
dnu[4][2] = -5.4789218672831429083502E-002;
dnu[4][3] =  5.2834946790117404871908E-002;
dnu[4][4] = -5.0157125382596721131319E-002;
dnu[4][5] =  4.6813554990632236808329E-002;
dnu[4][6] = -4.2877994543200514816583E-002;
dnu[4][7] =  3.8439810249501765521353E-002;
dnu[4][8] = -3.3603750473896758409784E-002;
dnu[4][9] =  2.8489754747061678706099E-002;
dnu[4][10] = -2.3232151026683275572245E-002;
dnu[4][11] =  1.7978551653564661048389E-002;
dnu[4][12] = -1.2897842450451543066137E-002;
dnu[4][13] =  8.2230249271939054668942E-003;
dnu[4][14] = -4.2835769453095770463562E-003;
dnu[4][15] =  1.2723903957809372077014E-003;
xnu[5][0] =  5.0000000000000000000000E-001;
xnu[5][1] =  5.2817215652329639498598E-001;
xnu[5][2] =  5.5624447156659331287292E-001;
xnu[5][3] =  5.8411762577610373249116E-001;
xnu[5][4] =  6.1169334321448344081410E-001;
xnu[5][5] =  6.3887491101091215753268E-001;
xnu[5][6] =  6.6556769662898841654632E-001;
xnu[5][7] =  6.9167966209936517345824E-001;
xnu[5][8] =  7.1712187467340127900104E-001;
xnu[5][9] =  7.4180901347292051378108E-001;
xnu[5][10] =  7.6565987182218781198605E-001;
xnu[5][11] =  7.8859785502602290742185E-001;
xnu[5][12] =  8.1055147336861320147034E-001;
xnu[5][13] =  8.3145483001239029773051E-001;
xnu[5][14] =  8.5124810324576353930490E-001;
xnu[5][15] =  8.6987802217634737933861E-001;
xnu[5][16] =  8.8729833462074168851793E-001;
xnu[5][17] =  9.0347026597510880592815E-001;
xnu[5][18] =  9.1836296908443436775138E-001;
xnu[5][19] =  9.3195396909684523857321E-001;
xnu[5][20] =  9.4422961643612849944521E-001;
xnu[5][21] =  9.5518557847850214624890E-001;
xnu[5][22] =  9.6482742871487002833506E-001;
xnu[5][23] =  9.7317142918670145257425E-001;
xnu[5][24] =  9.8024563435401014171175E-001;
xnu[5][25] =  9.8609143737429089828903E-001;
xnu[5][26] =  9.9076557477687005343368E-001;
xnu[5][27] =  9.9434237877371473996926E-001;
xnu[5][28] =  9.9691598160637751110426E-001;
xnu[5][29] =  9.9860312968611097953823E-001;
xnu[5][30] =  9.9954906248383379883111E-001;
xnu[5][31] =  9.9993644406017880596898E-001;
dnu[5][0] = -2.8188814180191987109744E-002;
dnu[5][1] =  2.8138849915627150636298E-002;
dnu[5][2] = -2.7989218255238568736295E-002;
dnu[5][3] =  2.7740702178279681993919E-002;
dnu[5][4] = -2.7394605263980886602235E-002;
dnu[5][5] =  2.6952749667633031963438E-002;
dnu[5][6] = -2.6417473395059144940870E-002;
dnu[5][7] =  2.5791626976024229388405E-002;
dnu[5][8] = -2.5078569652948020678807E-002;
dnu[5][9] =  2.4282165203336599357974E-002;
dnu[5][10] = -2.3406777495318230607005E-002;
dnu[5][11] =  2.2457265826816098707127E-002;
dnu[5][12] = -2.1438980012491308330637E-002;
dnu[5][13] =  2.0357755058472159466947E-002;
dnu[5][14] = -1.9219905124773999502032E-002;
dnu[5][15] =  1.8032216390391286320054E-002;
dnu[5][16] = -1.6801938573891486499334E-002;
dnu[5][17] =  1.5536775555843982439942E-002;
dnu[5][18] = -1.4244877374144904399846E-002;
dnu[5][19] =  1.2934839663607373455379E-002;
dnu[5][20] = -1.1615723310923858549074E-002;
dnu[5][21] =  1.0297116957956355574594E-002;
dnu[5][22] = -8.9892758695005258819409E-003;
dnu[5][23] =  7.7033752332797489010654E-003;
dnu[5][24] = -6.4518989979126939693347E-003;
dnu[5][25] =  5.2491234548106609491364E-003;
dnu[5][26] = -4.1115209485759406322653E-003;
dnu[5][27] =  3.0577534110586231698391E-003;
dnu[5][28] = -2.1084676488811257036154E-003;
dnu[5][29] =  1.2895248973428441362139E-003;
dnu[5][30] = -6.3981211766590320201509E-004;
dnu[5][31] =  1.8161074092276532984679E-004;
xnu[6][0] =  5.0000000000000000000000E-001;
xnu[6][1] =  5.1409232447487284716970E-001;
xnu[6][2] =  5.2817215652329639498598E-001;
xnu[6][3] =  5.4222702004185544185509E-001;
xnu[6][4] =  5.5624447156659331287292E-001;
xnu[6][5] =  5.7021211657628008729691E-001;
xnu[6][6] =  5.8411762577610373249116E-001;
xnu[6][7] =  5.9794875135555007695773E-001;
xnu[6][8] =  6.1169334321448344081410E-001;
xnu[6][9] =  6.2533936515174158830648E-001;
xnu[6][10] =  6.3887491101091215753268E-001;
xnu[6][11] =  6.5228822077835702166766E-001;
xnu[6][12] =  6.6556769662898841654632E-001;
xnu[6][13] =  6.7870191891576607618811E-001;
xnu[6][14] =  6.9167966209936517345824E-001;
xnu[6][15] =  7.0448991061494433620452E-001;
xnu[6][16] =  7.1712187467340127900104E-001;
xnu[6][17] =  7.2956500599491616643675E-001;
xnu[6][18] =  7.4180901347292051378108E-001;
xnu[6][19] =  7.5384387876685830107739E-001;
xnu[6][20] =  7.6565987182218781198605E-001;
xnu[6][21] =  7.7724756631596627443319E-001;
xnu[6][22] =  7.8859785502602290742185E-001;
xnu[6][23] =  7.9970196512112144648713E-001;
xnu[6][24] =  8.1055147336861320147034E-001;
xnu[6][25] =  8.2113832125487975688706E-001;
xnu[6][26] =  8.3145483001239029773051E-001;
xnu[6][27] =  8.4149371554553961404354E-001;
xnu[6][28] =  8.5124810324576353930490E-001;
xnu[6][29] =  8.6071154268504945774249E-001;
xnu[6][30] =  8.6987802217634737933861E-001;
xnu[6][31] =  8.7874198319025681896313E-001;
xnu[6][32] =  8.8729833462074168851793E-001;
xnu[6][33] =  8.9554246689992418071732E-001;
xnu[6][34] =  9.0347026597510880592815E-001;
xnu[6][35] =  9.1107812718249020368626E-001;
xnu[6][36] =  9.1836296908443436775138E-001;
xnu[6][37] =  9.2532224738417513987891E-001;
xnu[6][38] =  9.3195396909684523857321E-001;
xnu[6][39] =  9.3825670724235263487081E-001;
xnu[6][40] =  9.4422961643612849944521E-001;
xnu[6][41] =  9.4987244988847001831932E-001;
xnu[6][42] =  9.5518557847850214624890E-001;
xnu[6][43] =  9.6017001273500621036491E-001;
xnu[6][44] =  9.6482742871487002833506E-001;
xnu[6][45] =  9.6916019888979644182741E-001;
xnu[6][46] =  9.7317142918670145257425E-001;
xnu[6][47] =  9.7686500321288056820737E-001;
xnu[6][48] =  9.8024563435401014171175E-001;
xnu[6][49] =  9.8331892577920828354614E-001;
xnu[6][50] =  9.8609143737429089828903E-001;
xnu[6][51] =  9.8857075731985285707820E-001;
xnu[6][52] =  9.9076557477687005343368E-001;
xnu[6][53] =  9.9268574979926018555688E-001;
xnu[6][54] =  9.9434237877371473996926E-001;
xnu[6][55] =  9.9574786058905306619925E-001;
xnu[6][56] =  9.9691598160637751110426E-001;
xnu[6][57] =  9.9786205234920359425472E-001;
xnu[6][58] =  9.9860312968611097953823E-001;
xnu[6][59] =  9.9915831765920369626532E-001;
xnu[6][60] =  9.9954906248383379883111E-001;
xnu[6][61] =  9.9979939983595534162598E-001;
xnu[6][62] =  9.9993644406017880596898E-001;
xnu[6][63] =  9.9999121517744579929001E-001;
dnu[6][0] = -1.4094407090096179346916E-002;
dnu[6][1] =  1.4088159516508301065327E-002;
dnu[6][2] = -1.4069424957813575318149E-002;
dnu[6][3] =  1.4038227896908623303424E-002;
dnu[6][4] = -1.3994609127619079851888E-002;
dnu[6][5] =  1.3938625738306850804262E-002;
dnu[6][6] = -1.3870351089139840996960E-002;
dnu[6][7] =  1.3789874783240936517434E-002;
dnu[6][8] = -1.3697302631990716258054E-002;
dnu[6][9] =  1.3592756614812395909604E-002;
dnu[6][10] = -1.3476374833816515981719E-002;
dnu[6][11] =  1.3348311463725179953077E-002;
dnu[6][12] = -1.3208736697529129965519E-002;
dnu[6][13] =  1.3057836688353048840249E-002;
dnu[6][14] = -1.2895813488012114694202E-002;
dnu[6][15] =  1.2722884982732382906287E-002;
dnu[6][16] = -1.2539284826474884353420E-002;
dnu[6][17] =  1.2345262372243838454530E-002;
dnu[6][18] = -1.2141082601668299678987E-002;
dnu[6][19] =  1.1927026053019270040223E-002;
dnu[6][20] = -1.1703388747657003100662E-002;
dnu[6][21] =  1.1470482114693874380400E-002;
dnu[6][22] = -1.1228632913408049353564E-002;
dnu[6][23] =  1.0978183152658912469630E-002;
dnu[6][24] = -1.0719490006251933623228E-002;
dnu[6][25] =  1.0452925722906011926111E-002;
dnu[6][26] = -1.0178877529236079733474E-002;
dnu[6][27] =  9.8977475240487497440139E-003;
dnu[6][28] = -9.6099525623638830096600E-003;
dnu[6][29] =  9.3159241280693950931570E-003;
dnu[6][30] = -9.0161081951956431600270E-003;
dnu[6][31] =  8.7109650797320868735761E-003;
dnu[6][32] = -8.4009692870519326354323E-003;
dnu[6][33] =  8.0866093647888599709740E-003;
dnu[6][34] = -7.7683877779219912199780E-003;
dnu[6][35] =  7.4468208324075910174052E-003;
dnu[6][36] = -7.1224386864583871530823E-003;
dnu[6][37] =  6.7957855048827733947865E-003;
dnu[6][38] = -6.4674198318036867280122E-003;
dnu[6][39] =  6.1379152800413850434832E-003;
dnu[6][40] = -5.8078616599775673581358E-003;
dnu[6][41] =  5.4778666939189508240164E-003;
dnu[6][42] = -5.1485584789781778127510E-003;
dnu[6][43] =  4.8205888648512683476492E-003;
dnu[6][44] = -4.4946378920320673048077E-003;
dnu[6][45] =  4.1714193769840788527921E-003;
dnu[6][46] = -3.8516876166398779769824E-003;
dnu[6][47] =  3.5362449977167777340232E-003;
dnu[6][48] = -3.2259500250877643515858E-003;
dnu[6][49] =  2.9217249379178197537798E-003;
dnu[6][50] = -2.6245617274062313865695E-003;
dnu[6][51] =  2.3355251860571608737027E-003;
dnu[6][52] = -2.0557519892906183110438E-003;
dnu[6][53] =  1.7864463917586498246922E-003;
dnu[6][54] = -1.5288767059708576017734E-003;
dnu[6][55] =  1.2843824718970101865639E-003;
dnu[6][56] = -1.0544075979161109798758E-003;
dnu[6][57] =  8.4057143271073495315687E-004;
dnu[6][58] = -6.4476285603763544016464E-004;
dnu[6][59] =  4.6918492427119075039702E-004;
dnu[6][60] = -3.1627461843371723357680E-004;
dnu[6][61] =  1.8887332316349233013718E-004;
dnu[6][62] = -9.1240958700071150936623E-005;
dnu[6][63] =  2.5268047603931258812333E-005;
xnu[7][0] =  5.0000000000000000000000E-001;
xnu[7][1] =  5.0704694320539123130709E-001;
xnu[7][2] =  5.1409232447487284716970E-001;
xnu[7][3] =  5.2113458238268180160620E-001;
xnu[7][4] =  5.2817215652329639498598E-001;
xnu[7][5] =  5.3520348802142758953165E-001;
xnu[7][6] =  5.4222702004185544185509E-001;
xnu[7][7] =  5.4924119829905960104514E-001;
xnu[7][8] =  5.5624447156659331287292E-001;
xnu[7][9] =  5.6323529218615098342533E-001;
xnu[7][10] =  5.7021211657628008729691E-001;
xnu[7][11] =  5.7717340574068905434622E-001;
xnu[7][12] =  5.8411762577610373249116E-001;
xnu[7][13] =  5.9104324837962609912320E-001;
xnu[7][14] =  5.9794875135555007695773E-001;
xnu[7][15] =  6.0483261912159059738317E-001;
xnu[7][16] =  6.1169334321448344081410E-001;
xnu[7][17] =  6.1852942279491486360633E-001;
xnu[7][18] =  6.2533936515174158830648E-001;
xnu[7][19] =  6.3212168620546338097247E-001;
xnu[7][20] =  6.3887491101091215753268E-001;
xnu[7][21] =  6.4559757425912334098185E-001;
xnu[7][22] =  6.5228822077835702166766E-001;
xnu[7][23] =  6.5894540603423834159087E-001;
xnu[7][24] =  6.6556769662898841654632E-001;
xnu[7][25] =  6.7215367079971901138831E-001;
xnu[7][26] =  6.7870191891576607618811E-001;
xnu[7][27] =  6.8521104397503911506877E-001;
xnu[7][28] =  6.9167966209936517345824E-001;
xnu[7][29] =  6.9810640302880796959126E-001;
xnu[7][30] =  7.0448991061494433620452E-001;
xnu[7][31] =  7.1082884331308165002815E-001;
xnu[7][32] =  7.1712187467340127900104E-001;
xnu[7][33] =  7.2336769383101423687111E-001;
xnu[7][34] =  7.2956500599491616643675E-001;
xnu[7][35] =  7.3571253293582943846704E-001;
xnu[7][36] =  7.4180901347292051378108E-001;
xnu[7][37] =  7.4785320395938073008506E-001;
xnu[7][38] =  7.5384387876685830107739E-001;
xnu[7][39] =  7.5977983076872851099646E-001;
xnu[7][40] =  7.6565987182218781198605E-001;
xnu[7][41] =  7.7148283324915574524615E-001;
xnu[7][42] =  7.7724756631596627443319E-001;
xnu[7][43] =  7.8295294271182721131149E-001;
xnu[7][44] =  7.8859785502602290742185E-001;
xnu[7][45] =  7.9418121722383127071718E-001;
xnu[7][46] =  7.9970196512112144648713E-001;
xnu[7][47] =  8.0515905685759320007779E-001;
xnu[7][48] =  8.1055147336861320147034E-001;
xnu[7][49] =  8.1587821885559711520679E-001;
xnu[7][50] =  8.2113832125487975688706E-001;
xnu[7][51] =  8.2633083270500874805039E-001;
xnu[7][52] =  8.3145483001239029773051E-001;
xnu[7][53] =  8.3650941511520923959944E-001;
xnu[7][54] =  8.4149371554553961404354E-001;
xnu[7][55] =  8.4640688488955735144733E-001;
xnu[7][56] =  8.5124810324576353930490E-001;
xnu[7][57] =  8.5601657768112601729334E-001;
xnu[7][58] =  8.6071154268504945774249E-001;
xnu[7][59] =  8.6533226062109063066465E-001;
xnu[7][60] =  8.6987802217634737933861E-001;
xnu[7][61] =  8.7434814680846830141141E-001;
xnu[7][62] =  8.7874198319025681896313E-001;
xnu[7][63] =  8.8305890965188004535834E-001;
xnu[7][64] =  8.8729833462074168851793E-001;
xnu[7][65] =  8.9145969705914150819259E-001;
xnu[7][66] =  8.9554246689992418071732E-001;
xnu[7][67] =  8.9954614548042070089990E-001;
xnu[7][68] =  9.0347026597510880592815E-001;
xnu[7][69] =  9.0731439382756870671791E-001;
xnu[7][70] =  9.1107812718249020368626E-001;
xnu[7][71] =  9.1476109731870070008905E-001;
xnu[7][72] =  9.1836296908443436775138E-001;
xnu[7][73] =  9.2188344133635430051916E-001;
xnu[7][74] =  9.2532224738417513987891E-001;
xnu[7][75] =  9.2867915544311607826256E-001;
xnu[7][76] =  9.3195396909684523857321E-001;
xnu[7][77] =  9.3514652777405695292558E-001;
xnu[7][78] =  9.3825670724235263487081E-001;
xnu[7][79] =  9.4128442012367095342085E-001;
xnu[7][80] =  9.4422961643612849944521E-001;
xnu[7][81] =  9.4709228416777951142968E-001;
xnu[7][82] =  9.4987244988847001831932E-001;
xnu[7][83] =  9.5257017940663079759465E-001;
xnu[7][84] =  9.5518557847850214624890E-001;
xnu[7][85] =  9.5771879357788252032198E-001;
xnu[7][86] =  9.6017001273500621036491E-001;
xnu[7][87] =  9.6253946645353782618207E-001;
xnu[7][88] =  9.6482742871487002833506E-001;
xnu[7][89] =  9.6703421807886289399974E-001;
xnu[7][90] =  9.6916019888979644182741E-001;
xnu[7][91] =  9.7120578259554152990628E-001;
xnu[7][92] =  9.7317142918670145257425E-001;
xnu[7][93] =  9.7505764876064743827892E-001;
xnu[7][94] =  9.7686500321288056820737E-001;
xnu[7][95] =  9.7859410805493048136810E-001;
xnu[7][96] =  9.8024563435401014171175E-001;
xnu[7][97] =  9.8182031078490606626049E-001;
xnu[7][98] =  9.8331892577920828354614E-001;
xnu[7][99] =  9.8474232975122961588545E-001;
xnu[7][100] =  9.8609143737429089828903E-001;
xnu[7][101] =  9.8736722987620133388036E-001;
xnu[7][102] =  9.8857075731985285707820E-001;
xnu[7][103] =  9.8970314083543134190307E-001;
xnu[7][104] =  9.9076557477687005343368E-001;
xnu[7][105] =  9.9175932878931636438083E-001;
xnu[7][106] =  9.9268574979926018555688E-001;
xnu[7][107] =  9.9354626397701703359495E-001;
xnu[7][108] =  9.9434237877371473996926E-001;
xnu[7][109] =  9.9507568520038507959027E-001;
xnu[7][110] =  9.9574786058905306619925E-001;
xnu[7][111] =  9.9636067214139430766410E-001;
xnu[7][112] =  9.9691598160637751110426E-001;
xnu[7][113] =  9.9741575140031050025957E-001;
xnu[7][114] =  9.9786205234920359425472E-001;
xnu[7][115] =  9.9825707295744513692434E-001;
xnu[7][116] =  9.9860312968611097953823E-001;
xnu[7][117] =  9.9890267724797863728092E-001;
xnu[7][118] =  9.9915831765920369626532E-001;
xnu[7][119] =  9.9937280723404755735176E-001;
xnu[7][120] =  9.9954906248383379883111E-001;
xnu[7][121] =  9.9969016901251179096404E-001;
xnu[7][122] =  9.9979939983595534162598E-001;
xnu[7][123] =  9.9988024546221602366522E-001;
xnu[7][124] =  9.9993644406017880596898E-001;
xnu[7][125] =  9.9997199810352718788193E-001;
xnu[7][126] =  9.9999121517744579929001E-001;
xnu[7][127] =  9.9999879818987423231012E-001;
dnu[7][0] = -7.0472035450480896734578E-003;
dnu[7][1] =  7.0464225345802041774796E-003;
dnu[7][2] = -7.0440797582541505326634E-003;
dnu[7][3] =  7.0401759812768306624229E-003;
dnu[7][4] = -7.0347124789067876590744E-003;
dnu[7][5] =  7.0276910363249821385840E-003;
dnu[7][6] = -7.0191139484543116517120E-003;
dnu[7][7] =  7.0089840197283044049361E-003;
dnu[7][8] = -6.9973045638095399259442E-003;
dnu[7][9] =  6.9840794032584692578639E-003;
dnu[7][10] = -6.9693128691534254021309E-003;
dnu[7][11] =  6.9530098006627306317656E-003;
dnu[7][12] = -6.9351755445699204984798E-003;
dnu[7][13] =  6.9158159547532143382480E-003;
dnu[7][14] = -6.8949373916204682587172E-003;
dnu[7][15] =  6.8725467215009483161260E-003;
dnu[7][16] = -6.8486513159953581290272E-003;
dnu[7][17] =  6.8232590512856457141999E-003;
dnu[7][18] = -6.7963783074061979548022E-003;
dnu[7][19] =  6.7680179674781068068327E-003;
dnu[7][20] = -6.7381874169082579908596E-003;
dnu[7][21] =  6.7068965425550492564832E-003;
dnu[7][22] = -6.6741557318625899765387E-003;
dnu[7][23] =  6.6399758719652653251888E-003;
dnu[7][24] = -6.6043683487645649827596E-003;
dnu[7][25] =  6.5673450459800764181907E-003;
dnu[7][26] = -6.5289183441765244201247E-003;
dnu[7][27] =  6.4891011197686996429211E-003;
dnu[7][28] = -6.4479067440060573471011E-003;
dnu[7][29] =  6.4053490819386809834209E-003;
dnu[7][30] = -6.3614424913661914531436E-003;
dnu[7][31] =  6.3162018217710393822703E-003;
dnu[7][32] = -6.2696424132374421767099E-003;
dnu[7][33] =  6.2217800953570176315748E-003;
dnu[7][34] = -6.1726311861219192272652E-003;
dnu[7][35] =  6.1222124908059929493146E-003;
dnu[7][36] = -6.0705413008341498394934E-003;
dnu[7][37] =  6.0176353926397813152249E-003;
dnu[7][38] = -5.9635130265096350201115E-003;
dnu[7][39] =  5.9081929454151178816124E-003;
dnu[7][40] = -5.8516943738285015503310E-003;
dnu[7][41] =  5.7940370165219762842120E-003;
dnu[7][42] = -5.7352410573469371902001E-003;
dnu[7][43] =  5.6753271579902983008672E-003;
dnu[7][44] = -5.6143164567040246767818E-003;
dnu[7][45] =  5.5522305670034632684997E-003;
dnu[7][46] = -5.4890915763294562348151E-003;
dnu[7][47] =  5.4249220446686570495123E-003;
dnu[7][48] = -5.3597450031259668116140E-003;
dnu[7][49] =  5.2935839524425989654714E-003;
dnu[7][50] = -5.2264628614530059630555E-003;
dnu[7][51] =  5.1584061654738108409604E-003;
dnu[7][52] = -5.0894387646180398667368E-003;
dnu[7][53] =  5.0195860220284203990905E-003;
dnu[7][54] = -4.9488737620243748720069E-003;
dnu[7][55] =  4.8773282681587057305415E-003;
dnu[7][56] = -4.8049762811819415048301E-003;
dnu[7][57] =  4.7318449969150326471362E-003;
dnu[7][58] = -4.6579620640346975465785E-003;
dnu[7][59] =  4.5833555817803942033526E-003;
dnu[7][60] = -4.5080540975978215800133E-003;
dnu[7][61] =  4.4320866047412471320571E-003;
dnu[7][62] = -4.3554825398660434367881E-003;
dnu[7][63] =  4.2782717806538448095865E-003;
dnu[7][64] = -4.2004846435259663177174E-003;
dnu[7][65] =  4.1221518815164340152753E-003;
dnu[7][66] = -4.0433046823944299854870E-003;
dnu[7][67] =  3.9639746671474245551263E-003;
dnu[7][68] = -3.8841938889609956099821E-003;
dnu[7][69] =  3.8039948328595282916087E-003;
dnu[7][70] = -3.7234104162037955087026E-003;
dnu[7][71] =  3.6424739902769035319399E-003;
dnu[7][72] = -3.5612193432291935765854E-003;
dnu[7][73] =  3.4796807046952114697225E-003;
dnu[7][74] = -3.3978927524413866973932E-003;
dnu[7][75] =  3.3158906214509439470610E-003;
dnu[7][76] = -3.2337099159018433636835E-003;
dnu[7][77] =  3.1513867245428793585820E-003;
dnu[7][78] = -3.0689576400206925217416E-003;
dnu[7][79] =  2.9864597827540829024736E-003;
dnu[7][80] = -2.9039308299887836817462E-003;
dnu[7][81] =  2.8214090506922220792273E-003;
dnu[7][82] = -2.7389333469594754120082E-003;
dnu[7][83] =  2.6565433025935282831440E-003;
dnu[7][84] = -2.5742792394890888809216E-003;
dnu[7][85] =  2.4921822823827693006000E-003;
dnu[7][86] = -2.4102944324256341738246E-003;
dnu[7][87] =  2.3286586498784273886390E-003;
dnu[7][88] = -2.2473189460160339308202E-003;
dnu[7][89] =  2.1663204840464914272688E-003;
dnu[7][90] = -2.0857096884920394263960E-003;
dnu[7][91] =  2.0055343620375116994450E-003;
dnu[7][92] = -1.9258438083199354620415E-003;
dnu[7][93] =  1.8466889585128254091286E-003;
dnu[7][94] = -1.7681224988583888670116E-003;
dnu[7][95] =  1.6901989955434601911750E-003;
dnu[7][96] = -1.6129750125439342307013E-003;
dnu[7][97] =  1.5365092173512891617039E-003;
dnu[7][98] = -1.4608624689589098768899E-003;
dnu[7][99] =  1.3860978822967254969976E-003;
dnu[7][100] = -1.3122808637022147812835E-003;
dnu[7][101] =  1.2394791133287839653391E-003;
dnu[7][102] = -1.1677625930285804368514E-003;
dnu[7][103] =  1.0972034626819194194015E-003;
dnu[7][104] = -1.0278759946636732617923E-003;
dnu[7][105] =  9.5985648550693620626136E-004;
dnu[7][106] = -8.9322319587932491235173E-004;
dnu[7][107] =  8.2805636407722630260841E-004;
dnu[7][108] = -7.6443835254388278387516E-004;
dnu[7][109] =  7.0245399782757232135761E-004;
dnu[7][110] = -6.4219123594850509816130E-004;
dnu[7][111] =  5.8374205871497970384667E-004;
dnu[7][112] = -5.2720381143165805354149E-004;
dnu[7][113] =  4.7268075842926269123151E-004;
dnu[7][114] = -4.2028571635537372133344E-004;
dnu[7][115] =  3.7014140212225166523158E-004;
dnu[7][116] = -3.2238102065234630638566E-004;
dnu[7][117] =  2.7714765746518735745887E-004;
dnu[7][118] = -2.3459246214726554551974E-004;
dnu[7][119] =  1.9487264223664114660778E-004;
dnu[7][120] = -1.5815182927018453366651E-004;
dnu[7][121] =  1.2460620024149864701227E-004;
dnu[7][122] = -9.4436690910239873306717E-005;
dnu[7][123] =  6.7877455474614359864921E-005;
dnu[7][124] = -4.5183414893318604279565E-005;
dnu[7][125] =  2.6637646834890306562676E-005;
dnu[7][126] = -1.2689112411790928068031E-005;
dnu[7][127] =  3.4689682162054133584769E-006;
xnu[8][0] =  5.0000000000000000000000E-001;
xnu[8][1] =  5.0352356922966837324257E-001;
xnu[8][2] =  5.0704694320539123130709E-001;
xnu[8][3] =  5.1056992668916554416748E-001;
xnu[8][4] =  5.1409232447487284716970E-001;
xnu[8][5] =  5.1761394140422051163016E-001;
xnu[8][6] =  5.2113458238268180160620E-001;
xnu[8][7] =  5.2465405239543431335782E-001;
xnu[8][8] =  5.2817215652329639498598E-001;
xnu[8][9] =  5.3168869995866114493983E-001;
xnu[8][10] =  5.3520348802142758953165E-001;
xnu[8][11] =  5.3871632617492864128376E-001;
xnu[8][12] =  5.4222702004185544185509E-001;
xnu[8][13] =  5.4573537542017769545473E-001;
xnu[8][14] =  5.4924119829905960104514E-001;
xnu[8][15] =  5.5274429487477099426633E-001;
xnu[8][16] =  5.5624447156659331287292E-001;
xnu[8][17] =  5.5974153503272000256669E-001;
xnu[8][18] =  5.6323529218615098342533E-001;
xnu[8][19] =  5.6672555021058080067206E-001;
xnu[8][20] =  5.7021211657628008729691E-001;
xnu[8][21] =  5.7369479905596997002704E-001;
xnu[8][22] =  5.7717340574068905434622E-001;
xnu[8][23] =  5.8064774505565262868030E-001;
xnu[8][24] =  5.8411762577610373249116E-001;
xnu[8][25] =  5.8758285704315573785372E-001;
xnu[8][26] =  5.9104324837962609912320E-001;
xnu[8][27] =  5.9449860970586093052960E-001;
xnu[8][28] =  5.9794875135555007695773E-001;
xnu[8][29] =  6.0139348409153234877826E-001;
xnu[8][30] =  6.0483261912159059738317E-001;
xnu[8][31] =  6.0826596811423631404069E-001;
xnu[8][32] =  6.1169334321448344081410E-001;
xnu[8][33] =  6.1511455705961108857785E-001;
xnu[8][34] =  6.1852942279491486360633E-001;
xnu[8][35] =  6.2193775408944651079646E-001;
xnu[8][36] =  6.2533936515174158830648E-001;
xnu[8][37] =  6.2873407074553489524063E-001;
xnu[8][38] =  6.3212168620546338097247E-001;
xnu[8][39] =  6.3550202745275627176810E-001;
xnu[8][40] =  6.3887491101091215753268E-001;
xnu[8][41] =  6.4224015402136278874800E-001;
xnu[8][42] =  6.4559757425912334098185E-001;
xnu[8][43] =  6.4894699014842891171828E-001;
xnu[8][44] =  6.5228822077835702166766E-001;
xnu[8][45] =  6.5562108591843590015010E-001;
xnu[8][46] =  6.5894540603423834159087E-001;
xnu[8][47] =  6.6226100230296092760332E-001;
xnu[8][48] =  6.6556769662898841654632E-001;
xnu[8][49] =  6.6886531165944310981029E-001;
xnu[8][50] =  6.7215367079971901138831E-001;
xnu[8][51] =  6.7543259822900060450540E-001;
xnu[8][52] =  6.7870191891576607618811E-001;
xnu[8][53] =  6.8196145863327482763471E-001;
xnu[8][54] =  6.8521104397503911506877E-001;
xnu[8][55] =  6.8845050237027967240092E-001;
xnu[8][56] =  6.9167966209936517345824E-001;
xnu[8][57] =  6.9489835230923539773967E-001;
xnu[8][58] =  6.9810640302880796959126E-001;
xnu[8][59] =  7.0130364518436854633556E-001;
xnu[8][60] =  7.0448991061494433620452E-001;
xnu[8][61] =  7.0766503208766083188217E-001;
xnu[8][62] =  7.1082884331308165002815E-001;
xnu[8][63] =  7.1398117896053137129164E-001;
xnu[8][64] =  7.1712187467340127900104E-001;
xnu[8][65] =  7.2025076708443789789144E-001;
xnu[8][66] =  7.2336769383101423687111E-001;
xnu[8][67] =  7.2647249357038364189194E-001;
xnu[8][68] =  7.2956500599491616643675E-001;
xnu[8][69] =  7.3264507184731736792908E-001;
xnu[8][70] =  7.3571253293582943846704E-001;
xnu[8][71] =  7.3876723214941457764179E-001;
xnu[8][72] =  7.4180901347292051378108E-001;
xnu[8][73] =  7.4483772200222807771818E-001;
xnu[8][74] =  7.4785320395938073008506E-001;
xnu[8][75] =  7.5085530670769593912527E-001;
xnu[8][76] =  7.5384387876685830107739E-001;
xnu[8][77] =  7.5681876982799428925371E-001;
xnu[8][78] =  7.5977983076872851099646E-001;
xnu[8][79] =  7.6272691366822134369754E-001;
xnu[8][80] =  7.6565987182218781198605E-001;
xnu[8][81] =  7.6857855975789755799089E-001;
xnu[8][82] =  7.7148283324915574524615E-001;
xnu[8][83] =  7.7437254933126472430380E-001;
xnu[8][84] =  7.7724756631596627443319E-001;
xnu[8][85] =  7.8010774380636422090881E-001;
xnu[8][86] =  7.8295294271182721131149E-001;
xnu[8][87] =  7.8578302526287141699609E-001;
xnu[8][88] =  7.8859785502602290742185E-001;
xnu[8][89] =  7.9139729691865942541974E-001;
xnu[8][90] =  7.9418121722383127071718E-001;
xnu[8][91] =  7.9694948360506097719637E-001;
xnu[8][92] =  7.9970196512112144648713E-001;
xnu[8][93] =  8.0243853224079217665963E-001;
xnu[8][94] =  8.0515905685759320007779E-001;
xnu[8][95] =  8.0786341230449631900687E-001;
xnu[8][96] =  8.1055147336861320147034E-001;
xnu[8][97] =  8.1322311630585987327081E-001;
xnu[8][98] =  8.1587821885559711520679E-001;
xnu[8][99] =  8.1851666025524624753565E-001;
xnu[8][100] =  8.2113832125487975688706E-001;
xnu[8][101] =  8.2374308413178619439088E-001;
xnu[8][102] =  8.2633083270500874805039E-001;
xnu[8][103] =  8.2890145234985686771097E-001;
xnu[8][104] =  8.3145483001239029773051E-001;
xnu[8][105] =  8.3399085422387485108267E-001;
xnu[8][106] =  8.3650941511520923959944E-001;
xnu[8][107] =  8.3901040443132225891910E-001;
xnu[8][108] =  8.4149371554553961404354E-001;
xnu[8][109] =  8.4395924347391966287784E-001;
xnu[8][110] =  8.4640688488955735144733E-001;
xnu[8][111] =  8.4883653813685561645313E-001;
xnu[8][112] =  8.5124810324576353930490E-001;
xnu[8][113] =  8.5364148194598055170579E-001;
xnu[8][114] =  8.5601657768112601729334E-001;
xnu[8][115] =  8.5837329562287354788348E-001;
xnu[8][116] =  8.6071154268504945774249E-001;
xnu[8][117] =  8.6303122753769481634259E-001;
xnu[8][118] =  8.6533226062109063066465E-001;
xnu[8][119] =  8.6761455415974577383172E-001;
xnu[8][120] =  8.6987802217634737933861E-001;
xnu[8][121] =  8.7212258050567354115472E-001;
xnu[8][122] =  8.7434814680846830141141E-001;
xnu[8][123] =  8.7655464058527907126126E-001;
xnu[8][124] =  8.7874198319025681896313E-001;
xnu[8][125] =  8.8091009784491957458672E-001;
xnu[8][126] =  8.8305890965188004535834E-001;
xnu[8][127] =  8.8518834560853841213875E-001;
xnu[8][128] =  8.8729833462074168851793E-001;
xnu[8][129] =  8.8938880751641137235105E-001;
xnu[8][130] =  8.9145969705914150819259E-001;
xnu[8][131] =  8.9351093796176971108496E-001;
xnu[8][132] =  8.9554246689992418071732E-001;
xnu[8][133] =  8.9755422252555026338988E-001;
xnu[8][134] =  8.9954614548042070089990E-001;
xnu[8][135] =  9.0151817840963434389085E-001;
xnu[8][136] =  9.0347026597510880592815E-001;
xnu[8][137] =  9.0540235486907329718058E-001;
xnu[8][138] =  9.0731439382756870671791E-001;
xnu[8][139] =  9.0920633364396290369770E-001;
xnu[8][140] =  9.1107812718249020368626E-001;
xnu[8][141] =  9.1292972939182500054383E-001;
xnu[8][142] =  9.1476109731870070008905E-001;
xnu[8][143] =  9.1657219012158631236397E-001;
xnu[8][144] =  9.1836296908443436775138E-001;
xnu[8][145] =  9.2013339763051522117512E-001;
xnu[8][146] =  9.2188344133635430051916E-001;
xnu[8][147] =  9.2361306794579044219027E-001;
xnu[8][148] =  9.2532224738417513987891E-001;
xnu[8][149] =  9.2701095177273431290670E-001;
xnu[8][150] =  9.2867915544311607826256E-001;
xnu[8][151] =  9.3032683495214998490117E-001;
xnu[8][152] =  9.3195396909684523857321E-001;
xnu[8][153] =  9.3356053892965760780721E-001;
xnu[8][154] =  9.3514652777405695292558E-001;
xnu[8][155] =  9.3671192124042965509622E-001;
xnu[8][156] =  9.3825670724235263487081E-001;
xnu[8][157] =  9.3978087601327813128378E-001;
xnu[8][158] =  9.4128442012367095342085E-001;
xnu[8][159] =  9.4276733449864250446303E-001;
xnu[8][160] =  9.4422961643612849944521E-001;
xnu[8][161] =  9.4567126562565993583304E-001;
xnu[8][162] =  9.4709228416777951142968E-001;
xnu[8][163] =  9.4849267659415829518778E-001;
xnu[8][164] =  9.4987244988847001831932E-001;
xnu[8][165] =  9.5123161350808283752414E-001;
xnu[8][166] =  9.5257017940663079759465E-001;
xnu[8][167] =  9.5388816205752945181220E-001;
xnu[8][168] =  9.5518557847850214624890E-001;
xnu[8][169] =  9.5646244825718529503981E-001;
xnu[8][170] =  9.5771879357788252032198E-001;
xnu[8][171] =  9.5895463924953875081824E-001;
xnu[8][172] =  9.6017001273500621036491E-001;
xnu[8][173] =  9.6136494418167462076137E-001;
xnu[8][174] =  9.6253946645353782618207E-001;
xnu[8][175] =  9.6369361516476834842161E-001;
xnu[8][176] =  9.6482742871487002833506E-001;
xnu[8][177] =  9.6594094832547681967268E-001;
xnu[8][178] =  9.6703421807886289399974E-001;
xnu[8][179] =  9.6810728495822540331247E-001;
xnu[8][180] =  9.6916019888979644182741E-001;
xnu[8][181] =  9.7019301278683486068516E-001;
xnu[8][182] =  9.7120578259554152990628E-001;
xnu[8][183] =  9.7219856734293332429533E-001;
xnu[8][184] =  9.7317142918670145257425E-001;
xnu[8][185] =  9.7412443346706867853133E-001;
xnu[8][186] =  9.7505764876064743827892E-001;
xnu[8][187] =  9.7597114693628679474913E-001;
xnu[8][188] =  9.7686500321288056820737E-001;
xnu[8][189] =  9.7773929621909184878677E-001;
xnu[8][190] =  9.7859410805493048136810E-001;
xnu[8][191] =  9.7942952435510011067792E-001;
xnu[8][192] =  9.8024563435401014171175E-001;
xnu[8][193] =  9.8104253095232573787034E-001;
xnu[8][194] =  9.8182031078490606626049E-001;
xnu[8][195] =  9.8257907428995783298937E-001;
xnu[8][196] =  9.8331892577920828354614E-001;
xnu[8][197] =  9.8403997350887997398176E-001;
xnu[8][198] =  9.8474232975122961588545E-001;
xnu[8][199] =  9.8542611086639622162798E-001;
xnu[8][200] =  9.8609143737429089828903E-001;
xnu[8][201] =  9.8673843402625346338665E-001;
xnu[8][202] =  9.8736722987620133388036E-001;
xnu[8][203] =  9.8797795835100587656440E-001;
xnu[8][204] =  9.8857075731985285707820E-001;
xnu[8][205] =  9.8914576916237926976304E-001;
xnu[8][206] =  9.8970314083543134190307E-001;
xnu[8][207] =  9.9024302393836066970799E-001;
xnu[8][208] =  9.9076557477687005343368E-001;
xnu[8][209] =  9.9127095442554030212529E-001;
xnu[8][210] =  9.9175932878931636438083E-001;
xnu[8][211] =  9.9223086866440726729820E-001;
xnu[8][212] =  9.9268574979926018555688E-001;
xnu[8][213] =  9.9312415295650377634075E-001;
xnu[8][214] =  9.9354626397701703359495E-001;
xnu[8][215] =  9.9395227384756214023332E-001;
xnu[8][216] =  9.9434237877371473996926E-001;
xnu[8][217] =  9.9471678026012041935822E-001;
xnu[8][218] =  9.9507568520038507959027E-001;
xnu[8][219] =  9.9541930597914712183853E-001;
xnu[8][220] =  9.9574786058905306619925E-001;
xnu[8][221] =  9.9606157276543155884129E-001;
xnu[8][222] =  9.9636067214139430766410E-001;
xnu[8][223] =  9.9664539442584248310532E-001;
xnu[8][224] =  9.9691598160637751110426E-001;
xnu[8][225] =  9.9717268217836170296553E-001;
xnu[8][226] =  9.9741575140031050025957E-001;
xnu[8][227] =  9.9764545157440515113072E-001;
xnu[8][228] =  9.9786205234920359425472E-001;
xnu[8][229] =  9.9806583103965751889305E-001;
xnu[8][230] =  9.9825707295744513692434E-001;
xnu[8][231] =  9.9843607174263008064974E-001;
xnu[8][232] =  9.9860312968611097953823E-001;
xnu[8][233] =  9.9875855803173619998262E-001;
xnu[8][234] =  9.9890267724797863728092E-001;
xnu[8][235] =  9.9903581726246516165093E-001;
xnu[8][236] =  9.9915831765920369626532E-001;
xnu[8][237] =  9.9927052784858395301327E-001;
xnu[8][238] =  9.9937280723404755735176E-001;
xnu[8][239] =  9.9946552541540528111790E-001;
xnu[8][240] =  9.9954906248383379883111E-001;
xnu[8][241] =  9.9962380947167123679948E-001;
xnu[8][242] =  9.9969016901251179096404E-001;
xnu[8][243] =  9.9974855623359359526763E-001;
xnu[8][244] =  9.9979939983595534162598E-001;
xnu[8][245] =  9.9984314322415886588808E-001;
xnu[8][246] =  9.9988024546221602366522E-001;
xnu[8][247] =  9.9991118183989386959794E-001;
xnu[8][248] =  9.9993644406017880596898E-001;
xnu[8][249] =  9.9995654057233914140003E-001;
xnu[8][250] =  9.9997199810352718788193E-001;
xnu[8][251] =  9.9998336504924313844142E-001;
xnu[8][252] =  9.9999121517744579929001E-001;
xnu[8][253] =  9.9999614906812879401388E-001;
xnu[8][254] =  9.9999879818987423231012E-001;
xnu[8][255] =  9.9999983647836719219063E-001;
dnu[8][0] = -3.5236017725240448367289E-003;
dnu[8][1] =  3.5235041442227400686498E-003;
dnu[8][2] = -3.5232112672901020887398E-003;
dnu[8][3] =  3.5227231656397573838983E-003;
dnu[8][4] = -3.5220398791270752663317E-003;
dnu[8][5] =  3.5211614635481560479832E-003;
dnu[8][6] = -3.5200879906384153312115E-003;
dnu[8][7] =  3.5188195480707652615937E-003;
dnu[8][8] = -3.5173562394533938295372E-003;
dnu[8][9] =  3.5156981843271435475412E-003;
dnu[8][10] = -3.5138455181624910692920E-003;
dnu[8][11] =  3.5117983923561295551537E-003;
dnu[8][12] = -3.5095569742271558258560E-003;
dnu[8][13] =  3.5071214470128645821259E-003;
dnu[8][14] = -3.5044920098641522024681E-003;
dnu[8][15] =  3.5016688778405328640984E-003;
dnu[8][16] = -3.4986522819047699629721E-003;
dnu[8][17] =  3.4954424689171260377234E-003;
dnu[8][18] = -3.4920397016292346289319E-003;
dnu[8][19] =  3.4884442586775977292236E-003;
dnu[8][20] = -3.4846564345767127010655E-003;
dnu[8][21] =  3.4806765397118327574657E-003;
dnu[8][22] = -3.4765049003313653158828E-003;
dnu[8][23] =  3.4721418585389127471901E-003;
dnu[8][24] = -3.4675877722849602492399E-003;
dnu[8][25] =  3.4628430153582157781065E-003;
dnu[8][26] = -3.4579079773766071691240E-003;
dnu[8][27] =  3.4527830637779417740149E-003;
dnu[8][28] = -3.4474686958102341293586E-003;
dnu[8][29] =  3.4419653105217073549737E-003;
dnu[8][30] = -3.4362733607504741580630E-003;
dnu[8][31] =  3.4303933151139034897570E-003;
dnu[8][32] = -3.4243256579976790645136E-003;
dnu[8][33] =  3.4180708895445561092032E-003;
dnu[8][34] = -3.4116295256428228571000E-003;
dnu[8][35] =  3.4050020979144734418687E-003;
dnu[8][36] = -3.3981891537030989774011E-003;
dnu[8][37] =  3.3911912560615037304123E-003;
dnu[8][38] = -3.3840089837390534034163E-003;
dnu[8][39] =  3.3766429311687626453919E-003;
dnu[8][40] = -3.3690937084541289954298E-003;
dnu[8][41] =  3.3613619413557205401809E-003;
dnu[8][42] = -3.3534482712775246282416E-003;
dnu[8][43] =  3.3453533552530650329179E-003;
dnu[8][44] = -3.3370778659312949882693E-003;
dnu[8][45] =  3.3286224915622735410861E-003;
dnu[8][46] = -3.3199879359826326625944E-003;
dnu[8][47] =  3.3111749186008425472876E-003;
dnu[8][48] = -3.3021841743822824913798E-003;
dnu[8][49] =  3.2930164538341246889724E-003;
dnu[8][50] = -3.2836725229900382090953E-003;
dnu[8][51] =  3.2741531633947203202702E-003;
dnu[8][52] = -3.2644591720882622100624E-003;
dnu[8][53] =  3.2545913615903560041347E-003;
dnu[8][54] = -3.2445505598843498214605E-003;
dnu[8][55] =  3.2343376104011574084413E-003;
dnu[8][56] = -3.2239533720030286735506E-003;
dnu[8][57] =  3.2133987189671871946092E-003;
dnu[8][58] = -3.2026745409693404917104E-003;
dnu[8][59] =  3.1917817430670685489766E-003;
dnu[8][60] = -3.1807212456830957265718E-003;
dnu[8][61] =  3.1694939845884508295582E-003;
dnu[8][62] = -3.1581009108855196911351E-003;
dnu[8][63] =  3.1465429909909941834386E-003;
dnu[8][64] = -3.1348212066187210883550E-003;
dnu[8][65] =  3.1229365547624537427064E-003;
dnu[8][66] = -3.1108900476785088157874E-003;
dnu[8][67] =  3.0986827128683299817099E-003;
dnu[8][68] = -3.0863155930609596136326E-003;
dnu[8][69] =  3.0737897461954189510710E-003;
dnu[8][70] = -3.0611062454029964746573E-003;
dnu[8][71] =  3.0482661789894434646161E-003;
dnu[8][72] = -3.0352706504170749197467E-003;
dnu[8][73] =  3.0221207782867731729442E-003;
dnu[8][74] = -3.0088176963198906576125E-003;
dnu[8][75] =  2.9953625533400473573579E-003;
dnu[8][76] = -2.9817565132548175100558E-003;
dnu[8][77] =  2.9680007550372991380706E-003;
dnu[8][78] = -2.9540964727075589408062E-003;
dnu[8][79] =  2.9400448753139440160228E-003;
dnu[8][80] = -2.9258471869142507751655E-003;
dnu[8][81] =  2.9115046465567402885106E-003;
dnu[8][82] = -2.8970185082609881421060E-003;
dnu[8][83] =  2.8823900409985557147716E-003;
dnu[8][84] = -2.8676205286734685951001E-003;
dnu[8][85] =  2.8527112701024866615598E-003;
dnu[8][86] = -2.8376635789951491504336E-003;
dnu[8][87] =  2.8224787839335768444255E-003;
dnu[8][88] = -2.8071582283520123383909E-003;
dnu[8][89] =  2.7917032705160781880498E-003;
dnu[8][90] = -2.7761152835017316342499E-003;
dnu[8][91] =  2.7603956551738935322869E-003;
dnu[8][92] = -2.7445457881647281174076E-003;
dnu[8][93] =  2.7285670998515493199771E-003;
dnu[8][94] = -2.7124610223343285247561E-003;
dnu[8][95] =  2.6962290024127779680319E-003;
dnu[8][96] = -2.6798725015629834058070E-003;
dnu[8][97] =  2.6633929959135592898706E-003;
dnu[8][98] = -2.6467919762212994827357E-003;
dnu[8][99] =  2.6300709478462965560248E-003;
dnu[8][100] = -2.6132314307265029815277E-003;
dnu[8][101] =  2.5962749593517080743133E-003;
dnu[8][102] = -2.5792030827369054204802E-003;
dnu[8][103] =  2.5620173643950267591546E-003;
dnu[8][104] = -2.5447193823090199333684E-003;
dnu[8][105] =  2.5273107289032506252914E-003;
dnu[8][106] = -2.5097930110142101995453E-003;
dnu[8][107] =  2.4921678498605151495699E-003;
dnu[8][108] = -2.4744368810121874360035E-003;
dnu[8][109] =  2.4566017543592094868339E-003;
dnu[8][110] = -2.4386641340793528652707E-003;
dnu[8][111] =  2.4206256986052856760690E-003;
dnu[8][112] = -2.4024881405909707524150E-003;
dnu[8][113] =  2.3842531668773746263160E-003;
dnu[8][114] = -2.3659224984575163235681E-003;
dnu[8][115] =  2.3474978704408952326600E-003;
dnu[8][116] = -2.3289810320173487732893E-003;
dnu[8][117] =  2.3103737464204034374082E-003;
dnu[8][118] = -2.2916777908901971016763E-003;
dnu[8][119] =  2.2728949566360664274378E-003;
dnu[8][120] = -2.2540270487989107900066E-003;
dnu[8][121] =  2.2350758864134636345022E-003;
dnu[8][122] = -2.2160433023706235660286E-003;
dnu[8][123] =  2.1969311433800209763024E-003;
dnu[8][124] = -2.1777412699330217183940E-003;
dnu[8][125] =  2.1584755562663973996390E-003;
dnu[8][126] = -2.1391358903269224047932E-003;
dnu[8][127] =  2.1197241737371909221716E-003;
dnu[8][128] = -2.1002423217629831588587E-003;
dnu[8][129] =  2.0806922632825487288194E-003;
dnu[8][130] = -2.0610759407582170076376E-003;
dnu[8][131] =  2.0413953102107891917508E-003;
dnu[8][132] = -2.0216523411972149927435E-003;
dnu[8][133] =  2.0018490167921084428078E-003;
dnu[8][134] = -1.9819873335737122775631E-003;
dnu[8][135] =  1.9620693016149788733009E-003;
dnu[8][136] = -1.9420969444804978049911E-003;
dnu[8][137] =  1.9220722992300657945837E-003;
dnu[8][138] = -1.9019974164297641458043E-003;
dnu[8][139] =  1.8818743601714816912025E-003;
dnu[8][140] = -1.8617052081018977543513E-003;
dnu[8][141] =  1.8414920514620195598335E-003;
dnu[8][142] = -1.8212369951384517659700E-003;
dnu[8][143] =  1.8009421577276621593433E-003;
dnu[8][144] = -1.7806096716145967882927E-003;
dnu[8][145] =  1.7602416830670896134102E-003;
dnu[8][146] = -1.7398403523476057348613E-003;
dnu[8][147] =  1.7194078538439529593811E-003;
dnu[8][148] = -1.6989463762206933486966E-003;
dnu[8][149] =  1.6784581225930838067080E-003;
dnu[8][150] = -1.6579453107254719735305E-003;
dnu[8][151] =  1.6374101732561698478224E-003;
dnu[8][152] = -1.6168549579509216818417E-003;
dnu[8][153] =  1.5962819279871736839512E-003;
dnu[8][154] = -1.5756933622714396792910E-003;
dnu[8][155] =  1.5550915557921377307891E-003;
dnu[8][156] = -1.5344788200103462608708E-003;
dnu[8][157] =  1.5138574832909927223987E-003;
dnu[8][158] = -1.4932298913770414512368E-003;
dnu[8][159] =  1.4725984079092879114196E-003;
dnu[8][160] = -1.4519654149943918408731E-003;
dnu[8][161] =  1.4313333138237893412643E-003;
dnu[8][162] = -1.4107045253461110396137E-003;
dnu[8][163] =  1.3900814909956971752233E-003;
dnu[8][164] = -1.3694666734797377060041E-003;
dnu[8][165] =  1.3488625576264729333326E-003;
dnu[8][166] = -1.3282716512967641415720E-003;
dnu[8][167] =  1.3076964863611805461264E-003;
dnu[8][168] = -1.2871396197445444404608E-003;
dnu[8][169] =  1.2666036345396266287484E-003;
dnu[8][170] = -1.2460911411913846503000E-003;
dnu[8][171] =  1.2256047787527824196154E-003;
dnu[8][172] = -1.2051472162128170869123E-003;
dnu[8][173] =  1.1847211538969024757289E-003;
dnu[8][174] = -1.1643293249392136943195E-003;
dnu[8][175] =  1.1439744968259798618913E-003;
dnu[8][176] = -1.1236594730080169654101E-003;
dnu[8][177] =  1.1033870945800166459678E-003;
dnu[8][178] = -1.0831602420232457136344E-003;
dnu[8][179] =  1.0629818370073626652228E-003;
dnu[8][180] = -1.0428548442460197131980E-003;
dnu[8][181] =  1.0227822733997914672317E-003;
dnu[8][182] = -1.0027671810187558497225E-003;
dnu[8][183] =  9.8281267251575273865993E-004;
dnu[8][184] = -9.6292190415996773102075E-004;
dnu[8][185] =  9.4309808507904237696790E-004;
dnu[8][186] = -9.2334447925641270456432E-004;
dnu[8][187] =  9.0366440750904465039505E-004;
dnu[8][188] = -8.8406124942919443350579E-004;
dnu[8][189] =  8.6453844527230803583806E-004;
dnu[8][190] = -8.4509949777173009558748E-004;
dnu[8][191] =  8.2574797385957285327574E-004;
dnu[8][192] = -8.0648750627196711535064E-004;
dnu[8][193] =  7.8732179501606083094277E-004;
dnu[8][194] = -7.6825460867564458085196E-004;
dnu[8][195] =  7.4928978553228318107157E-004;
dnu[8][196] = -7.3043123447945493844494E-004;
dnu[8][197] =  7.1168293570860259950151E-004;
dnu[8][198] = -6.9304894114836274849880E-004;
dnu[8][199] =  6.7453337464176556563600E-004;
dnu[8][200] = -6.5614043185110739064173E-004;
dnu[8][201] =  6.3787437988673473672259E-004;
dnu[8][202] = -6.1973955666439198266955E-004;
dnu[8][203] =  6.0174037000632982440356E-004;
dnu[8][204] = -5.8388129651429021842567E-004;
dnu[8][205] =  5.6616688025798832458331E-004;
dnu[8][206] = -5.4860173134095970970073E-004;
dnu[8][207] =  5.3119052442670035687534E-004;
dnu[8][208] = -5.1393799733183663089639E-004;
dnu[8][209] =  4.9684894981938042897235E-004;
dnu[8][210] = -4.7992824275346810313068E-004;
dnu[8][211] =  4.6318079780655564168411E-004;
dnu[8][212] = -4.4661159793966245617026E-004;
dnu[8][213] =  4.3022568890426392406400E-004;
dnu[8][214] = -4.1402818203861315130421E-004;
dnu[8][215] =  3.9802425864877543575304E-004;
dnu[8][216] = -3.8221917627194139209526E-004;
dnu[8][217] =  3.6661827711238395602767E-004;
dnu[8][218] = -3.5122699891378616067880E-004;
dnu[8][219] =  3.3605088848005409732297E-004;
dnu[8][220] = -3.2109561797425254420128E-004;
dnu[8][221] =  3.0636700400611260464706E-004;
dnu[8][222] = -2.9187102935748985192333E-004;
dnu[8][223] =  2.7761386698865378985736E-004;
dnu[8][224] = -2.6360190571582919306239E-004;
dnu[8][225] =  2.4984177665640024225928E-004;
dnu[8][226] = -2.3634037921463134561575E-004;
dnu[8][227] =  2.2310490505070162374404E-004;
dnu[8][228] = -2.1014285817768061591171E-004;
dnu[8][229] =  1.9746206912343685221695E-004;
dnu[8][230] = -1.8507070106112583261579E-004;
dnu[8][231] =  1.7297724606495193567507E-004;
dnu[8][232] = -1.6119051032643119483180E-004;
dnu[8][233] =  1.4971958842545586543710E-004;
dnu[8][234] = -1.3857382873259367872945E-004;
dnu[8][235] =  1.2776279479761843100676E-004;
dnu[8][236] = -1.1729623106196260243797E-004;
dnu[8][237] =  1.0718404501710846857448E-004;
dnu[8][238] = -9.7436321118320573341744E-005;
dnu[8][239] =  8.8063382772541597737195E-005;
dnu[8][240] = -7.9075915205566116981157E-005;
dnu[8][241] =  7.0485151102052395706581E-005;
dnu[8][242] = -6.2303100120749462771247E-005;
dnu[8][243] =  5.4542772822870761025480E-005;
dnu[8][244] = -4.7218316126617180477170E-005;
dnu[8][245] =  4.0344961400701764692553E-005;
dnu[8][246] = -3.3938727737915739053586E-005;
dnu[8][247] =  2.8015975392808212607024E-005;
dnu[8][248] = -2.2593183623060767475330E-005;
dnu[8][249] =  1.7687568602759479431384E-005;
dnu[8][250] = -1.3318826217940261494781E-005;
dnu[8][251] =  9.5106840952937908339661E-006;
dnu[8][252] = -6.2892960976606935680311E-006;
dnu[8][253] =  3.6831203455116083442839E-006;
dnu[8][254] = -1.7416856803596676839876E-006;
dnu[8][255] =  4.7285796697500352441360E-007;
}
