% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gower.R
\name{gower_topn}
\alias{gower_topn}
\title{Find the top-n matches}
\usage{
gower_topn(x, y, pair_x = NULL, pair_y = NULL, n = 5, eps = 1e-08,
  weights = NULL, ignore_case = FALSE,
  nthread = getOption("gd_num_thread"))
}
\arguments{
\item{x}{\code{[data.frame]}}

\item{y}{\code{[data.frame]}}

\item{pair_x}{\code{[numeric|character] (optional)} Columns in \code{x} used for comparison. 
See Details below.}

\item{pair_y}{\code{[numeric|character] (optional)} Columns in \code{y} used for comparison. 
See Details below.}

\item{n}{The top-n indices and distances to return.}

\item{eps}{\code{[numeric] (optional)} Computed numbers (variable ranges) 
smaller than \code{eps} are treated as zero.}

\item{weights}{\code{[numeric] (optional)} A vector of weights of length \code{ncol(x)}
that defines the weight applied to each component of the gower distance.}

\item{ignore_case}{\code{[logical]} Toggle ignore case when neither \code{pair_x}
nor \code{pair_y} are user-defined.}

\item{nthread}{Number of threads to use for parallelization. By default,
for a dual-core machine, 2 threads are used. For any other machine 
n-1 cores are used so your machine doesn't freeze during a big computation. 
The maximum nr of threads are determined using \code{omp_get_max_threads} at C level.}
}
\value{
A \code{list} with two array elements: \code{index}
 and \code{distance}. Both have size \code{n X nrow(x)}. Each ith column 
 corresponds to the top-n best matches of \code{x} with rows in \code{y}.
 When there are no columns to compare, a message is printed and both
 \code{distance} and \code{index} will be empty matrices; the list is
 then returned invisibly.
}
\description{
Find the top-n matches in \code{y} for each record in \code{x}.
}
\examples{
# find the top 4 best matches in the iris data set with itself.
x <- iris[1:3,]
lookup <- iris[1:10,]
gower_topn(x=x,y=lookup,n=4)


}
\seealso{
\code{\link{gower_dist}}
}
