% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branch.r
\docType{methods}
\name{is_local}
\alias{is_local}
\alias{is_local,git_branch-method}
\title{Check if branch is local}
\usage{
is_local(branch)

\S4method{is_local}{git_branch}(branch)
}
\arguments{
\item{branch}{The branch \code{object} to check if it's local}
}
\value{
TRUE if branch is local, else FALSE
}
\description{
Check if branch is local
}
\examples{
\dontrun{
## Initialize repositories
path_bare <- tempfile(pattern="git2r-")
path_repo <- tempfile(pattern="git2r-")
dir.create(path_bare)
dir.create(path_repo)
repo_bare <- init(path_bare, bare = TRUE)
repo <- clone(path_bare, path_repo)

## Config first user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")

## Write to a file and commit
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           file.path(path_repo, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Push commits from repository to bare repository
## Adds an upstream tracking branch to branch 'master'
push(repo, "origin", "refs/heads/master")

## List branches
branches(repo)

## Check if first branch is_local
is_local(branches(repo)[[1]])

## Check if second branch is_local
is_local(branches(repo)[[2]])
}
}
\keyword{methods}
