% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branch.r
\docType{methods}
\name{branch_create}
\alias{branch_create}
\alias{branch_create,git_commit-method}
\title{Create a branch}
\usage{
branch_create(commit, name, force = FALSE)

\S4method{branch_create}{git_commit}(commit, name, force = FALSE)
}
\arguments{
\item{commit}{Commit to which branch should point.}

\item{name}{Name for the branch}

\item{force}{Overwrite existing branch. Default = FALSE}
}
\value{
invisible S4 class git_branch object
}
\description{
Create a branch
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit_1 <- commit(repo, "First commit message")

## Create a branch
branch_1 <- branch_create(commit_1, name = "test-branch")

## Add one more commit
writeLines(c("Hello world!", "HELLO WORLD!"), file.path(path, "example.txt"))
add(repo, "example.txt")
commit_2 <- commit(repo, "Another commit message")

## Create a branch with the same name should fail
try(branch_create(commit_2, name = "test-branch"), TRUE)

## Force it
branch_2 <- branch_create(commit_2, name = "test-branch", force = TRUE)
}
}
\keyword{methods}
