% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_node_attr_w_fcn.R
\name{set_node_attr_w_fcn}
\alias{set_node_attr_w_fcn}
\title{Set node attribute values with a graph function}
\usage{
set_node_attr_w_fcn(graph, node_attr_fcn, ..., column_name = NULL)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{node_attr_fcn}{The name of the function to use for creating a column of
node attribute values. Valid functions are: \code{\link[=get_alpha_centrality]{get_alpha_centrality()}},
\code{\link[=get_authority_centrality]{get_authority_centrality()}}, \code{\link[=get_betweenness]{get_betweenness()}}, \code{\link[=get_closeness]{get_closeness()}},
\code{\link[=get_cmty_edge_btwns]{get_cmty_edge_btwns()}}, \code{\link[=get_cmty_fast_greedy]{get_cmty_fast_greedy()}}, \code{\link[=get_cmty_l_eigenvec]{get_cmty_l_eigenvec()}},
\code{\link[=get_cmty_louvain]{get_cmty_louvain()}}, \code{\link[=get_cmty_walktrap]{get_cmty_walktrap()}}, \code{\link[=get_degree_distribution]{get_degree_distribution()}},
\code{\link[=get_degree_histogram]{get_degree_histogram()}}, \code{\link[=get_degree_in]{get_degree_in()}}, \code{\link[=get_degree_out]{get_degree_out()}},
\code{\link[=get_degree_total]{get_degree_total()}}, \code{\link[=get_eccentricity]{get_eccentricity()}}, \code{\link[=get_eigen_centrality]{get_eigen_centrality()}},
\code{\link[=get_pagerank]{get_pagerank()}}, \code{\link[=get_s_connected_cmpts]{get_s_connected_cmpts()}}, and \code{\link[=get_w_connected_cmpts]{get_w_connected_cmpts()}}.}

\item{...}{Arguments and values to pass to the named function in
\code{node_attr_fcn}, if necessary.}

\item{column_name}{An option to supply a column name for the new node
attribute column. If \code{NULL} then the column name supplied by the function
will used along with a \verb{__A} suffix.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
From a graph object of class \code{dgr_graph} or a node data frame, set node
attribute properties for all nodes in the graph using one of several
whole-graph functions.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 10,
    m = 22,
    set_seed = 23) \%>\%
  set_node_attrs(
    node_attr = value,
    values = rnorm(
      n = count_nodes(.),
      mean = 5,
      sd = 1) \%>\% round(1))

# Get the betweenness values for
# each of the graph's nodes as a
# node attribute
graph_1 <-
  graph \%>\%
  set_node_attr_w_fcn(
    node_attr_fcn = "get_betweenness")

# Inspect the graph's internal
# node data frame
graph_1 \%>\% get_node_df()

# If a specified function takes argument
# values, these can be supplied as well
graph_2 <-
  graph \%>\%
  set_node_attr_w_fcn(
    node_attr_fcn = "get_alpha_centrality",
    alpha = 2,
    exo = 2)

# Inspect the graph's internal
# node data frame
graph_2 \%>\% get_node_df()

# The new column name can be provided
graph_3 <-
  graph \%>\%
  set_node_attr_w_fcn(
    node_attr_fcn = "get_pagerank",
    column_name = "pagerank")

# Inspect the graph's internal
# node data frame
graph_3 \%>\% get_node_df()

# If `graph_3` is modified by
# adding a new node then the column
# `pagerank` will have stale data; we
# can run the function again and re-use
# the existing column name to provide
# updated values
graph_3 <-
  graph_3 \%>\%
  add_node(
    from = 1,
    to = 3) \%>\%
  set_node_attr_w_fcn(
    node_attr_fcn = "get_pagerank",
    column_name = "pagerank")

# Inspect the graph's internal
# node data frame
graph_3 \%>\% get_node_df()

}
\seealso{
Other node creation and removal: 
\code{\link{add_n_node_clones}()},
\code{\link{add_n_nodes}()},
\code{\link{add_n_nodes_ws}()},
\code{\link{add_node}()},
\code{\link{add_node_clones_ws}()},
\code{\link{add_node_df}()},
\code{\link{add_nodes_from_df_cols}()},
\code{\link{add_nodes_from_table}()},
\code{\link{colorize_node_attrs}()},
\code{\link{copy_node_attrs}()},
\code{\link{create_node_df}()},
\code{\link{delete_node}()},
\code{\link{delete_nodes_ws}()},
\code{\link{drop_node_attrs}()},
\code{\link{join_node_attrs}()},
\code{\link{layout_nodes_w_string}()},
\code{\link{mutate_node_attrs}()},
\code{\link{mutate_node_attrs_ws}()},
\code{\link{node_data}()},
\code{\link{recode_node_attrs}()},
\code{\link{rename_node_attrs}()},
\code{\link{rescale_node_attrs}()},
\code{\link{set_node_attr_to_display}()},
\code{\link{set_node_attrs}()},
\code{\link{set_node_attrs_ws}()},
\code{\link{set_node_position}()}
}
\concept{node creation and removal}
