% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{as_date}
\alias{as_date}
\alias{as_date.Date}
\alias{as_date.POSIXt}
\alias{as_date.clock_calendar}
\alias{as_date.clock_time_point}
\alias{as_date.clock_zoned_time}
\title{Convert to a date}
\usage{
as_date(x, ...)

\method{as_date}{Date}(x, ...)

\method{as_date}{POSIXt}(x, ...)

\method{as_date}{clock_calendar}(x, ...)

\method{as_date}{clock_time_point}(x, ...)

\method{as_date}{clock_zoned_time}(x, ...)
}
\arguments{
\item{x}{\verb{[vector]}

A vector.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A date with the same length as \code{x}.
}
\description{
\code{as_date()} is a generic function that converts its input to a date (Date).

There are methods for converting date-times (POSIXct), calendars,
time points, and zoned-times to dates.

For converting to a date-time, see \code{\link[=as_date_time]{as_date_time()}}.
}
\details{
Note that clock always assumes that R's Date class is naive, so converting
a POSIXct to a Date will always retain the printed year, month, and day
value.

This is not a drop-in replacement for \code{as.Date()}, as it only converts a
limited set of types to Date. For parsing characters as dates, see
\code{\link[=date_parse]{date_parse()}}. For converting numerics to dates, see \code{\link[vctrs:new_date]{vctrs::new_date()}} or
continue to use \code{as.Date()}.
}
\examples{
x <- date_time_parse("2019-01-01 23:02:03", "America/New_York")

# R's `as.Date.POSIXct()` method defaults to changing the printed time
# to UTC before converting, which can result in odd conversions like this:
as.Date(x)

# `as_date()` will never change the printed time before converting
as_date(x)

# Can also convert from other clock types
as_date(year_month_day(2019, 2, 5))
}
