% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress-bar.R
\name{cli_progress_styles}
\alias{cli_progress_styles}
\title{List of built-in cli progress styles}
\usage{
cli_progress_styles()
}
\value{
A named list with sublists containing elements
\code{complete}, \code{incomplete} and potentially \code{current}.
}
\description{
The following options are used to select a style:
\itemize{
\item \code{cli_progress_bar_style}
\item \code{cli_progress_bar_style_ascii}
\item \code{cli_progress_bar_style_unicode}
}
}
\details{
On Unicode terminals (if \code{\link[=is_utf8_output]{is_utf8_output()}} is \code{TRUE}), the
\code{cli_progress_bar_style_unicode} and \code{cli_progress_bar_style}
options are used.

On ASCII terminals (if \code{\link[=is_utf8_output]{is_utf8_output()}} is \code{FALSE}), the
\code{cli_pgoress_bar_style_ascii} and \code{cli_progress_bar_style} options
are are used.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{for (style in names(cli_progress_styles())) \{
  options(cli.progress_bar_style = style)
  label <- ansi_align(paste0("Style '", style, "'"), 20)
  print(cli_progress_demo(label, live = FALSE, at = 66, total = 100))
\}
options(cli.progress_var_style = NULL)
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> Style 'classic'      <span style="color: #859900;">#####################           </span>  66&#37; | ETA:  3s           
#> Style 'squares'      <span style="color: #859900;">■■■■■■■■■■■■■■■■■■■■■           </span>  66&#37; | ETA:  3s           
#> Style 'dot'          <span style="color: #002B36;">────────────────────</span><span style="color: #DC322F;">●</span><span style="color: #002B36;">──────────</span><span style="color: #859900;"> </span>  66&#37; | ETA:  3s           
#> Style 'fillsquares'  <span style="color: #859900;">■■■■■■■■■■■■■■■■■■■■■</span><span style="color: #002B36;">□□□□□□□□□□</span><span style="color: #859900;"> </span>  66&#37; | ETA:  3s           
#> Style 'bar'          <span style="color: #859900;">█████████████████████</span><span style="color: #002B36;">██████████</span><span style="color: #859900;"> </span>  66&#37; | ETA:  3s           
</pre></div>
}}
}
\seealso{
Other progress bar functions: 
\code{\link{cli_progress_along}()},
\code{\link{cli_progress_bar}()},
\code{\link{cli_progress_builtin_handlers}()},
\code{\link{cli_progress_message}()},
\code{\link{cli_progress_num}()},
\code{\link{cli_progress_output}()},
\code{\link{cli_progress_step}()},
\code{\link{progress-variables}}
}
\concept{progress bar functions}
