% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkNumber.R
\name{checkNumber}
\alias{checkNumber}
\alias{check_number}
\alias{assertNumber}
\alias{assert_number}
\alias{testNumber}
\alias{test_number}
\alias{expect_number}
\title{Check if an argument is a single numeric value}
\usage{
checkNumber(
  x,
  na.ok = FALSE,
  lower = -Inf,
  upper = Inf,
  finite = FALSE,
  null.ok = FALSE
)

check_number(
  x,
  na.ok = FALSE,
  lower = -Inf,
  upper = Inf,
  finite = FALSE,
  null.ok = FALSE
)

assertNumber(
  x,
  na.ok = FALSE,
  lower = -Inf,
  upper = Inf,
  finite = FALSE,
  null.ok = FALSE,
  .var.name = vname(x),
  add = NULL
)

assert_number(
  x,
  na.ok = FALSE,
  lower = -Inf,
  upper = Inf,
  finite = FALSE,
  null.ok = FALSE,
  .var.name = vname(x),
  add = NULL
)

testNumber(
  x,
  na.ok = FALSE,
  lower = -Inf,
  upper = Inf,
  finite = FALSE,
  null.ok = FALSE
)

test_number(
  x,
  na.ok = FALSE,
  lower = -Inf,
  upper = Inf,
  finite = FALSE,
  null.ok = FALSE
)

expect_number(
  x,
  na.ok = FALSE,
  lower = -Inf,
  upper = Inf,
  finite = FALSE,
  null.ok = FALSE,
  info = NULL,
  label = vname(x)
)
}
\arguments{
\item{x}{[\code{any}]\cr
Object to check.}

\item{na.ok}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{FALSE}.}

\item{lower}{[\code{numeric(1)}]\cr
Lower value all elements of \code{x} must be greater than or equal to.}

\item{upper}{[\code{numeric(1)}]\cr
Upper value all elements of \code{x} must be lower than or equal to.}

\item{finite}{[\code{logical(1)}]\cr
Check for only finite values? Default is \code{FALSE}.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[\code{character(1)}]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertNumber}/\code{assert_number} return 
 \code{x} invisibly, whereas
 \code{checkNumber}/\code{check_number} and 
 \code{testNumber}/\code{test_number} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertNumber}/\code{assert_number}
 throws an error message, 
 \code{testNumber}/\code{test_number}
 returns \code{FALSE},
 and \code{checkNumber}/\code{check_number} 
 return a string with the error message.
 The function \code{expect_number} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a single numeric value
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\examples{
testNumber(1)
testNumber(1:2)
}
\seealso{
Other scalars: 
\code{\link{checkCount}()},
\code{\link{checkFlag}()},
\code{\link{checkInt}()},
\code{\link{checkScalar}()},
\code{\link{checkScalarNA}()},
\code{\link{checkString}()}
}
\concept{scalars}
