% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFCalendarProleptic.R
\docType{class}
\name{CFCalendarProleptic}
\alias{CFCalendarProleptic}
\title{Proleptic Gregorian CF calendar}
\description{
This class represents a standard CF calendar, but with the
Gregorian calendar extended backwards to before the introduction of the
Gregorian calendar. This calendar is compatible with the standard POSIXt
calendar, but note that daylight savings time is not considered.

This calendar includes dates 1582-10-14 to 1582-10-05 (the gap between the
Gregorian and Julian calendars, which is observed by the standard
calendar), and extends to years before the year 1, including year 0.
}
\section{Super class}{
\code{\link[CFtime:CFCalendar]{CFtime::CFCalendar}} -> \code{CFCalendarProleptic}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFCalendarProleptic-new}{\code{CFCalendarProleptic$new()}}
\item \href{#method-CFCalendarProleptic-valid_days}{\code{CFCalendarProleptic$valid_days()}}
\item \href{#method-CFCalendarProleptic-month_days}{\code{CFCalendarProleptic$month_days()}}
\item \href{#method-CFCalendarProleptic-leap_year}{\code{CFCalendarProleptic$leap_year()}}
\item \href{#method-CFCalendarProleptic-POSIX_compatible}{\code{CFCalendarProleptic$POSIX_compatible()}}
\item \href{#method-CFCalendarProleptic-date2offset}{\code{CFCalendarProleptic$date2offset()}}
\item \href{#method-CFCalendarProleptic-offset2date}{\code{CFCalendarProleptic$offset2date()}}
\item \href{#method-CFCalendarProleptic-clone}{\code{CFCalendarProleptic$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="is_compatible"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-is_compatible'><code>CFtime::CFCalendar$is_compatible()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="is_equivalent"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-is_equivalent'><code>CFtime::CFCalendar$is_equivalent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="offsets2time"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-offsets2time'><code>CFtime::CFCalendar$offsets2time()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="parse"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-parse'><code>CFtime::CFCalendar$parse()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="print"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-print'><code>CFtime::CFCalendar$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarProleptic-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarProleptic-new}{}}}
\subsection{Method \code{new()}}{
Create a new CF calendar.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarProleptic$new(nm, definition)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nm}}{The name of the calendar. This must be "proleptic_gregorian".
This argument is superfluous but maintained to be consistent with the
initialization methods of the parent and sibling classes.}

\item{\code{definition}}{The string that defines the units and the origin, as
per the CF Metadata Conventions.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new instance of this class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarProleptic-valid_days"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarProleptic-valid_days}{}}}
\subsection{Method \code{valid_days()}}{
Indicate which of the supplied dates are valid.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarProleptic$valid_days(ymd)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ymd}}{\code{data.frame} with dates parsed into their parts in columns
\code{year}, \code{month} and \code{day}. Any other columns are disregarded.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical vector with the same length as argument \code{ymd} has rows
with \code{TRUE} for valid days and \code{FALSE} for invalid days, or \code{NA} where
the row in argument \code{ymd} has \code{NA} values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarProleptic-month_days"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarProleptic-month_days}{}}}
\subsection{Method \code{month_days()}}{
Determine the number of days in the month of the calendar.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarProleptic$month_days(ymd = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ymd}}{\code{data.frame}, optional, with dates parsed into their parts.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Integer vector indicating the number of days in each month for
the dates supplied as argument \code{ymd}. If no dates are supplied, the
number of days per month for the calendar as a vector of length 12, for
a regular year without a leap day.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarProleptic-leap_year"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarProleptic-leap_year}{}}}
\subsection{Method \code{leap_year()}}{
Indicate which years are leap years.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarProleptic$leap_year(yr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{yr}}{Integer vector of years to test.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical vector with the same length as argument \code{yr}. \code{NA} is
returned where elements in argument \code{yr} are \code{NA}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarProleptic-POSIX_compatible"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarProleptic-POSIX_compatible}{}}}
\subsection{Method \code{POSIX_compatible()}}{
Indicate if the time series described using this calendar
can be safely converted to a standard date-time type (\code{POSIXct},
\code{POSIXlt}, \code{Date}).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarProleptic$POSIX_compatible(offsets)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{offsets}}{The offsets from the CFtime instance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarProleptic-date2offset"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarProleptic-date2offset}{}}}
\subsection{Method \code{date2offset()}}{
Calculate difference in days between a \code{data.frame} of time
parts and the origin.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarProleptic$date2offset(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\code{data.frame}. Dates to calculate the difference for.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Integer vector of a length equal to the number of rows in
argument \code{x} indicating the number of days between \code{x} and the \code{origin},
or \code{NA} for rows in \code{x} with \code{NA} values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarProleptic-offset2date"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarProleptic-offset2date}{}}}
\subsection{Method \code{offset2date()}}{
Calculate date parts from day differences from the origin. This
only deals with days as these are impacted by the calendar.
Hour-minute-second timestamp parts are handled in \link{CFCalendar}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarProleptic$offset2date(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Integer vector of days to add to the origin.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{data.frame} with columns 'year', 'month' and 'day' and as many
rows as the length of vector \code{x}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarProleptic-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarProleptic-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarProleptic$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
