% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.afex_aov}
\alias{predict.afex_aov}
\title{Predict method for \code{afex_aov} objects}
\usage{
\method{predict}{afex_aov}(object, newdata, append = FALSE, colname_predict = ".predict", ...)
}
\arguments{
\item{object}{\code{afex_aov} object.}

\item{newdata}{An optional data frame in which to look for variables with
which to predict. If omitted, the fitted values are used.}

\item{append}{If set to \code{TRUE} returns the residuals/fitted values
appended as an additional column to the long data. Recommended when data
was aggregated across within conditions.}

\item{colname_predict}{Name of the appended column when \code{append = TRUE}.}

\item{...}{Not used.}
}
\value{
A vector of predicted values corresponding to the data in
  \code{object$data$long} or to \code{newdata}, or if \code{append = TRUE} a
  data frame with an additional column of predicted values.
}
\description{
Predicted values based on \code{afex_aov} objects.
}
\examples{

data(obk.long, package = "afex")

# estimate mixed ANOVA on the full design:
fit <- aov_ez("id", "value", obk.long, between = c("treatment", "gender"), 
              within = c("phase", "hour"), observed = "gender")

new_data <- expand.grid(
  treatment = "A",
  gender = "F",
  phase = c("pre", "post"),
  hour = c(1, 5)
)

predict(fit, newdata = new_data)
predict(fit, newdata = new_data, append = TRUE)
}
\author{
Mattan S. Ben-Shachar
}
