% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getXrefList.R
\name{getXrefList}
\alias{getXrefList}
\title{Get Xref List}
\usage{
getXrefList(pathway = NULL, systemCode = NULL, compact = FALSE)
}
\arguments{
\item{pathway}{WikiPathways identifier (WPID) for the pathway to download, 
e.g. WP554}

\item{systemCode}{(\code{character}) The BridgeDb code associated with the 
data source or system, 
e.g., En (Ensembl), L (NCBI gene), H (HGNC), S (UniProt), Wd (Wikidata), 
Ce (ChEBI), Ik (InChI). See column two of 
https://github.com/bridgedb/datasources/blob/main/datasources.tsv.}

\item{compact}{(\code{Boolean}) Whether to return compact identifiers, like
ncbigene:1215. If FALSE (default), then just the identifier is returned, like
 1215}
}
\value{
A \code{list} of Xrefs identifiers
}
\description{
Retrieve the Xref identifiers for a specific pathway in a 
particular system code
}
\examples{
{
xrefs = getXrefList("WP2338", "L")
}
}
