% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5D_extras.R
\name{H5D_extras}
\alias{H5D_extras}
\alias{H5Dchunk_dims}
\alias{H5Dis_chunked}
\title{Additional functions for finding details of dataset chunking.}
\usage{
H5Dchunk_dims(h5dataset)

H5Dis_chunked(h5dataset)
}
\arguments{
\item{h5dataset}{Object of class \linkS4class{H5IdComponent} representing an open HDF5
dataset.}
}
\value{
\itemize{
\item \code{H5Dchunk_dims}: If the supplied dataset is chunked returns a vector, with length
equal to the rank of the dataset, containing the size of the dataset
dimensions.  Returns \code{NULL} if the given dataset is not chunked.
\item \code{H5Dis_chunked}: returns \code{TRUE} if a dataset is chunked and \code{FALSE} otherwise.
}
}
\description{
Additional functions for finding details of dataset chunking.
}
\details{
These functions do not map directly to the HDF5 C API but follow the same style and are
included as potentially useful additions.
\itemize{
\item \code{H5Dis_chunked} tests whether a dataset is chunked.
\item \code{H5Dchunk_dims} will return the dimensions of the dataset chunks.
}
}
\author{
Mike Smith
}
