% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/332-extractDrugLargestPiSystem.R
\name{extractDrugLargestPiSystem}
\alias{extractDrugLargestPiSystem}
\title{Descriptor that Calculates the Number of Atoms in the Largest Pi Chain}
\usage{
extractDrugLargestPiSystem(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules,
each column represents one feature.
This function returns one column named \code{nAtomP}.
}
\description{
Descriptor that Calculates the Number of Atoms in the Largest Pi Chain
}
\details{
This descriptor calculates the number of atoms in the largest pi chain.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'Rcpi')
\donttest{
mol = readMolFromSmi(smi, type = 'mol')
dat = extractDrugLargestPiSystem(mol)
head(dat)}
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{Chain}
\keyword{Largest}
\keyword{Pi}
\keyword{extractDrugLargestPiSystem}
