% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMethods.R
\name{getImputedData}
\alias{getImputedData}
\title{getImputedData}
\usage{
getImputedData(object, views = "all", features = "all",
  as.data.frame = FALSE)
}
\arguments{
\item{object}{a trained \code{\link{MOFAmodel}} object.}

\item{views}{character vector with the view name(s), or numeric vector with the view index(es). 
Default is "all".}

\item{features}{list of character vectors with the feature names or
 list of numeric vectors with the feature indices. 
Default is "all"}

\item{as.data.frame}{logical indicating whether to return a long-formatted data frame
 instead of a list of matrices. 
Default is \code{FALSE}.}
}
\value{
By default returns a list where each element is a matrix with dimensionality (D,N), 
where D is the number of features in this view and N is the number of samples. \cr
Alternatively, if \code{as.data.frame} is \code{TRUE},
 returns a long-formatted data frame with columns (view,feature,sample,value).
}
\description{
Function to get the imputed data. It requires the previous use of the
 \code{\link{impute}} method.
}
\examples{
# load a trained MOFAmodel object
filepath <- system.file("extdata", "CLL_model.hdf5", package = "MOFAdata")
MOFAobject <- loadModel(filepath)
# impute missing values
MOFAobject <- impute(MOFAobject)
# get imputations for a single view
imputedDrugs <- getImputedData(MOFAobject,view="Drugs")
head(imputedDrugs)
}
