% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_summaryStats.R
\name{plotReadCategoryCounts}
\alias{plotReadCategoryCounts}
\title{Plot the proportion of template, complement and 2D reads found a dataset.}
\usage{
plotReadCategoryCounts(summaryData)
}
\arguments{
\item{summaryData}{Object of class \linkS4class{Fast5Summary}.}
}
\value{
Returns an object of class \code{gg} representing the plot.
}
\description{
Generates a bar plot showing the breakdown of read types found in a set of fast5 files.  There is a strict hierarchy to the types of read that can be found in a fast5 file.  A full 2D read requires both a complement and template strand to have been read correctly.  Similarly, a complement strand can only be present if the template was read successfully.  Finally, you can encounter a file containing now called bases on either strand.
Here we visualise the total number of fast5 files, along with the counts containing each of the categories above.  For an ideal dataset all four bars will be the same height.  This is unlikely, but the drop between bars can give some indication of data quality.
}
\examples{
if( require(minionSummaryData) ) {
   data(s.typhi.rep2, package = 'minionSummaryData')
   plotReadCategoryCounts( s.typhi.rep2 )
}
}
