% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadLengthFromUCSC.R
\name{downloadLengthFromUCSC}
\alias{downloadLengthFromUCSC}
\title{Download Transcript Length Data}
\usage{
downloadLengthFromUCSC(genome, id)
}
\arguments{
\item{genome}{A string identifying the genome that \code{genes} refer to.
For a list of supported organisms see \code{\link{supportedGenomes}}.}

\item{id}{A string identifying the gene identifier used by \code{genes}.
For a list of supported gene identifierst see
\code{\link{supportedGeneIDs}}.}
}
\value{
A data.frame containing with three columns, the gene name,
transcript identifier and the length of the transcript.  Each row represents
one transcript.
}
\description{
Attempts to download the length of each transcript for the genome and gene
ID specified from the UCSC genome browser.
}
\details{
For each transcript, the UCSC genome browser is used to obtain the exon
boundaries.  The length of each transcript is then taken to be the sum of
the lengths of all its exons.  Each transcript is then associated with a
gene.

The UCSC does not contain length information for all combinations of genome
and gene ID listed by \code{\link{supportedGeneIDs}} and
\code{\link{supportedGenomes}}.  If \code{downloadLengthFromUCSC} fails
because your gene ID format is not supported for the genome you specified, a
list of possible ID formats for the specified genome will be listed.
}
\note{
For some genome / gene ID combinations, no gene ID will be provided by
UCSC.  In this case, the gene name column is set to \code{NA}.  However, the
transcript ID column will always be populated.
}
\examples{
\dontrun{
  flat_length <- downloadLengthFromUCSC('hg19', 'ensGene')
}

}
\seealso{
\code{\link{supportedGenomes}}, \code{\link{supportedGeneIDs}}
}
\author{
Matthew D. Young \email{myoung@wehi.edu.au}
}
