% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{assignSpecies}
\alias{assignSpecies}
\title{Taxonomic assignment to the species level by exact matching.}
\usage{
assignSpecies(
  seqs,
  refFasta,
  allowMultiple = FALSE,
  tryRC = FALSE,
  n = 2000,
  verbose = FALSE
)
}
\arguments{
\item{seqs}{(Required). A character vector of the sequences to be assigned, or an object 
coercible by \code{\link{getUniques}}.}

\item{refFasta}{(Required). The path to the reference fasta file, or an 
R connection. Can be compressed.
This reference fasta file should be formatted so that the id lines correspond to the
genus-species of the associated sequence:
  
 >SeqID genus species  
 ACGAATGTGAAGTAA......}

\item{allowMultiple}{(Optional). Default FALSE.
Defines the behavior when multiple exact matches against different species are returned.
By default only unambiguous identifications are return. If TRUE, a concatenated string
of all exactly matched species is returned. If an integer is provided, multiple
identifications up to that many are returned as a concatenated string.}

\item{tryRC}{(Optional). Default FALSE. 
If TRUE, the reverse-complement of each sequences will also be tested for exact matching 
to the reference sequences.}

\item{n}{(Optional). Default \code{2000}.
The number of sequences to perform assignment on at one time. 
This controls the peak memory requirement so that large numbers of sequences are supported.}

\item{verbose}{(Optional). Default FALSE.
If TRUE, print status to standard output.}
}
\value{
A two-column character matrix. Rows correspond to the provided sequences,
  columns to the genus and species taxonomic levels. NA indicates that the sequence
  was not classified at that level.
}
\description{
\code{assignSpecies} uses exact matching against a reference fasta to identify the 
genus-species binomial classification of the input sequences.
}
\examples{
seqs <- getSequences(system.file("extdata", "example_seqs.fa", package="dada2"))
species_fasta <- system.file("extdata", "example_species_assignment.fa.gz", package="dada2")
spec <- assignSpecies(seqs, species_fasta)

}
