\name{transformGRangesForEvenSpace}
\alias{transformGRangesForEvenSpace}
\title{Transform GRanges with New Coordinates}
\description{
  For graphics, like linked plot, e.g. generated by
  \code{qplotRangesLinkedToData} function in package ggbio.
  we need to generate a new set of coordinates which is used for even
  spaced statistics track.
}
\usage{
  transformGRangesForEvenSpace(gr)
}
\arguments{
  \item{gr}{
    A GRanges object.
  }
}
\value{
  A GRanges object as passed in, with new column x.new which indicate
  the static track coordinates, in this way, we could map the new
  coordinates with the old one.
}
\details{
  Most used internally for special graphics, like
  \code{qplotRangesLinkedToData} function in package ggbio.
}
\examples{
library(GenomicRanges)
gr <- GRanges("chr1", IRanges(seq(1,100, length.out = 10), width = 5))
library(biovizBase)
transformGRangesForEvenSpace(gr)
}
\author{Tengfei Yin}

