% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiocCheck-class.R
\name{BiocCheck-methods}
\alias{BiocCheck-methods}
\alias{add,BiocCheck-method}
\title{A list of methods for the BiocCheck reference class}
\arguments{
\item{...}{\code{character()} A vector that makes up the \code{BiocCheck} exception
message (e.g., 'Vignette must be built by R CMD build'). The character
vector is handled with \code{paste0} and made into a list and appended with
\code{help_text} and \code{messages}.}

\item{help_text}{\code{character(1)} Additional text prompting a list of files
(e.g,. "Found in files:")}

\item{condition}{\code{character(1)} One of the three conditions handled: \code{error},
\code{warning}, or \code{note}}

\item{messages}{\code{character()} Often a vector of file names where the check
was triggered.}

\item{debug}{\code{logical(1)} Whether to append the name of the originating check
name into for trace-ability}

\item{checkName}{\code{character(1)} The title of the current group of checks. It
can be set with \code{handleCheck}, e.g.,
\code{handleCheck("Checking for version number mismatch...")}. Internally, it
'  is saved with \code{setCheck} and obtained with \code{getLastCheck}.}

\item{isOnBBS}{\code{logical(1)} Indicates whether the checks are being run on the
Bioconductor Build System (BBS). This is helpful for avoiding the creation
of folders in the BBS.}

\item{file}{\code{character(1)} A path to a JSON file for writing or reading as
created by \code{toJSON} and \code{fromJSON} \code{BiocCheck} methods.}
}
\value{
An internal \code{BiocCheck} R5 Reference Class used to document
conditions such as errors, warnings, and notes
}
\description{
A list of methods for the BiocCheck reference class
}
\section{methods}{

\itemize{
\item \code{add}: Include a condition to the \code{BiocCheck} report
\item \code{getLastCheck}: Obtain the name of the last check run
\item \code{setCheck}: Create a new element in the internal list for a check
\item \code{get}: Extract the list of conditions raised by \code{BiocCheck}
\item \code{getNum}: Tally the number of condition provided by the input
\item \code{zero}: Reset the internal log of the condition provided
\item \code{addMetadata}: Add metadata to the \code{BiocCheck} object from a
\code{BiocPackage} object
\item \code{getBiocCheckDir}: Report and create the \verb{<package>.BiocCheck}
directory as obtained from the metadata
\item \code{composeReport}: Simplify the list structure from the \code{log} and
provide a character vector of conditions raised
\item \code{report}: Write the \verb{00BiocCheck.log} report into the \code{BiocCheck}
folder
\item \code{toJSON}: Write a JSON file to the location indicated with the
conditions raised
\item \code{fromJSON}: Read a JSON file from the location indicated with the
output of previous conditions raised in the check
\item \code{show}: Display the information in the class. Currently empty.
\item \code{show_meta}: Display the metadata information stored in the \code{metadata}
field
}
}

