% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiocCheck-class.R
\name{BiocCheck-class}
\alias{BiocCheck-class}
\title{A class for composing BiocCheck reports.}
\value{
A \code{BiocCheck} instance
}
\description{
The \code{BiocCheck} class provides a framework for reporting checks
based on Bioconductor guidelines. The class has several methods for working
with the provided checks that handle and display messages and the display
of the metadata. These methods also record the output of the \code{BiocCheck()}
report in both plain text and JSON formats.

\strong{Note} that currently, multiple \code{BiocCheck} runs will interfere with
each other given that they are implemented via a reference class semantic.
When running multiple checks in the same session, you can separate these
instances by running them in separate processes (e.g., via \code{BiocParallel}).
}
\details{
The metadata includes a number of standard fields to allow easier
troubleshooting and display of potentially relevant information. Currently,
the fields included are:
\itemize{
\item BiocCheckVersion:  The version of the BiocCheck package
\item BiocVersion:  The version of Bioconductor
\item Package:  The name of the package in check
\item PackageVersion:  The version of the package in check
\item sourceDir:  The directory of the package source or tarball in check
\item installDir: The directory where the package is installed for
testing, a temporary location by default
\item BiocCheckDir: The directory where the \verb{<package>.BiocCheck} folder
is saved. Usually the same folder as the package in check
\item platform:  The platform/OS where the check is taking place
\item isTarBall: Whether the package in check is a source directory or a
tarball
}
}
\section{Fields}{

\describe{
\item{\code{log}}{\code{list()} A running list of all conditions raised (i.e., notes,
warnings, errors)}

\item{\code{check}}{\code{character(1)} The title of the last check used for logging
purposes.}

\item{\code{error,warning,note}}{\code{list()} Finer extraction of each condition type}

\item{\code{metadata}}{\code{list()} A list of additional information relevant to the
package and its state. See details.}
}}

\examples{

bc <- BiocCheck:::.BiocCheck

}
\seealso{
\link{Message-class}
}
\keyword{internal}
