% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clearExternalDir.R
\name{clearExternalDir}
\alias{clearExternalDir}
\alias{clearObsoleteDir}
\title{Clear the external installation directory}
\usage{
clearExternalDir(path = getExternalDir())

clearObsoleteDir(path = getExternalDir())
}
\arguments{
\item{path}{String containing the path to the latest version of the directory of interest.}
}
\value{
For \code{clearExternalDir}, all conda instances (and associated environments) of the same Bioconductor release as the current \pkg{basilisk} installation are destroyed.

The same applies for \code{clearObsoleteDir} except that the conda instance generated by the latest \pkg{basilisk} installation is retained.
}
\description{
Clear the external installation directory by removing old Conda instances 
installed for different versions of \pkg{basilisk} with the same middle version number
(i.e., same Bioconductor release).
}
\details{
\code{clearObsoleteDir} can also be applied to the directories for the individual Conda environments,
as the package version is also suffixed onto those directory paths.
This is useful for clearing out obsolete versions of package environments.
}
\examples{
# We can't actually run clearExternalDir() here, as it 
# relies on basilisk already being installed.
print("dummy test to pass BiocCheck")

}
\seealso{
\code{\link{getExternalDir}}, which determines the location of the external directory.

\code{\link{installConda}}, for the motivation behind this function.
}
\author{
Aaron Lun
}
