% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readGRangesList.R
\name{readGRangesList}
\alias{readGRangesList}
\alias{loadGRangesList}
\title{Read a GRangesList from disk}
\usage{
readGRangesList(path, metadata, ...)
}
\arguments{
\item{path}{String containing a path to a directory, itself created with the \code{\link{saveObject}} method for \linkS4class{GRangesList}s.}

\item{metadata}{Named list of metadata for this object, see \code{\link{readObjectFile}} for details.}

\item{...}{Further arguments, to be passed to internal \code{\link{altReadObject}} calls.}
}
\value{
A \linkS4class{GRangesList} object.
}
\description{
Read a \linkS4class{GRangesList} object from its on-disk representation.
}
\examples{
gr <- GRanges(c("chrA", "chrB"), IRanges(c(1, 5), c(100, 200)))
seqlengths(gr) <- c(chrA=1000, chrB=2000)
grl <- split(gr, rep(1:3, length.out=length(gr)))

tmp <- tempfile()
saveObject(grl, tmp)
readObject(tmp)

}
