/****************************************************************************
**
** Copyright (C) 2017 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the Qt Mobility Components.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 2.0
import QtOrganizer 5.0

Item {
    anchors.centerIn: parent
    opacity: 0
    width: calendar.width;
    height: calendar.height - menuBar.height - statusBar.height - 50;

    Column {
        spacing: 2
        width: parent.width; height: parent.height;

        Text {
            text: "Todos:"
            height: 30
            anchors { horizontalCenter: parent.horizontalCenter }
            color: "white"
            font { pointSize: 15; weight: Font.Bold }
        }

        ListView {
            width: parent.width; height: parent.height;
            model: organizer.items
            clip: true
            delegate: Text {
                anchors { horizontalCenter: parent.horizontalCenter }
                color:  "white"
                text: "- " + displayLabel + " -"
            }
        }
    }
}
