/***************************************************************************
                          usercamera.cpp  -  description
                             -------------------
    begin                : Don Dez 15 2005
    copyright            : (C) 2005-2007 by Krippel Harald
    email                : harald@the-develop.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "usercamera.hpp"
#include <main.h>
#include "body.hpp"
#include "barrier.hpp"
#include "messages.hpp"

usercamera::usercamera(Camera *glcontext)
{
  scontext = glcontext;
  cbind=0;
  objtrans = NULL;
  item = NULL;
  miditem = NULL;
  // camera
  camtyp=2;
  kbcamrotadd='4';
  kbcamrotsub='6';
  camrotw=-90.0f;
  kbcamheightadd='8';
  kbcamheightsub='5';
  camhight= 5.0f;
  kbcamradadd='-';
  kbcamradsub='+';
  camradius=-10.0f;
  // kbd
  gox=0.0f;
  goy=0.0f;
  kbforward=0;
  kbback=0;
  kbleft=0;
  kbright=0;
}

void usercamera::update()
{
  sgVec3 up;
  float campos[3];
  sgCoord  pos;
  sgCoord  cpos;
  sgMat4   m;
  sgMat4 mcr;

    if(miditem != NULL){
      if(miditem->text(1) == "BODY"){
        if(miditem->body != NULL){
          miditem->body->getPosition (&pos);
        }
      }
      if(miditem->text(1) == "BARRIER"){
        if(miditem->barrier != NULL){
          miditem->barrier->getPosition (&pos);
        }
      }
      if(miditem->text(1) == "FIRE"   ||
         miditem->text(1) == "CAMERA" ||
         miditem->text(1) == "OBJECT"    ){
         if(miditem->objtrans != NULL){
           miditem->objtrans->getTransform ( m ) ;
           sgSetCoord  ( &pos, m ) ;
         }
      }

      if(camtyp==1){  // TV
        objtrans->getTransform ( m ) ;
        sgSetCoord  ( &cpos, m ) ;
        campos[0] = cpos.xyz[0] + camradius * sin(camrotw*SG_DEGREES_TO_RADIANS);
        campos[1] = cpos.xyz[1] + camradius * cos(camrotw*SG_DEGREES_TO_RADIANS);
        campos[2] = cpos.xyz[2] + camhight;
        sgSetVec3(up,0.0f,0.0f,1.0f);
        sgMakeLookAtMat4(cmat, campos,  pos.xyz,up);
      }
      if(camtyp==2){   // 2D
        campos[0] = pos.xyz[0] + camradius * sin(camrotw*SG_DEGREES_TO_RADIANS);
        campos[1] = pos.xyz[1] + camradius * cos(camrotw*SG_DEGREES_TO_RADIANS);
        campos[2] = pos.xyz[2] + camhight;
        sgSetVec3(up,0.0f,0.0f,1.0f);
        sgMakeLookAtMat4(cmat, campos,  pos.xyz,up);
      }
      if(camtyp==3){   // EGO
        campos[0] = pos.xyz[0];
        campos[1] = pos.xyz[1];
        campos[2] = pos.xyz[2];
        sgMakeRotMat4(mcr,-pos.hpr[0],pos.hpr[1],pos.hpr[2]);
        setUserCamera ( campos, (float *)mcr);
      }
      if(scontext != NULL){
//          objtrans->setTransform ( cmat ) ; // bug ?
          scontext -> setCamera(cmat);
      }
    } else {
       view();
    }
}

void usercamera::view()
{
  sgMat4   m;

    if(scontext != NULL){
      if(objtrans != NULL){
        objtrans->getTransform ( m ) ;
        scontext->makeCurrent();
        scontext->setCamera(m);
        scontext->setAspect((SGfloat)g_window_w/(SGfloat)g_window_h);
      }else{
        QString qmsg="no camera object found";
        qWarning(qmsg.toAscii());
        ErrorMsg errormsg(qmsg);
      }
    }
}

void usercamera::setUserCamera (const float pos[3], const float R[12])
{
  sgMat4 mt;
  sgMat4 m;
  sgMat4 m1;
  sgMat4 m2;

  m[0][0] = R[0] ;
  m[0][1] = R[4] ;
  m[0][2] = R[8] ;
  m[0][3] = SG_ZERO ; //x

  m[1][0] = R[1] ;
  m[1][1] = R[5] ;
  m[1][2] = R[9] ;
  m[1][3] = SG_ZERO ;  // y

  m[2][0] = R[2] ;
  m[2][1] = R[6] ;
  m[2][2] = R[10] ;
  m[2][3] = SG_ZERO ;  // z

  m[3][0] =  pos [0] ;
  m[3][1] =  pos [1] ;
  m[3][2] =  pos [2] ;

  m[3][3] =  SG_ONE ;

  sgMakeTransMat4(mt,0.0f,camradius,camhight);
  sgMakeRotMat4(m1,camrotw,0.0f,0.0f);
  sgMultMat4(m2,m,m1);
  sgMultMat4(cmat,m2,mt);
}

void usercamera::bind(const int id)
{
    cbind = id;
    if(id != 0 && item != NULL){
      if((miditem = item->search_id((FolderListItem *)item->treeWidget()->invisibleRootItem(),id)) == NULL){
            QString msg = "usercamera: There is no such Object as " + id ;
            qWarning(msg.toAscii());
            cbind =0;
      }
    }
}

void usercamera::kbd ( char key )
{
        // Keyboard Play
        if( key == kbforward)
          gox = -1;
        if( key == kbback)
          gox = 1;
        if( key == kbleft)
          goy = -1;
        if( key == kbright)
          goy = 1;

        // camera
        if( key == kbcamrotadd)
          camrotw += 4;
        if( key == kbcamrotsub)
          camrotw -= 4;
        if( key == kbcamheightadd)
          camhight += 1;
        if( key == kbcamheightsub)
          camhight -= 1;
        if( key == kbcamradadd)
          camradius += 1;
        if( key == kbcamradsub)
          camradius -= 1;
}

usercamera::~usercamera()
{

}
