# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class AgentStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Agent status."""

    REGISTERING = "Registering"
    OFFLINE = "Offline"
    ONLINE = "Online"
    EXECUTING = "Executing"
    REQUIRES_ATTENTION = "RequiresAttention"
    UNREGISTERING = "Unregistering"


class CopyMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Strategy to use for copy."""

    ADDITIVE = "Additive"
    MIRROR = "Mirror"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class EndpointType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Endpoint resource type."""

    AZURE_STORAGE_BLOB_CONTAINER = "AzureStorageBlobContainer"
    NFS_MOUNT = "NfsMount"


class JobRunScanStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of Agent's scanning of source."""

    NOT_STARTED = "NotStarted"
    SCANNING = "Scanning"
    COMPLETED = "Completed"


class JobRunStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of the Job Run in a non-terminal state, if exists."""

    QUEUED = "Queued"
    STARTED = "Started"
    RUNNING = "Running"
    CANCEL_REQUESTED = "CancelRequested"
    CANCELING = "Canceling"
    CANCELED = "Canceled"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"


class NfsVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The NFS protocol version."""

    NF_SAUTO = "NFSauto"
    NF_SV3 = "NFSv3"
    NF_SV4 = "NFSv4"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of this resource."""

    SUCCEEDED = "Succeeded"
