# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.managednetworkfabric import ManagedNetworkFabricMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-managednetworkfabric
# USAGE
    python network_to_network_interconnects_create_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ManagedNetworkFabricMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="subscriptionId",
    )

    response = client.network_to_network_interconnects.begin_create(
        resource_group_name="resourceGroupName",
        network_fabric_name="FabricName",
        network_to_network_interconnect_name="DefaultNNI",
        body={
            "properties": {
                "isManagementType": "True",
                "layer2Configuration": {"mtu": 1500, "portCount": 10},
                "layer3Configuration": {
                    "exportRoutePolicyId": "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName2",
                    "importRoutePolicyId": "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName1",
                    "peerASN": 50272,
                    "primaryIpv4Prefix": "172.31.0.0/31",
                    "primaryIpv6Prefix": "3FFE:FFFF:0:CD30::a0/126",
                    "secondaryIpv4Prefix": "172.31.0.20/31",
                    "secondaryIpv6Prefix": "3FFE:FFFF:0:CD30::a4/126",
                    "vlanId": 2064,
                },
                "nniType": "CE",
                "useOptionB": "False",
            }
        },
    ).result()
    print(response)


# x-ms-original-file: specification/managednetworkfabric/resource-manager/Microsoft.ManagedNetworkFabric/preview/2023-02-01-preview/examples/NetworkToNetworkInterconnects_Create_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
