#!/usr/bin/env python
# -*- mode: python; coding: utf-8; -*-
##---------------------------------------------------------------------------##
##
## Copyright (C) 1998-2003 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 2003 Mt. Hood Playing Card Co.
## Copyright (C) 2005-2009 Skomoroh
##
## This program is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program.  If not, see <http://www.gnu.org/licenses/>.
##
##---------------------------------------------------------------------------##

from mahjongg import r

# ************************************************************************
# * game definitions
# ************************************************************************

r(5001, "Altar", layout="0aaaacaaiaakaamaaoaaqaasaauaawaaCaaEaaacaccaicckccmccoccqccsccucawcaCcaEcaieckecmecoecqecsecueaweaigckgcmgcogcqgcsgcugawgaiiakiamiaoiaqiasiauiawiaokaqkaamacmaomaqmaCmaEmaaoacoaooaqoaCoaEohabhcbhCbhEbkpijpkipmhanhcnhCnhEnhpoobboDbobnoDnvlcvncvpcvrcvtcvlevnevpevrevtevlgwngwpgwrgvtgCocCqcCmeCoeCqeCse")
r(5002, "Arena", layout="0eaadcaceabgaaiaaqabsacuadwaeyadaccccbecagcakcbmcaocascbuccwcdyccaebceaeeameauebwecyebagacgakgbmgaogawgbygcaibciaeiamiauibwicyidakcckbekagkakkbmkaokaskbukcwkdykeamdcmcembgmaimaqmbsmcumdwmeym")
r(5003, "Arena 2", layout="0daadcabeabgaaiaakaamaaoaaqaasabuabwadyadAadaccccbecagcaucbwccycdAcdaecceaeeawecyedAedagccgaegawgcygdAgdaicciaeiawicyidAidakcckbekagkaukbwkcykdAkdamdcmbembgmaimasmbumbwmdymdAm")
#
r(5004, "Arrow", layout="0aaaaqbaacaccascaqdaudaaeaceaeeageaieakeameaoeaseaweaqfaufayfaagacgaegaggaigakgamgaogasgawgaAgaCgaqhauhayhaaiaciaeiagiaiiakiamiaoiasiawiaqjaujaakackaskaqlaamhbchrdhbehdehfehhehjehlehnehpehtehrfhvfhbghdghfghhghjghlghnghpghtghxghrhhvhhbihdihfihhihjihlihnihpihtihrjhbkoceoeeogeoieokeomeooeoqeosfocgoegoggoigokgomgoogoqgougoshocioeiogioiiokiomiooioqivfevhevjevlevnevpevfgvhgvjgvlgvngvpgvrgvfivhivjivlivnivpiCkeCmeCoeCkgCmgCogCqgCkiCmiCoi")
r(5005, "Art Moderne", layout="0acaaeaagaaiaakaamaaoaauaawaaabalcapcatcavcaxcaadaddaleapeaseauebxeaafacfalgangapgargatgavgaxgaahachaliapiasiauibxiaajadjalkapkatkavkaxkaalacmaemagmaimakmammaomaumawmhdahfahhahjahlahnahvahxahuchwchychedhldhpdhaehtehvehdfhlfhpfhaghsghughwghdhhlhhphhaihtihvihejhljhpjhukhwkhykhdmhfmhhmhjmhlmhnmhvmhxmowaoyaovcoxcozcofdokdoueoweoyeoefokfomgotgovgoehokhouiowioyiofjokjovkoxkozkowmoymvgdvjdvffvjfvlgvfhvjhvgjvjjChdCgfCifCkgCghCihChj")
r(5006, "Balance", layout="0eoaeebbgbbibbkbbmbbqbbsbbubbwbeybeoccedcydcoeccfaefcgfcwfayfcAfcogachaghawhaAhcoiaajacjaejagjaijaujawjayjaAjaCjcokadlaflaxlazlcomagoaioakoamoaooaqoasoauoawohbjhdjhfjhhjhvjhxjhzjhBjjeljylhhoijojloknokpojroitohvoocjoejogjowjoyjoAjvdjvfjvxjvzjCejCyj")
r(5007, "Bat", layout="0ecaeAaaabalbanbapbarbaCbcccaecayccAcaadandapdaCdcceaeebgeaieauebweayecAeaafanfapfaCfbcgbegaggbigakgasgbugawgbygbAgaahamhbohaqhaChbcibeiagibiiakiasibuiawibyibAiaajamjbojaqjaCjcckaekbgkaikakkaskaukbwkaykcAkaalaolaClccmaemaimakmasmaumaymcAmaanaCnecobkobsoeAohobhodhofhaghCghaihCi")
#
r(5008, "Beatle", layout="0aeaagaauaawaaicakcamcaocaqcascaeeageaieakeameaoeaqeaseaueadgafgahgajgalgangapgargatgavgaeiagiaiiakiamiaoiaqiasiauiaikakkamkaokaqkaskaemagmaumawmhhbhtbhjchlchnchpchrchdehfehhehjehlehnehpehrehteiegiggiigikgimgiogiqgisghughdihfihhihjihlihnihpihrihtihjkhlkhnkhpkhrkhhlhtloceogeoieokeomeooeoqeoseociogioiiokiomiooioqiosivbdvhevjevlevnevpevrevfgvhgvjgvlgvngvpgvrgvhivjivlivnivpivrivbjCaaCacCggCigCkgCmgCogCqgCakCam")
r(5009, "Big Hole", layout="0daadcadeadgadiadkadmadoaaaccccdecdgcdicdkccmcaocaaeccedeedkecmeaoeaagccgdegdkgcmgaogaaiccideidgidiidkicmiaoidakdckdekdgkdikdkkdmkdok")
r(5010, "Bizarre", layout="0aaaaGadkbdmbdobdqbdsbdubdwbdkdcmdcodcqdcsdcuddwddkfcmfbofbqfbsfcufdwfdkhcmhbohaqhbshcuhdwhakjbmjcojdqjcsjbujawjaklbmlcolcqlcslbulawlaknbmnbonbqnbsnbunawnakpampaopaqpaspaupawpaaqaGq")
r(5011, "Boat", layout="0alaapaataajcblcapcbtcavcahebjecleapectebveaxeafgbhgcjgdlgapgdtgcvgbxgazgadibfichidjieliapietidvicxibziaBiapkaambcmbembgmbimbkmbmmbombqmbsmbumbwmbymbAmbCmaEmadobfobhobjoblobnobpobrobtobvobxobzoaBoaiqbkqbmqboqbqqbsqbuqawq")
r(5012, "Bug", layout="0bhabnabtaajbapbavbcadaidakdamdaodaqdasdaudawdaceayeagfbifbkfbmfbofbqfbsfbufbwfaAfdegaygbchbghcihckhcmhcohcqhcshcuhbwhaAhdeiayiagjbijbkjbmjbojbqjbsjbujbwjaAjackaykcalailaklamlaolaqlaslaulawlajnapnavnbhobnobtohyhojfolfonfopforfotfovfojjoljonjopjorjotjovjvjhvlhvnhvphvrhvthCkhCmhCohCqhCsh")
r(5013, "Butterfly", layout="0dmadqaaabaebaybaCbagccocawcaadaedaidaudaydaCdaceageakedoeaseaweaAeaafaefbifamfaqfbufayfaCfacgaggbkgeogbsgawgaAgaahaehbihbmhbqhbuhayhaChaciagibkieoibsiawiaAiaajaejbijamjaqjbujayjaCjackagkakkeokaskawkaAkaalaelailaulaylaClacmagmeomawmaAmaanaenaynaCncoohgdhwdheehyehcfhgfhwfhAfhaghCghaihCihcjhgjhwjhAjhekhykhglhwl")
#
r(5014, "Castle", layout="0eaaccaceacgaciackaemacacaccaecagcaicakccmcdaeaceaeeageaieakedmeaoecagacgaegaggaigakgcmgbogaqgdaiaciaeiagiaiiakidmiaoicakackaekagkaikakkcmkeamccmcemcgmcimckmemmhddhfdhhdhjdhdfhffhhfhjfhdhhfhhhhhjhhdjhfjhhjhjjoeeogeoieoegoggoigoeiogioiivffvhfvfhvhhCgg")
r(5015, "Cat and Mouse", layout="0cfabhacjablacnabpacrabtacBacFabdbbvbbbcbxcbBccDcbFcahdajdaldbzdbaecBebDecFeahfajfalfbagahhajhalhbuhbBhbbibsibwibFibqjbBjbckbokbxkbFkcelbglcilbklcmlbsmbwmbunbAocCocEocGohiehkehighkgohdojdoldohfojfolfohhojholhoBkoFloAnvievkevigvkgvBlvFmCjdChfClfCjh")
r(5016, "Ceremonial", layout="0bcabeaajaalaanaapaaraataavabAabCabdcbfcbzcbBcaadapdaEdbeebgeanearebyebAeaafbifbkfapfbufbwfaEfbmgbsgaahaphaEhbmibsiaajbijbkjapjbujbwjaEjbekbgkankarkbykbAkaalaplaElbdmbfmbzmbBmbcobeoajoaloanoapoaroatoavobAobCohkahmahoahqahsahuahaehoehqehEehagipghEghaiipihEihakhokhqkhEkhkohmohoohqohsohuoonaopaoraopeoahoEhopkonoopoorovph")
r(5017, "Checkered", layout="0baabCaacbbebagbbibakbbmbaobbqbasbbubawbbybaAbbcdaedbgdaidbkdamdbodaqdbsdaudbwdaydbAdacfbefagfbifakfbmfaofbqfasfbufawfbyfaAfbchaehbghaihbkhamhbohaqhbshauhbwhayhbAhacjbejagjbijakjbmjaojbqjasjbujawjbyjaAjbclaelbglailbklamlbolaqlbslaulbwlaylbAlacnbenagnbinaknbmnaonbqnasnbunawnbynaAnbaobCo")
#
r(5018, "Chip", layout="0aeaaiaamaaqaatabecbgcbicbkcbmcbocbqcbscbucbwcaadbcdbydaAdbeecgecieckecmecoecqecsecuebweaagbcgbegdggbigakgamgaogaqgbsgdugbwgbygaAgbeicgiciickicmicoicqicsicuibwiaajbcjbyjaAjbekbgkbikbkkbmkbokbqkbskbukbwkaemaimammaqmaum")
r(5019, "Columns", layout="0egaaiaakaamaaoaaqaasaauaewaaebaybagcaicaocaucawceadbcdaedaydbAdeCdageekeameaoeaqeeseawebafbCfaggakgasgawgaahamheohaqhaChagiakiasiawibajbCjagkdkkamkaokaqkeskawkealbclaelaylbAleClagmaimaomaumawmaenaynegoaioakoamoaooaqoasoauoewohgfhwfjghjwhhgjhwj")
r(5020, "Crown", layout="0baabcabeabgabkabmaboabqabsabwabyabAabCabacaccaecbgcbkcamcbocaqcbscbwcaycaAcbCcbaeaeebgebkeameaqebsebweayebCebagaegbggbigbkgamgaqgbsgbugbwgaygbCgbaiaeiagiaiiakiamiaqiasiauiawiayibCibakbCkbamacmaemagmaimakmbomasmaumawmaymaAmbCmbaobcobeobgobiobkoamobooaqobsobuobwobyobAobCo")
#
r(5021, "Cupola", layout="0aiaakaamaaoaaqaasaagbaubaecawcacdaydabfeofazfaahajhalhanhapharhathaAhaajeojaAjablazlacnaynaeoawoagpaupaiqakqamqaoqaqqasqhjbhlbhnbhpbhrbhhchtchfdhvdhdehxehcghyghkhhmhhohhqhhshhbihzihckhykhdmhxmhfnhvnhhohtohjphlphnphpphrpokcomcoocoqcoidosdogeoueoefowfodholhonhophorhoxhodjoxjoelowlogmoumoinosnokoomoooooqovldvndvpdvjevrevhfvtfvfgvvgvmhvohvqhveivwivfkvvkvhlvtlvjmvrmvlnvnnvpnCifCsfCggCugCnhCphCfiCviCgkCukCilCsl")
r(5022, "Deep Well", layout="0acaaeaagaaiaakaamaaaccccceccgccicckccmcaocaaecceeeeegeeieekecmeaoeaagccgeegekgcmgaogaaiccieeiekicmiaoiaakcckeekegkeikekkcmkaokaamccmcemcgmcimckmcmmaomacoaeoagoaioakoamo")
r(5023, "Dragon", layout="0bgaaiaegceicdkccmcbocbqcbscbucawcaycaceaeeageaieakebmeboeaqeaseaueaweayeadgbfgahgajgalgangapgaEgayhaChaaiaciaeiagiaiiakiamiaoiaqiasiauiaAiaEiaCjabkadkafkahkajkalkaEkaamacmaemagmbimakmaaoacobeoagoaiockoamoixchdejhejigkkgjmghEhhbihdikhikjijliiniipihrihtihCihEjhckhgkhkkhbmhfmhboihopneocioEiobn")
r(5024, "Dude", layout="0bfabtabhbbjbblbbrbaBbatcavcaxcazcaedagdbldbndbpdbrdacebjebueayeaAeaCeaafbhfcmfcofcqfcsfbwfaEfbfgckgcugbygcphbAhbeickicuicpjbBjcjkclkcnkcrkctkcvkcjmclmcnmcrmctmcvmcpncjocvockqcmqcoqcqqcsqcuq")
#r(5025, "Eagle", layout="0cmadoacqaasbbmcbocaedagdaudawdbcebieakebmeboeaqebsebyeaefagfaufawfbcgbigakgbmgbogaqgbsgbygaehaghauhawhaaiacibmiboiayiaAibejbwjaakackbmkbokaykaAkaambkmanmbqmaAmcioclocpocsoheehgehuehweheghgghughwghbihzihbkhzkomdoododeofeoheoteoveoxeomfoofodgofgohgotgovgoxgomhoohobjomjoojozjvndveevgevuevwevnfvegvggvugvwgvnhvnjCfeCveCfgCvg")
r(5026, "Enterprise", layout="0agaaiaakaamaaoaaqaasaauaawaayaaacbccbecbgcbicbkcbmcbocbqcbscbucbwcbycbAcbCcaEcdqedogdmhaAiaajbcjcejdgjeijekjemjeojcqjayjaCjaAkhhaijailainaipairaitaivahxaiAjodcofcohcojcolconcopcorcotcovcoxcozcoBcvkavmavoavqavsavecvgcvicvkcvmcvocvqcvscvucvwcvycChcCjcClcCncCpcCrcCtcCvc")
#
r(5027, "Eye", layout="0amaaoaakbaqbaicamcaocascagdakdaqdaudaeeaieameaoeaseaweacfagfakfaqfaufayfaagaegaigamgaogasgawgaAgachaghakhaqhauhayhaeiaiiamiaoiasiawiagjakjaqjaujaikamkaokaskaklaqlammaomhlbhobhjchqchhdhldhodhsdhfehjehqehuehdfhhfhlfhofhsfhwfhfghjghqghughdhhhhhlhhohhshhwhhfihjihqihuihhjhljhojhsjhjkhqkhllhololcoocojdoqdoheoleooeoseoffojfoqfoufohgolgoogosgowgofhojhoqhouhohioliooiosiojjoqjolkookvldvodvjevqevhfvlfvofvsfvfgvjgvqgvhhvlhvohvshvjivqivljvoj")
r(5028, "F-15 Eagle", layout="0aobaqbasbaubbEcbGcandapdardatdalebDebFeajfanfapfarfalgatgavgaxgazgaBgaDgabhadhafhahhajhanhapharhaliatiaviaxiaziaBiaDiajjanjapjarjalkbDkbFkanlaplarlatlbEmbGmaonaqnasnaunhpahrahtahvahochqchschuchmehoehqehsehifhkfhmghoghqghsghughwghyghAghCgiahichjehjghjihjkhhmihoihqihsihuihwihyihAihCihijhkjhmkhokhqkhskhomhqmhsmhumhpohrohtohvoozfoBfoDfomhozjoBjoDjvAfvCfvAjvCjCBfCDfCfhChhCjhCBjCDj")
r(5029, "Farandole", layout="0beabgabmaboabqabwabyabcbbibbkbbsbbubbAbafcaxcbbdbBdckecmecqecsebbfbgfcifcufbwfbBfbegbygbahbchajhblhcnhcphbrhathbAhbChbeibyibbjbgjcijcujbwjbBjckkcmkcqkcskbblbBlafmaxmbcnbinbknbsnbunbAnbeobgobmoboobqobwobyo")
r(5030, "Fish", layout="0afaajaasaauaawabhbaobaqbaybaccamcbscbucbwcaAcakdbodbqdaydaCdaceaeeaiebmebsebuebweaEeagfbkfbofbqfayfaCfacgaegaigbmgbsgbugbwgaAgaEgakhbohbqhbyhaChaciamibsibuibwiaAiaojaqjayjahkaskaukawkbjlcemalmbcndgnbCnaaoeioaqoasodAoaEodkpbopbupdypcmqcwqhcdhcfhefhifhchoreoteolfonfopfovforgotgovhoxh")
#
r(5031, "Five Pyramids", layout="0aaaacaaeaagaayaaAaaCaaEaaacaccaecagcapcaycaAcaCcaEcaaeaceaeeageapeayeaAeaCeaEeaagacgaegaggangapgargaygaAgaCgaEgalhathaniapiariaakackaekagkapkaykaAkaCkaEkaamacmaemagmapmaymaAmaCmaEmaaoacoaeoagoayoaAoaCoaEoaaqacqaeqagqayqaAqaCqaEqhbbhdbhfbhzbhBbhDbhbdhddhfdhpdhzdhBdhDdhbfhdfhffipfhzfhBfhDfhnhhphhrhipjhblhdlhflhplhzlhBlhDlhbnhdnhfnhznhBnhDnhbphdphfphzphBphDpoccoecoAcoCcoceoeeoAeoCeoohoqhocmoemoAmoCmocooeooAooCovddvBdvphvdnvBn")
#r(5032, "Five Pyramids 2", layout="0aoaaabacbaebagbawbaybaAbaCbbocaadacdaedagdaidakdamdaqdasdaudawdaydaAdaCdcoeaafacfaefagfawfayfaAfaCfamgdogaqgadhazhagibiickidmidoidqicsibuiawiadjazjamkdokaqkaalaclaelaglawlaylaAlaClcomaanacnaenagnainaknamnaqnasnaunawnaynaAnaCnbooaapacpaepagpawpaypaApaCpaoqhbchdchfchxchzchBchbehdehfehxehzehBehbmhdmhfmhxmhzmhBmhbohdohfohxohzohBoocdoedoydoAdocnoenoynoAn")
r(5033, "Flowers", layout="0baaccaceabgaakabmaboaaqaauabwabyaaAadacdgcckccqccuccAcbaecceceebgeakebmeboeaqeauebwebyeaAeadgangaxgafhahhajhalhapharhathavhadianiaxiaakbckbekagkakkbmkbokaqkaukbwkbykaAkcamcgmckmcqmcumcAmaaobcobeoagoakobmobooaqoauobwobyoaAoonaoxaoneoxeodkonkoxkodoonooxovdavde")
r(5034, "Flying Dragon", layout="0acaaeaagaaiaakaamaaoaaqaasaauaawaayaagcbicbkcbmcbocbqcbscaucaeeagebieckecmecoecqebseaueaweacgaegaggbigckgdmgdogcqgbsgaugawgaygaahaAhaChaciaeiagibiickidmidoicqibsiauiawiayiaekagkbikckkcmkcokcqkbskaukawkagmbimbkmbmmbombqmbsmaumacoaeoagoaioakoamoaooaqoasoauoawoayoCnh")
r(5035, "Fortress Towers", layout="0faaecadeacgabiabkacmadoaeqafsaeacaccagcaicakcamcaqcescdaeaceageaieakeameaqedsedagacgaggaigakgamgaqgdsgeaiaciagiaiiakiamiaqiesifakeckdekcgkbikbkkcmkdokeqkfskhjchjehjghji")
#
r(5036, "Full Vision", layout="0aaaaiaamaaoaaqaasaawaaEaacbaebagbaybaAbaCbaacaicamcaocaqcascawcaEcacdaedagdaydaAdaCdaaeaieaweaEeaefamfasfaAfaggaigakgaugawgaygaehamhashaAhagiaiiakiauiawiayiaejamjasjaAjaakaikawkaEkaclaelaglaylaAlaClaamaimaomaqmawmaEmacnaenagnamnasnaynaAnaCnaaoaioaooaqoawoaEohpahbbhhbhnbhrbhxbhDbhdchfchpchzchBchbdhhdhxdhDdhfghlghtghzghhhhjhhvhhxhhfihlihtihzihblhhlhxlhDlhdmhfmhzmhBmhbnhhnhnnhpnhrnhxnhDnooboqboccogcoycoCcoghokhouhoyhocmogmoymoCmvpb")
#
r(5037, "Full Vision 2", layout="0aaaacaafaahaakaamaapaaraauaawaazaaBaaacaccafcahcakcamcapcarcaucawcazcaBcaaeaceafeaheakeameapeareaueaweazeaBeaagacgafgahgakgamgapgargaugawgazgaBgaajacjaejagjakjamjapjarjavjaxjazjaBjaalaclaelaglaklamlaplarlavlaxlazlaBlaeoagoaioakoamoapoaroatoavoaxohbbhgbhlbhqbhvbhAbhadhcdhfdhhdhkdhmdhpdhrdhudhwdhzdhBdhbfhgfhlfhqfhvfhAfhdjhyjhbkhfkhkkhmkhpkhrkhwkhAkhdlhylobcogcolcoqcovcoAcobeogeoleoqeoveoAeockoekolkoqkoxkozkvbdvgdvldvqdvvdvAdvdkvyk")
r(5038, "Future", layout="0cgaaiaakaamaboaaqaasaauacwaagccicakcamcbocaqcasccucawcaeeageaiebkebmeboebqebseaueaweayeacfaAfaagcegcggdigdkgdmgdogdqgdsgdugcwgcygaCgachaAhaeiagiaiibkibmiboibqibsiauiawiayiagkcikakkamkbokaqkaskcukawkcgmaimakmammbomaqmasmaumcwmhcghAgoneopeoniopiClgCngCpgCrg")
r(5039, "Garden", layout="0adaafaaoaaqaazaaBaaabaibalbatbawbaEbaccaecagcancapcarcaycaAcaCcaadaidaldatdawdaEdaceaeeageaneapeareayeaAeaCeaafaifalfatfawfaEfachaehaghanhapharhayhaAhaChaajaijaljatjawjaEjackaekagkankapkarkaykaAkaCkaalailallatlawlaElacmaemagmanmapmarmaymaAmaCmaanainalnatnawnaEnadoafoaooaqoazoaBoheahpahAahcdhedhgdhndhpdhrdhydhAdhCdhdhhfhhohhqhhzhhBhhclhelhglhnlhplhrlhylhAlhClheohpohAooddofdoodoqdozdoBdoehophoAhodloflooloqlozloBlvedvpdvAdvelvplvAl")
r(5040, "Gayle's", layout="0dcaceabgaaiaakaamaaoaaqaasabuacwadyaagcbicckccmccoccqcbscaucakebmeboeaqeacgaegaggbigbkgbmgbogbqgbsgaugawgaygaahaAhaciaeiagibiibkibmiboibqibsiauiawiayiakkbmkbokaqkagmbimckmcmmcomcqmbsmaumdcoceobgoaioakoamoaooaqoasobuocwodyoojholhonhophorhvncvmhvohvnmCnh")
r(5041, "Glade", layout="0aaaacaaCaaEaaacaccaCcaEcahdejdcldcndbpdcrdctdevdaxddhfcjfblfbnfbpfbrfbtfcvfdxfchhbjhblhanharhbthbvhcxhdhjcjjbljbnjbpjbrjbtjcvjdxjahlejlcllcnlbplcrlctlevlaxlaamacmaCmaEmaaoacoaCoaEohbahDahbchDchbmhDmhbohDoobboDbobnoDn")
r(5042, "H for Haga", layout="0aaaacaaeaagaakaamaaoaaqaaacaccaecagcakcamcaocaqcaaeaceaeeageakeameaoeaqeaifaagacgaegaggakgamgaogaqgaihaaiaciaeiagiakiamiaoiaqiaijaakackaekagkakkamkaokaqkaamacmaemagmakmammaomaqmaaoacoaeoagoakoamoaooaqohbbhdbhfbhlbhnbhpbhbdhddhfdhldhndhpdhbfhdfhffhlfhnfhpfhhghjghbhhdhhfhhlhhnhhphhhihjihbjhdjhfjhljhnjhpjhblhdlhflhllhnlhplhbnhdnhfnhlnhnnhpnoccoecomcoococeoeeomeooeocgoegomgoogoghoihokhocioeiomiooiockoekomkookocmoemommoomvddvndvdlvnl")
#r(5043, "H for Haga Traditional", layout="0acaaeaagaaiaakaamaaoaaqaasaauaawaayabgcbicakcamcaocaqcbscbucaeebgebieakeameaoeaqebsebueaweacgaegbggbigbkgbmgbogbqgbsgbugawgaygaahaAhaciaeibgibiibkibmiboibqibsibuiawiayiaekbgkbikakkamkaokaqkbskbukawkbgmbimakmammaomaqmbsmbumacoaeoagoaioakoamoaooaqoasoauoawoayoklcknckpchdhhxhklmknmkpm")
r(5044, "Helios", layout="0eaadcaduaewadacbccbucdwcbaeaceaeeaiedkedmeaoeaseauebwebagacgaegaggdigdogaqgasgaugbwgblhbaiaciaeiagidiidoiaqiasiauibwibakackaekaikdkkdmkaokaskaukbwkdambcmbumdwmeaodcoduoewohchhehhghhqhhshhuhCleCihCohClk")
r(5045, "High and Low", layout="0eaadcaceabgaaiabkacmadoaeqadaccccdecagcbicckcbmceocdqccaebceeeebgeciedkeamedoecqebagacgdegcggdigekgbmgcogbqgaaibciceidgieiidkicmiboiaqiaekagkbikakkamkahmajmhim")
#
#r(5046, "Hourglass", layout="0aaaacaaeaagaaiaakaamaaoaaqaasaauaawaayaaacamcaycacdawdaaeaeeameaueayeacfagfasfawfaagaegaigamgaqgaugaygachaghbkhbohashawhaaiaeiaiiamiaqiauiayiacjagjasjawjaakaekamkaukaykaclawlaamammaymaaoacoaeoagoaioakoamoaooaqoasoauoawoayohabhmbhybhadhmdhydhcehwehafhefhufhyfhcghgghsghwghahhehhihhqhhuhhyhhcihgihsihwihajhejhujhyjhckhwkhalhmlhylhanhmnhynoacoycoaeoyeoagoygoaioyioakoykoamoymvadvydvafvyfvahvyhvajvyjvalvylCaeCyeCagCygCaiCyiCakCyk")
r(5047, "Inca", layout="0aoaaqaaibakbambasbaubawbbocbqcaidbkdbmdbsdbudawdcoecqeaifbkfcmfcsfbufawfaagacgdogdqgaCgaEgahhbjhclhcthbvhaxhaaiacidoidqiaCiaEiahjbjjcljctjbvjaxjaakackdokdqkaCkaEkailbklcmlcslbulawlcomcqmainbknbmnbsnbunawnboobqoaipakpampaspaupawpaoqaqqhbihDiCphCpj")
r(5048, "Inner Circle", layout="0aaaacaayaaAaaaceccceccgcbicbkcamcaocbqcbsccuccwceycaAcccecyedgfcifbkfbqfcsfdufbcgbygaghbuhbcibyiegjdijckjbmjbojcqjdsjeujcckcykaamecmcemcgmbimbkmbqmbsmcumcwmdymaAmaaoacoakoaqoayoaAo")
r(5049, "Joker", layout="0aaaaAaadbafbahbajbalbanbapbarbatbavbaxbabdbddbfdbhdbjdbldbndbpdbrdbtdbvdbxdazdcbfbdfaffahfajfalfanfapfarfatfavfbxfczfcbhbdhafhavhbxhczhajiamiapiasicbjbdjafjavjbxjczjcblbdlaflahlajlallanlaplarlatlavlbxlczlabnbdnbfnbhnbjnblnbnnbpnbrnbtnbvnbxnaznadpafpahpajpalpanpapparpatpavpaxpaaqaAqhgghughgkhuk")
r(5050, "K for Kyodai", layout="0caaccaceacmacoacqacacbcccecckcbmccoccaebceceeciebkecmecagbcgcegcggbigckgcaibcibeibgiciicakbckcekcgkbikckkcambcmcemcimbkmcmmcaobcoceockobmocoocaqccqceqcmqcoqcqq")
#r(5051, "K for Kyodai Traditional", layout="0acaaeaagaaiaakaamaaoaaqaasaauaawaayaagcaicakcamcaocaqcascaucaeeageaieakeameaoeaqeaseaueaweacgaegaggaigakgamgaogaqgasgaugawgaygaahaAhaciaeiagiaiiakiamiaoiaqiasiauiawiayiaekagkaikakkamkaokaqkaskaukawkagmaimakmammaomaqmasmaumacoaeoagoaioakoamoaooaqoasoauoawoayokjckrckpdkjehgfknfhufkjghghklhhuhkjihgjknjhujkjkkplkjmkrm")
r(5052, "Km", layout="0baabcabiaakaboacqacyabAabacaccbgcaicbocaqcdscdwcaycbAcdudbaeacebeeageboeaqeaseaweayebAeeufbagacgbegaggbogaqgaygbAgduhbaiacibgiaiiboiaqiayibAibakbckbikakkbokbqkbykbAkjcfhgfoabooboAboadoodoAdoafoefoofoAfoahoohoAhoajoojoAjvacvocvAcvaevoevAevagvogvAgvaivoivAiCadCodCAdCafCofCAfCahCohCAh")
r(5053, "Kujaku", layout="0bnabpabrabtabvabxablbczbaBbbhcbjcancapcarcatcavcaxcaddbfdaldazddBdaDdaheajeabfcdfaffaAfdCfaEfbahcchaehakhamhaohashaAhdChaEhabjcdjafjaAjdCjaEjahkajkadlbflallazldBlaDlbhmbjmanmapmarmatmavmaxmblncznaBnbnobpobrobtobvobxohnghpghtghjhhnihpihtioofoqfoufoihoojoqjoujvpevrevvfvhhvvjvpkvrkCwgCCgCghCwiCCi")
r(5054, "Labyrinth", layout="0caaacaaeaagaaiaakaamaaoaaqaasaauaawaayaaAaaCacEaaacbkcbocbucaEcaaebcebeebgebkeboebsebuebyebAeaEeaagbkgbygaEgaaibeibiibkiboibqibsibuibwibyibAiaEiaakbekbokbwkaEkaambembgmbimbkmbombqmbsmbwmbAmbCmaEmaaobkobwoaEocaqacqbeqdgqdkqbmqaoqaqqasqauqbwqdyqdCqbEq")
r(5055, "Lion", layout="0bdbbfbcjbclbawbaybbbcbhcaucaAccjdcldasdaCdbaeaqecvfczfaDfbbgapgaEhcbiceichickiaoicxiaFjcckcfkcikclkbokcwkcykbulbAlaElcbmcemchmckmcnmbqmaDnccocfocioclocooaroatoavoaxoazoaBohvahxahzahtbhBbhrchDdhpehEfhoghFhhnihGjhFlhEnhsohCohuphwphyphApwkc")
r(5056, "Lost ", layout="0afaaxaabbadbahbajbblbbnbbpbbrbatbavbazbaBbafcaxcabdaddbkdcodbsdazdaBdbiebmebqebueaafacfaefbgfdofbwfayfaAfaCfaahaehbghcihckhdmhdohdqhcshcuhbwhayhaChaajacjaejbgjdojbwjayjaAjaCjbikbmkbqkbukabladlbklcolbslazlaBlafmaxmabnadnahnajnblnbnnbpnbrnatnavnaznaBnafoaxoombooboqbomnoonoqn")
r(5057, "Maya", layout="0aaaacaaeaagaaiaaqaasaauaawaayaaacaccaecagcaicaqcascaucawcaycaaeaceaeeageaieakeameaoeaqeaseaueaweayeaigakgamgaogaqgaiiakiamiaoiaqiaakackaekagkaikakkamkaokaqkaskaukawkaykaamacmaemagmaimaqmasmaumawmaymaaoacoaeoagoaioaqoasoauoawoayohcbhebhgbhsbhubhwbhcdhedhgdhsdhudhwdhkfhmfhofhkhhmhhohhkjhmjhojhclhelhglhslhulhwlhcnhenhgnhsnhunhwnoccoecogcoscoucowcolfonfolhonholjonjocmoemogmosmoumowmvdcvfcvtcvvcvmfvmhvmjvdmvfmvtmvvmCecCucCmgCmiCemCum")
r(5058, "Mesh", layout="0baabcabeabiabkabmabqabsabuabyabAabCabacbecbicbmcbqcbucbycbCcbaebcebeeagebiebkebmeaoebqebsebueawebyebAebCeaegbigbmgbqgbugaygbaibcibeiagibiibkibmiaoibqibsibuiawibyibAibCibakbekbikbmkbqkbukbykbCkbambcmbembimbkmbmmbqmbsmbumbymbAmbCm")
r(5059, "Moth", layout="0baaccaceabgaanaapaarabyacAacCabEaaibawbbccagcakccpcaucaycbCcaidamdasdawdadeakeboebqeaueaBeamfasfacgaegahgajgbogbqgavgaxgaAgaCgamhashadiakiboibqiauiaBiaijamjasjawjbckagkakkcpkaukaykbCkailawlccmcembgmbpmbymcAmcCmbanbEnhoahqahichwchmehsehdghighwghBghmihsihikhwkopaoneopeoreppgoniopiorivdavBavoevqevoivqivdmvBmCpeCpi")
r(5060, "N for Namida", layout="0caaccaceacgacqacsacuacacbccbecbgcbiccqcbsccuccaebcebeebgebiebkecqebsecuecagbcgcegbigbkgbmgcqgbsgcugcaibciceibkibmiboibqibsicuicakbckcekbmkbokbqkbskcukcamccmcemcomcqmcsmcum")
#r(5061, "N for Namida Traditional", layout="0acaaeaagaaiaakaamaaoaaqaasaauaawaayacgcaicakcbmccoccqcasccucaeecgecieakeameaoeaqeasecueaweacgaegcggcigakgcmgaogaqgasgcugawgaygaahaAhaciaeicgiaiiakicmiaoicqiasicuiawiayiaekcgkaikakkamkaokcqkaskcukawkcgmaimckmcmmbomaqmasmcumacoaeoagoaioakoamoaooaqoasoauoawoayoikfikhiohiojisjisl")
#r(5062, "Naoki Haga Traditional", layout="0acaaeaagaaiaakaamaaoaaqaasaauaawaayadgcaicakcdmcaocaqcascaucaeedgeaiedkedmeaoecqecseaueaweacgaegdggaigakgdmgaogaqgasgaugawgaygaahaAhaciaeiagiaiiakiamidoiaqiasiduiawiayiaekagkcikckkamkdokdqkdskdukawkagmaimakmammdomaqmasmdumacoaeoagoaioakoamoaooaqoasoauoawoayojidvrevjk")
#
r(5063, "New Layout", layout="0aeaagaaiaakabpaauaawaayaaAaaccaCcahdajdavdaxdaaeacealeateaCeaEeanfarfaagacgahgapgaCgaEganharhaaiacialiatiaCiaEiahjajjavjaxjackaCkaemagmaimakmbpmaumawmaymaAmhfahhahjahvahxahzahcdhidhwdhCdhkehuehafhcfhmfhofhqfhsfhCfhEfhahhchhmhhohhqhhshhChhEhhkihuihcjhijhwjhCjhfmhhmhjmhvmhxmhzmogaoiaowaoyaoceojeoveoCeolfotfoagocgongopgorgoCgoEgolhothociojiovioCiogmoimowmoymvhavxavcfvkfvufvCfvmgvogvqgvsgvchvkhvuhvChvhmvxmCcgClgCngCpgCrgCtgCCg")
r(5064, "Order", layout="0afaahaajaalaanaapaaraataaabaybaicakcamcaocaqcbadacdaedaudawdbydakebmeaoecafbcfaefaufbwfcyfaggaigakgbmgaogaqgasgcahcchbehbuhcwhcyhagiaiiakibmiaoiaqiasicajbcjaejaujbwjcyjakkbmkaokbalaclaelaulawlbylaimakmammaomaqmaanaynafoahoajoaloanoapoaroatohgahiaikaimaioahqahsahlchnchghhihhkhhohhqhhshhlmhnmhgohioikoimoioohqohsoomcpmhomm")
r(5065, "Pattern", layout="0aaaacaafaahaakaamaapaaraauabwabzaaBaaacaccafcahcakcamcapcarcbuccwcczcbBccafacfaffchfckfcmfapfarfcufawfazfcBfaahcchcfhahhakhamhcphcrhcuhawhazhcBhaakackafkahkakkcmkcpkarkcukcwkczkcBkaamacmafmahmckmammapmcrmaumcwmczmaBmibailaifbihbibciqciqfilhialihl")
#r(5066, "Phoenix", layout="0aaaacaapaaraaEaaGaaebatbaCbaacagcapcarcaAcaGcaidaydakeboebqebseaweaafacfaefamfaufaCfaEfaGfaggbpgbrgaAgaahaihamhauhayhaGhaeiakicpicriawiaCiaajamjaujaGjbpkbrkaclaelaglailamlaulaylaAlaClaElakmbpmbrmawmacnafnamnaunaBnaEnaioaooasoayoacpafpaBpaEpakqawqhbbhFbhdchDchfdhBdhhehzehjfhxfhdghlghvghDghfhhBhhhihnihtihzihjjhxjhdkhlkhvkhDkhflhnlhtlhBlhhmhzmhjnhxnhlohvohnphtponfppfprfotfoplorlvqivqlCqf")
r(5067, "Portal", layout="0accagcawcaAcaedaydaceageaweaAeamgaqgamiaqiackagkawkaAkaelaylacmagmawmaAmhbbhdbhfbhhbhvbhxbhzbhBbhbdhhdhvdhBdhbfhdfhffhhfhlfhnfhpfhrfhvfhxfhzfhBfhlhhrhhbjhdjhfjhhjhljhnjhpjhrjhvjhxjhzjhBjhblhhlhvlhBlhbnhdnhfnhhnhvnhxnhznhBnoaaocaoeaogaoiaouaowaoyaoAaoCaoacoicoucoCcoaeoieokeomeooeoqeoseoueoCeoagocgoegoggoigokgosgougowgoygoAgoCgoaiocioeiogioiiokiosiouiowioyioAioCioakoikokkomkookoqkoskoukoCkoamoimoumoCmoaoocooeoogooioouoowooyooAooCo")
r(5068, "Rocket", layout="0amaaoaaqaazaaBaaDaakbaicamcaocaqcascaxcazcaBcaDcagdakdaudaeeaieameaqeaseaweayeacfagfakfaofaufaBfaegasgawgaygaahbchbghbihbkhbmhbohcqhauhaAhaChaeiasiawiayiacjagjakjaojaujaBjaekaikamkaqkaskawkaykaglaklaulaimammaomaqmasmaxmazmaBmaDmaknamoaooaqoazoaBoaDohnahpahlbhBbhjchnchpchhdhsdhfehxehdfhsfhughehhshiwhhyhhuihdjhsjhfkhxkhhlhslhjmhnmhpmhlnhBnhnohpoonbopbosgodhofhohhojholhonhouhosionnopnvobvehvghvihvshvonCfh")
r(5069, "Scorpion", layout="0avaacbaebagbaibaacaxcazcagdaidakdaoeaseayeaAeaafacfaefagfaifakfcmgaogcqgasgcugawgbygbAgckhciidmiaoicqiasiduiawibyibAickjcmkaokcqkaskcukawkbykaalaclaelaglailaklaomasmawmagnainaknaaoacpaepagpaiphdbhfbhhbhwbhbchychhdhzehbfhdfhffhhfhjfhofhsfhohhshhwhhojhsjhwjhblhdlhflhhlhjlholhslhwlhhnhbohdphfphhpoogosgoyhooiosiowioyjookoskvohvqhvshvojvqjvsj")
r(5070, "Screw Up", layout="0ciackacmabgbbobcecbicbkcbmccqcbgdbodcceceeakeamecqecsebgfbofccgcegakgamgcqgcsgbghbohcciceiaiiakicqicsibgjbojcckcekaikakkcqkcskbglbolcembimbkmbmmcqmbgnbonciockocmoilfikhijjvbfvtfvbhvthvbjvtjCafCufCahCuhCajCuj")
#
r(5071, "Seven", layout="0aaaacaafaahaakaamaapaaraauaawaazaaBaaEaaGaaacaccafcahcakcamcapcarcaucawcazcaBcaEcaGcaaeaceafeaheakeameapeareaueaweazeaBeaEeaGeaagacgafgahgakgamgapgargaugawgazgaBgaEgaGgaaiaciafiahiakiamiapiariauiawiaziaBiaEiaGiaakackafkahkakkamkapkarkaukawkazkaBkaEkaGkaamacmafmahmakmammapmarmaumawmazmaBmaEmaGmaaoacoafoahoakoamoapoaroauoawoazoaBoaEoaGoaaqacqafqahqakqamqapqarqauqawqazqaBqaEqaGqhqchlehvehggiqghAghbihlihvihFihgkiqkhAkhlmhvmhqo")
#
r(5072, "Seven Pyramids", layout="0aaaacaaeaagaaoaaqaayaaAaaCaaEaaacaccaecagcaocaqcaycaAcaCcaEcaaeaceaeeageayeaAeaCeaEeaagacgaegaggangapgargaygaAgaCgaEganiapiariaakackaekagkankapkarkaykaAkaCkaEkaamacmaemagmaymaAmaCmaEmaaoacoaeoagoaooaqoayoaAoaCoaEoaaqacqaeqagqaoqaqqayqaAqaCqaEqhbbhdbhfbhpbhzbhBbhDbhbdhddhfdhzdhBdhDdhbfhdfhffhzfhBfhDfhohhqhhojhqjhblhdlhflhzlhBlhDlhbnhdnhfnhznhBnhDnhbphdphfphpphzphBphDpoccoecoAcoCcoceoeeoAeoCeopiocmoemoAmoCmocooeooAooCovddvBdvdnvBn")
r(5073, "Shield", layout="0aaaacaaeaagaaiaakaamaaoaaxaaacaccaecagcaicakcamcaocbxcaaeaceaeeageaieakeameaoecxeabgadgafgahgajgalgangdxgaciaeiagiaiiakiamidxietjeBjaekagkaikakkbvkexkbzkagmaimcxmahodxohcbhebhgbhibhkbhmbhcdhedhgdhidhkdhmdhcfiefigfiifikfhmfhdhifhihhijhhlhhejigjiijhkjhglhilodbofbohbojbolboddofdohdojdoldohlvfcvhcvjcvfevhevjevggvigvhiChdChf")
r(5074, "Siam", layout="0afaazaadbahbaxbaBbacdaedagdaidandardawdaydaAdaCdaleateabfadfaffahfajfavfaxfazfaBfaDfaahachaehaghaihakhamhaohaqhashauhawhayhaAhaChaEhabjadjafjahjajjavjaxjazjaBjaDjalkatkaclaelaglailanlarlawlaylaAlaCladnahnaxnaBnafoazohddhfdhhdhxdhzdhBdhcfhefhgfhifhwfhyfhAfhCfhbhhdhhfhhhhhjhhlhhnhiphhrhhthhvhhxhhzhhBhhDhhcjhejhgjhijhwjhyjhAjhCjhdlhflhhlhxlhzlhBloedogdoydoAdodfoffohfoxfozfoBfochoehoghoihowhoyhoAhoChodjofjohjoxjozjoBjoelogloyloAl")
#
#r(5075, "Space Ship", layout="0afaahaajaalaanaapaaraataavaadbaxbabcancazcaaeafeaheajealeaneapeareateaveaAeadfaxfangadhaxhaniadjaxjankadlaxlanmadnaxnanohgahiahkahmahoahqahsahuahebhwbhcchychadhmdhodhAdhgehiehkehqehsehuehmfhofhdghxghnhhdihxihnjhdkhxkhnlhdmhxmhnnohaojaolaonaopaoraotaofbovbodcoxcobdozdoheojeoleoneopeoreoteqngodhoxhqniodjoxjqnkodloxlqnmviavkavmavoavqavsavgbvubvecvwcvcdvydvievkevmevoevqevsevdivxivdkvxkCnaCjeCleCneCpeCreCdjCxj")
#
r(5076, "Square", layout="0daadcadeadgadiadkadacdccdecdgcdicdkcdaedcedeedgediedkedagdcgdegdggdigdkgdaidcideidgidiidkidakdckdekdgkdikdkk")
r(5077, "Squares", layout="0caabcaceabgaciabkacmaboacqabsacuaaacauccddafdahdajdaldandapdcrdaaeauebdfbrfaagbggcigckgcmgbogaugcdhcrhaaibgiciickicmiboiauibdjbrjaakaukcdlaflahlajlallanlaplcrlaamaumcaobcoceobgociobkocmoboocqobsocuohidikdhmdhiliklhmlvjgvlgvjivli")
r(5078, "Squaring", layout="0caaacaceaciaakacmacqaasacuacyaaAacCaaacaecaicdkcamcaqcaucaycdAcaCccaeaceceecieakecmecqeasecuecyeaAecCecahachcehcihakhcmhcqhashcuhcyhaAhcChaajdcjaejaijamjaqjdsjaujayjaCjcalaclcelcilaklcmlcqlaslculcylaAlcCl")
r(5079, "Stairs", layout="0aoaaebaybeacdccagcaicakcbmccocbqcascaucawcdAceCcaedayddaeaieaoeauedCebefbyfaagaigaogaugaCgbchcehbghakhbmhbqhashbwhcyhbAhaaiaiiaoiauiaCibejbyjdakaikaokaukdCkaelayleamdcmagmaimakmbmmcombqmasmaumawmdAmeCmaenaynaoohechychofhahkohhChhojhemhym")
r(5080, "Star Ship", layout="0eoaaabdmbdqbaCbaccckccscaAcaadbidbudaCdbceagecoeawebAeaafaefamfaqfayfaCfecgaggaigbkgdogbsgaugawgeAgaahaehamhaqhayhaChbciagicoiawibAiaajbijbujaCjackckkcskaAkaaldmldqlaCleomhachCchaehCehaghegimgiqghyghCghaihCihakhCkoadoCdoafoCfoahoChoajoCjvaevCevagvCgvaivCiCafCCfCahCCh")
#
r(5081, "Step Pyramid", layout="0aaaacaaeaagaaiaakaamaaoaaqaaacaccaecagcaicakcamcaocaqcaaeaceaoeaqeaagacgaogaqgaaiaciaoiaqiaakackaekagkaikakkamkaokaqkaamacmaemagmaimakmammaomaqmhbbhdbhfbhhbhjbhlbhnbhpbhbdhddhfdhhdhjdhldhndhpdhbfhdfhnfhpfhbhhdhhnhhphhbjhdjhfjhhjhjjhljhnjhpjhblhdlhflhhlhjlhllhnlhplpccoecogcoicokcomcpococepeepgepiepkepmeooeocgpegpmgoogocipeipgipiipkipmiooipckoekogkoikokkomkpokCffChfCjfClfCfhChhCjhClh")
r(5082, "Stonehenge", layout="0cdachackacoacracvacyacCacaccFcajeaneareavecagcFgddhdhhdlhdphdthdxhdBhcajcFjajkankarkavkcancFncdpchpckpcopcrpcvpcypcCpveavgavlavnavsavuavzavBavadvFdvafvFfvakvFkvamvFmvepvgpvlpvnpvspvupvzpvBpCehCghCihCkhCmhCohCqhCshCuhCwhCyhCAh")
r(5083, "SunMoon", layout="0dgaciabkaamabyadebbrbbBbdccbvccaddcecheckecnebDecafbtfbAfdcgdjgdlgbxgcahchhcnhdcidjidlibribDicajbvjdckchkckkcnkbAkcalbsldcmbxmdenbBndgociobkoamobuovaevagvaivakCkh")
r(5084, "Temple", layout="0baaacaaeaalaanaapaaraataaAaaCabEaaacaccalcbncbpcbrcatcaCcaEcajdavdaaeblebnebpebrebteaEeaffahfajfavfaxfazfblgbngbpgbrgbtgadhafhahhajhavhaxhazhaBhblibnibpibribtiafjahjajjavjaxjazjaakblkbnkbpkbrkbtkaEkajlavlaamacmalmbnmbpmbrmatmaCmaEmbaoacoaeoaloanoapoaroatoaAoaCobEohhghjghvghxghhihjihvihxiooeoqeokgomgoogoqgosgougokiomiooioqiosiouiookoqkvpgvpi")
#
#r(5085, "Teotihucan", layout="0aaaacaaeaagaaiaakaamaaoaaqaasaaacascaaeaseaagcggckgcogasgaaicgickicoiasiaakaskaamasmaaoacoaeoagoaioakoamoaooaqoasoajqhbbhdbhfbhhbhjbhlbhnbhpbhrbhbdhrdhbfhrfhbhhrhhbjhrjhblhrlhbnhdnhfnhhnhjnhlnhnnhpnhrnhjpoccoecogcoicokcomcoocoqcoceoqeocgoqgocioqiockoqkocmoemogmoimokmommoomoqmojovddvfdvhdvjdvldvndvpdvdfvffvhfvjfvlfvnfvpfvdhwfhvhhwjhvlhwnhvphvdjvfjvhjvjjvljvnjvpjvdlvflvhlvjlvllvnlvplvjn")
r(5086, "The Door", layout="0amaaoaaqaeicekcemceoceqcesceucagediedueaweaegaggdigdugawgaygaeibgidiiduibwiayiackaekcgkdikakkaskdukcwkaykaAkaamacmbemcgmdimakmasmdumcwmbymaAmaCmaaobcobeocgodioakoasoduocwobyobAoaCo")
#
r(5087, "The Great Wall", layout="0aaaacaaeaagaaiaakaamaaoaaqaasaauaawaayaaAaaCaaEaaacaccaecagcaicakcamcaocaqcascaucawcaycaAcaCcaEcaaeaceaeeageaieakeameaoeaqeaseaueaweayeaAeaCeaEeaagacgaegaggaigakgamgaogaqgasgaugawgaygaAgaCgaEgaaiaciaeiagiaiiakiamiaoiaqiasiauiawiayiaAiaCiaEiaakackaekagkaikakkamkaokaqkaskaukawkaykaAkaCkaEkaamacmaemagmaimakmammaomaqmasmaumawmaymaAmaCmaEmaaoacoaeoagoaioakoamoaooaqoasoauoawoayoaAoaCoaEoaaqacqaeqagqaiqakqamqaoqaqqasqauqawqayqaAqaCqaEq")
r(5088, "Theater", layout="0baaccaceabgaaiaamaaqabsacuacwabyacaccccbecagcakcbmcaocascbuccwccyccaebceaeeaiebkebmeboeaqeauebwecyebagacgaggaigakgbmgaogaqgasgawgbygcaibciaeiaiibkibmiboiaqiauibwicyicakcckbekagkakkbmkaokaskbukcwkcykbamccmcembgmaimammaqmbsmcumcwmbym")
r(5089, "Tile Fighter", layout="0bfaahaatabvadccbecakcbmcbocaqcbwcdycbaecceaiebkebmeboebqeasecyebAebagbigckgamgaogcqgbsgbAgcchaehaghauhawhcyhbaibiickiamiaoicqibsibAibakcckaikbkkbmkbokbqkaskcykbAkdcmbemakmbmmbomaqmbwmcymbfoahoatobvohnhonepafpAfpahpAhpajpAjonk")
r(5090, "Tilepiles", layout="0aaaacaaeaagaaiaaobaqbasbaubaybaAbaCbaEbahcajcalcacdaedardatdaxdazdaBdakeameaoeaffahfaufawfayfangapgargaihakhaxhazhaqiasiauiajjaljanjaAjaCjatkavkaxkaelaglailaklaolaqlawmaymaAmaCmaEmabnadnafnahnajnhbahdahfahhahpbhrbhtbhzbhBbhDbhichkchddhsdhydhAdhlehnehgfhvfhxfhoghqghjhhyhhrihtihkjhmjhBjhukhwkhflhhlhjlhplhxmhzmhBmhDmhcnhenhgnhinocaoeaogaoqbosboAboCbojcozdomeowfopgosioljovkogloiloymoAmoCmodnofnohnvdavfavrbvBbvhlvzmvBmvenvgnCeaCAmCfn")
r(5091, "Time Tunnel", layout="0aaabcaceaegaeiaekaemacoabqaasaaacccceeceoccqcascaaecceeeeeoecqeaseaagccgeegeogcqgasgaaiccieeieoicqiasiaakbckcekegkeikekkemkcokbqkaskvcdvqdwcfwqfvchvqh")
r(5092, "Tomb", layout="0eaabcabeabgabiabkabmaboabqaesabaccccceccgccicckccmccoccqcbscaaedcebeeageaieakeameboedqeasebagccgcegeggaigakgemgcogcqgbsgdaibcibeidgiaiiakidmiboibqidsibgkaikakkbmkaimakmhjevfcvhcvjcvlcvncCgcCicCkcCmc")
#
#r(5093, "Tower and Walls", layout="0ekadmaeoadqaesadkccmccoccqcdscdaeecedeeegedieekecmedoecqeesedueewedyeeAedCedkgcmgcogcqgdsgekidmieoidqiesi")
r(5094, "Traditional Reviewed", layout="0acaaeaaiaakaamaaoaaqaasaawaayaagcaicbkccmccocbqcascaucaeeagebiebkecmecoebqebseaueaweacgaegbggcigckgcmgcogcqgcsgbugawgaygaahaAhaciaeibgiciickicmicoicqicsibuiawiayiaekagkbikbkkcmkcokbqkbskaukawkagmaimbkmcmmcombqmasmaumacoaeoaioakoamoaooaqoasoawoayovnfvlhwnhvphvnj")
r(5095, "Tree of Life", layout="0ababdacfadhacjablaanaapabractadvacxabzaaBaaccaAcaadbfdajdaldandapdardatdbxdaCdaceaAeaafaefagfaifbkfbsfaufawfayfaCfacgamgaqgaAgaehaihauhayhaliboiariagjawjblkaokbrkaambcmcembgmaimclmaomcrmaumbwmcymbAmaCmacoagocloaoocroawoaAoaiqakqamqcoqaqqasqauqhoaicdimdiqdiAdhdfiffhhfixfhzfilqirq")
#
r(5096, "Twin Temples", layout="0aaaacaaeaagaaiaakaaqaasaauaawaayaaAaaacakcaqcaAcamdaodaaeakeaqeaAeagfaifamfaofasfaufaagakgaqgaAgamhaohaaiakiaqiaAiaakackaekagkaikakkaqkaskaukawkaykaAkhbbhdbhfbhhbhjbhrbhtbhvbhxbhzbhbdhjdhldhpdhrdhzdhbfhffhvfhzfhbhhjhhlhhphhrhhzhhbjhdjhfjhhjhjjhrjhtjhvjhxjhzjoccoecogcoicoscoucowcoycokdoqdoceoieoseoyeocgoigosgoygokhoqhocioeiogioiiosiouiowioyivddvfdvhdvjdvrdvtdvvdvxdvdfvhfvjfvrfvtfvxfvdhvfhvhhvjhvrhvthvvhvxhCeeCgeCueCweCegCggCugCwg")
r(5097, "Vi", layout="0aaaaEaaacaccaCcaEcbaeaceaeeaAeaCebEecagbcgaegaggaygaAgbCgcEgcaibcibeiagiaiiawiayibAibCicEicakcckbekbgkaikakkaukawkbykbAkcCkcEkdamccmcembgmbimakmammasmaumbwmbymcAmcCmdEmeaodcoceocgobiobkoamoaooaqoasobuobwocyocAodCoeEo")
r(5098, "Victory Arrow", layout="0ataaabbcbbebbgbbibbkbambavbaxcaadamdbvdazdadebfebheajeaBeaafamfaofbvfbxfbzfaDfadgajgaqgaahaghamhaohbshbuhbwhbyhbAhbChbEhadiajiaqiaajamjaojbvjbxjbzjaDjadkbfkbhkajkaBkaalamlbvlazlaxmaanbcnbenbgnbinbknamnavnatohachmchaehmehdfhjfhaghmghoghdhhjhhqhhaihmihoihdjhjjhakhmkhamhmmodbofbohbojboadomdoafomfoahonhophorhothovhoxhozhoBhoajomjoalomlodnofnohnojn")
r(5099, "Wavelets", layout="0agaaqaaAaagcaqcaAccaeaeeaieaoeaseayeaCecGeaggaqgaAgcaiaeiaiiaoiasiayiaCicGiagkaqkaAkcamaemaimaomasmaymaCmcGmagoaqoaAoagqaqqaAqhgbhqbhAbhdehjehnehtehxehDehghhqhhAhhdihjihnihtihxihDihgjhqjhAjhdmhjmhnmhtmhxmhDmhgphqphApogcoqcoAcoceokeomeoueoweoEeoggoqgoAgociokiomiouiowioEiogkoqkoAkocmokmommoumowmoEmogooqooAovgdvqdvAdvbevlevvevFevgfvqfvAfvghvqhvAhvbivlivvivFivgjvqjvAjvglvqlvAlvbmvlmvvmvFmvgnvqnvAn")
r(5100, "Well", layout="0aiaakaamaaoaagcaicakcamcaocaqcacebeeegeeieekeemeeoeeqebseaueaafawfacgbegeggaigakgamgaogeqgbsgaugaahawhacibeiegiaiiakiamiaoieqibsiauiaajawjackbekegkeikekkemkeokeqkbskaukbimakmammbomaioakoamoaoohcfhufhchhuhhcjhuj")
#r(5101, "What a Pyramid", layout="0aaaacaaeaagaaiaakaamaaoaaqaasaauaawaaacaccbecbgcbicbkcbmcbocbqcbscaucawcaceaeebgeciedkedmecoebqeaseaueaegbggdigbkgbmgdogbqgasgaeibgidiibkibmidoibqiasiackaekbgkcikdkkdmkcokbqkaskaukaamacmbembgmbimbkmbmmbombqmbsmaumawmaaoacoaeoagoaioakoamoaooaqoasoauoawo")
r(5102, "Yummy", layout="0aoaaibakbbmbbqbasbaubaocagdbidbkdbmdbqdbsdbudawdaoeaefbgfcifckfdmfdqfcsfcufbwfayfaogaahachbehcghbihakhashbuhcwhbyhaAhaChaoiaejbgjcijckjdmjdqjcsjcujbwjayjaokaglbilbklbmlbqlbslbulawlaomainaknbmnbqnasnaunaooiobiodkofkohkojiolion")
