#!/usr/bin/perl -w

#  Copyright (c) 2018
#  Whitehead Institute for Biomedical Research, Steve Rozen
#  (http://purl.com/STEVEROZEN/), and Helen Skaletsky
#  All rights reserved.
#
#        This file is part of primer3 software suite.
#
#        This software suite is is free software;
#        you can redistribute it and/or modify it under the terms
#        of the GNU General Public License as published by the Free
#        Software Foundation; either version 2 of the License, or (at
#        your option) any later version.
#
#        This software is distributed in the hope that it will be useful,
#        but WITHOUT ANY WARRANTY; without even the implied warranty of
#        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#        GNU General Public License for more details.
#
#        You should have received a copy of the GNU General Public License
#        along with this software (file gpl-2.0.txt in the source
#        distribution); if not, write to the Free Software
#        Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
#
#  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
#  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#  OWNERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON A THEORY
#  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
#  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

use strict;
use warnings;

open (FILE, ">thal_parameters.c") or print "Error opening thermodynamic_parameters.c";

print FILE qq{/*
 Copyright (c) 2018
 Whitehead Institute for Biomedical Research, Steve Rozen
 (http://purl.com/STEVEROZEN/), and Helen Skaletsky
 All rights reserved.

       This file is part of primer3 software suite.

       This software suite is is free software;
       you can redistribute it and/or modify it under the terms
       of the GNU General Public License as published by the Free
       Software Foundation; either version 2 of the License, or (at
       your option) any later version.

       This software is distributed in the hope that it will be useful,
       but WITHOUT ANY WARRANTY; without even the implied warranty of
       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
       GNU General Public License for more details.

       You should have received a copy of the GNU General Public License
       along with this software (file gpl-2.0.txt in the source
       distribution); if not, write to the Free Software
       Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 OWNERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON A THEORY
 OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "thal_parameters.h"

/* This file is created by thal_parameters_c_create.pl
   Do not edit this file, edit the script instead!
 */
static void * _thpr_safe_char_cp_malloc(const char *ct);

int set_default_thal_parameters(thal_parameters *a) \{
};

my @files;
opendir (DIR, "primer3_config") or die $!;

while (my $fil = readdir(DIR)) {
  # Use a regular expression to ignore files beginning with a period
  next if ($fil =~ m/^\./);
  next if ($fil =~ m/interpretations/);
  push(@files, $fil);
}

@files = sort(@files);

foreach (@files) {
  my $fname = $_;
  $fname =~ s/\./_/g;
  print FILE "  const char *$fname = \"";
  print "Adding $_\n";

  open (LOADFILE, "<primer3_config/$_") or print "Error opening primer3_config/$_";
  my $i = 0;
  while (<LOADFILE>) {
    my $line = $_;
    $line =~ s/\t/\\t/g;
    $line =~ s/\n/\\n/g;
    if ($line =~ /[^A-Za-z0-9\.\-\\]/) {
      print "  Unknown char: $line\n";
    }
    print FILE "$line";
    $i++;
    if (($i > 16) || (($fname =~ /loop/) && ($i > 4) )) {
      print FILE "\"\n            \"";
      $i = 0;
    }
  }
  close(LOADFILE);

  print FILE "\";\n\n";
}

print FILE qq{  thal_free_parameters(a);

  a->dangle_dh = _thpr_safe_char_cp_malloc(dangle_dh);
  a->dangle_ds = _thpr_safe_char_cp_malloc(dangle_ds);
  a->loops_dh = _thpr_safe_char_cp_malloc(loops_dh);
  a->loops_ds = _thpr_safe_char_cp_malloc(loops_ds);
  a->stack_dh = _thpr_safe_char_cp_malloc(stack_dh);
  a->stack_ds = _thpr_safe_char_cp_malloc(stack_ds);
  a->stackmm_dh = _thpr_safe_char_cp_malloc(stackmm_dh);
  a->stackmm_ds = _thpr_safe_char_cp_malloc(stackmm_ds);
  a->tetraloop_dh = _thpr_safe_char_cp_malloc(tetraloop_dh);
  a->tetraloop_ds = _thpr_safe_char_cp_malloc(tetraloop_ds);
  a->triloop_dh = _thpr_safe_char_cp_malloc(triloop_dh);
  a->triloop_ds = _thpr_safe_char_cp_malloc(triloop_ds);
  a->tstack_tm_inf_ds = _thpr_safe_char_cp_malloc(tstack_tm_inf_ds);
  a->tstack_dh = _thpr_safe_char_cp_malloc(tstack_dh);
  a->tstack2_dh = _thpr_safe_char_cp_malloc(tstack2_dh);
  a->tstack2_ds = _thpr_safe_char_cp_malloc(tstack2_ds);

  return 0;
\};

static void * _thpr_safe_char_cp_malloc(const char *ct) {
  void *r = malloc((strlen(ct) + 1) * sizeof(char));
  if (NULL == r) {
    fprintf(stderr, "out of memory in thal_parameters\\n");
    exit(-2);
  }
  strcpy(r, ct);
  return r;
}

};


close(FILE);
