===========
prads2snort
===========

-------------------------------------
Snort autotuning of Frag3 and Stream5
-------------------------------------

:Author: edwardfjellskaal@gmail.com
:Date:   2010-06-21
:Copyright: GPL
:Version: 0.2
:Manual section: 1
:Manual group: networking

.. TODO: authors and author with name <email>

SYNOPSIS
========

  prads2snort -i /var/log/prads-asset.log -o /etc/snort/host_attributes.xml -d linux -v

DESCRIPTION
===========

PRADS is a Passive Real-time Asset Detection System.

It passively listen to network traffic and gathers information
on hosts and services it sees on the network. This information
can be used to map your network, letting you know what services
and hosts are alive/used, or can be used together with your
favorite IDS/IPS setup for "event to host/service" correlation.

Gathering info about your hosts in real-time, will also let you
detect assets that are just connected to the network for a short
period of time, where a active network scan (nmap etc.) would take
long time, and not common to run continually, hence missing the asset. 

The initial goal of implementing PRADS, was to make the
host_attribute_table.xml for Snort (automatically).

PRADS2SNORT is the tool that does this!

OPTIONS
=======

-i, --infile <file>          file to feed prads2snort.pl
-o, --outfile <file>         file to write host_attribute data to (host_attribute.xml)
-d, --default <os>           set Default OS if unknown (linux,bsd,macos,windows)
-v, --verbose                prints out OS, frag, stream and confidence of asset
-h, --help                   this help message
--version                   show prads2snort.pl version

PROBLEMS
========

1. Better mapping of less used apps to their correct snort attributes
   or drop them.

SEE ALSO
========

* PRADS <http://prads.projects.linpro.no/>
* p0f <http://lcamtuf.coredump.cx/p0f.shtml>
* PADS <http://passive.sourceforge.net/>
* Snort <http://snort.org>
* Sguil <http://sguil.net>
* Hogger <http://code.google.com/p/hogger/>

BUGS
====

Report bugs here:

- http://github.com/gamelinux/prads/issues 

For general questions:

- http://projects.linpro.no/mailman/listinfo/prads-devel 
- http://projects.linpro.no/mailman/listinfo/prads-users

