/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "erreur.h"

Resultat erreur_erreur(TRAVAIL(General) general , TRAVAIL_SCALAIRE(Probleme) probleme , TRAVAIL(LocalisationFichier) localisationfichier , TRAVAIL(MessageParametres) messageparametres)
{
	/* Signale une erreur sur la sortie consacre aux erreurs.
	 * Attention ! Les paramtres de message doivent correspondre
	 *  ceux attendus, sous peine de rsultats imprvisibles.
	 * Enfin, il faut savoir que si cette fonction russit,
	 * elle termine le processus !
	 */
	STOCKAGE(MessageParametres) parametres;
	TRAVAIL_SCALAIRE(DescripteurFichier) sortie;
	TRAVAIL_SCALAIRE(DescripteurFichier) erreur;
	TRAVAIL_SCALAIRE(Message) message;
	DEBUTZONESECURISEE
	if(S_T(general)==NULL)
		return RESULTAT_ERREUR;
	if(CHAMP(general , environnement)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(environnement_lecture_erreur(CHAMP_TRAVAIL(general , environnement),R_T_(erreur)));
	SECURISE(probleme_message(probleme,R_T_(message)));
	SECURISE(messageparametres_initialisation(T_S(parametres)));
	SECURISE(messages_message(general,erreur,T_S_(MESSAGE_ERREUR),T_S(parametres)));
	SECURISE(messages_message(general,erreur,T_S_(MESSAGE_DOUBLE_POINTS),T_S(parametres)));
	SECURISE(messageparametres_destruction(T_S(parametres)));
	SECURISE(messages_message(general,erreur,message,messageparametres));
	SECURISE(probleme_localisation(general,erreur,localisationfichier));
	SECURISE(localisationfichier_destruction(localisationfichier));
	fclose(erreur);
	SECURISE(environnement_lecture_sortie(CHAMP_TRAVAIL(general , environnement),R_T_(sortie)));
	if(S_T_(sortie)!=NULL)
		fclose(sortie);
	SECURISE(messageparametres_destruction(messageparametres));
	SECURISE(general_destruction(general));
	FINZONESECURISEE
	exit(1);
	return RESULTAT_ERREUR;
}

