%define name picviz
%define version 0.3
%define release %mkrel 2
%define major   1

%define libname %mklibname %{name} %{major}

Name: %name
Version: %version
Release: %release
Summary: Parallel coordinates plotter
License: GPLv3+
Group: Graphics
URL: http://www.wallinfire.net/picviz
Source0: http://www.wallinfire.net/picviz/attachment/wiki/ReleasesDownload/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root

BuildRequires: cmake
BuildRequires: bison
BuildRequires: flex
BuildRequires: python-devel
BuildRequires: pkgconfig
BuildRequires: pcre-devel

%package -n %{libname}-devel
Summary: Picviz development files
Group: Development/C
Requires: %{libname} = %{version}
Provides: %{name}-devel = %{version}-%{release}
Provides: lib%{name}-devel = %{version}-%{release}

%package gui
Summary: Graphical frontend for picviz
Group: Graphics
Requires: %{name} = %{version}
Requires: PyQt4

%package -n %{libname}
Summary: Parallel coordinates plotter library
Group: Graphics

%description
Picviz is a parallel coordinates plotter which enables easy scripting
from various input (tcpdump, syslog, iptables logs, apache logs,
etc..) to visualize your data and discover interesting results
quickly.

Its primary goal is to graph data in order to be able to quickly
analyze problems and find correlations among variables. With security
analysis in mind, the program has been designed to be very flexible,
able to graph millions of events.

The language is designed to be close to the graphviz graph description
language.

%description -n %{libname}-devel
Development files for libpicviz.

%description gui
Graphical frontend for picviz.

%description -n %{libname}
Picviz is a parallel coordinates plotter which enables easy scripting
from various input (tcpdump, syslog, iptables logs, apache logs,
etc..) to visualize your data and discover interesting results
quickly.

Its primary goal is to graph data in order to be able to quickly
analyze problems and find correlations among variables. With security
analysis in mind, the program has been designed to be very flexible,
able to graph millions of events.

The language is designed to be close to the graphviz graph description
language.

%prep
%setup -q

%build
pushd .
%cmake -DCMAKE_SKIP_RPATH:BOOL=ON -DLIB_INSTALL_DIR=%_libdir -DMOD_INSTALL_DIR=%_libdir/%name-%major
%make
popd

pushd src/libpicviz/bindings/python
python ./setup.py build
popd

pushd src/frontend/
python ./setup.py build

%install
rm -rf %{buildroot}
%makeinstall_std

pushd src/libpicviz/bindings/python
python ./setup.py install --root=%{buildroot} --install-lib=%{python_sitearch}
popd
chmod 755 %{buildroot}/%{python_sitearch}/picviz.so

pushd src/frontend
python ./setup.py install --root=%{buildroot} --install-lib=%{python_sitearch}
popd

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%doc COPYING README samples
%{_mandir}/man1/pcv.1.*
%{python_sitearch}/picviz.so
%{python_sitearch}/Picviz*.egg-info
%{_bindir}/pcv

%files -n %{libname}-devel
%defattr(-,root,root,-)
%doc doc/{*.html,*.png,*.jpeg,images}
%{_libdir}/libpicviz.so
%{_libdir}/pkgconfig/picviz.pc
%{_includedir}/*

%files gui
%defattr(-,root,root,-)
%dir %{python_sitearch}/PicvizGui
%{python_sitearch}/PicvizGui/*
%{python_sitearch}/picviz_gui*.egg-info
%{_bindir}/picviz-gui

%files -n %libname
%defattr(-,root,root,-)
%doc COPYING
%{_libdir}/*.so.*
%dir %{_libdir}/%{name}-%major
%{_libdir}/%{name}-%major/*.so

