/*
 * Copyright (c) 2003, Artem B. Bityuckiy, SoftMine Corporation.
 * Rights transferred to Franklin Electronic Publishers.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <stdio.h>
#include <iconv.h>
#include <errno.h>
#include <newlib.h>
#include "check.h"

#if defined(_ICONV_FROM_ENCODING_UTF_8) || \
    defined(_ICONV_FROM_ENCODING_EUC_JP) || \
    defined(_ICONV_FROM_ENCODING_SHIFT_JIS) || \
    defined(_ICONV_FROM_ENCODING_UCS_2_INTERNAL)

#ifdef _ICONV_FROM_ENCODING_UTF_8
static const char utf8[] =
{
    0xe8,0x89,0xb2,0xe3,0x80,0x85,0xe3,0x83,0x86,0xe3,
    0x82,0xad,0xe3,0x82,0xb9,0xe3,0x83,0x88,0xe3,0x83,
    0x95,0xe3,0x82,0xa1,0xe3,0x82,0xa4,0xe3,0x83,0xab,
    0xe9,0x9b,0x86,0x20,0x56,0x65,0x72,0x33,0x2e,0x33,
    0x20,0x28,0x43,0x29,0x48,0x41,0x54,0x0d,0x0a,0x0d,
    0x0a,0xe3,0x81,0x93,0xe3,0x81,0xae,0xe3,0x82,0xa2,
    0xe3,0x83,0xbc,0xe3,0x82,0xab,0xe3,0x82,0xa4,0xe3,
    0x83,0x96,0xe3,0x81,0xae,0xe6,0x9c,0x80,0xe6,0x96,
    0xb0,0xe7,0x89,0x88,0xe3,0x81,0xaf,0xe3,0x81,0x93,
    0xe3,0x81,0x93,0xe3,0x81,0xab,0xe3,0x81,0x82,0xe3,
    0x82,0x8a,0xe3,0x81,0xbe,0xe3,0x81,0x99,0xe3,0x80,
    0x82,0x0d,0x0a,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,
    0x77,0x77,0x77,0x30,0x32,0x2e,0x73,0x6f,0x2d,0x6e,
    0x65,0x74,0x2e,0x6e,0x65,0x2e,0x6a,0x70,0x2f,0x25,
    0x37,0x45,0x68,0x61,0x74,0x2f,0x66,0x69,0x6c,0x65,
    0x73,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2d,0x6a,0x2e,
    0x68,0x74,0x6d,0x6c,0x0d,0x0a,0x0d,0x0a,0x63,0x72,
    0x2c,0x20,0x63,0x72,0x6c,0x66,0x2c,0x20,0x6c,0x66,
    0xe3,0x83,0x87,0xe3,0x82,0xa3,0xe3,0x83,0xac,0xe3,
    0x82,0xaf,0xe3,0x83,0x88,0xe3,0x83,0xaa,0x28,0xe3,
    0x83,0x95,0xe3,0x82,0xa9,0xe3,0x83,0xab,0xe3,0x83,
    0x80,0x29,0xe3,0x81,0xae,0xe5,0x86,0x85,0xe5,0xae,
    0xb9,0xe3,0x81,0xaf,0xe5,0x90,0x8c,0xe3,0x81,0x98,
    0xe3,0x81,0xa7,0xe3,0x81,0x99,0xe3,0x81,0x8c,0xe3,
    0x80,0x81,0xe8,0xa1,0x8c,0xe3,0x81,0xae,0xe5,0x8c,
    0xba,0xe5,0x88,0x87,0xe3,0x82,0x8a,0xe3,0x81,0x8c,
    0xe3,0x81,0x9d,0xe3,0x82,0x8c,0xe3,0x81,0x9e,0xe3,
    0x82,0x8c,0x0d,0x0a,0x43,0x52,0x28,0x4d,0x61,0x63,
    0xe9,0xa2,0xa8,0x29,0xe3,0x80,0x81,0x43,0x52,0x2b,
    0x4c,0x46,0x28,0x44,0x4f,0x53,0xe9,0xa2,0xa8,0x29,
    0xe3,0x80,0x81,0x4c,0x46,0x28,0x55,0x4e,0x49,0x58,
    0xe9,0xa2,0xa8,0x29,0xe3,0x81,0xab,0xe3,0x81,0xaa,
    0xe3,0x81,0xa3,0xe3,0x81,0xa6,0xe3,0x81,0x84,0xe3,
    0x81,0xbe,0xe3,0x81,0x99,0xe3,0x80,0x82,0x0d,0x0a,
    0x0d,0x0a,0x0d,0x0a,0x6a,0x74,0x65,0x78,0x74,0x2f,
    0x0d,0x0a,0x0d,0x0a,0x20,0x20,0x72,0x65,0x61,0x64,
    0x6d,0x65,0x2e,0x74,0x78,0x74,0x20,0x2d,0x2d,0x2d,
    0x20,0xe8,0x8b,0xb1,0xe8,0xaa,0x9e,0x52,0x45,0x41,
    0x44,0x4d,0x45,0x20,0x20,0x20,0x20,0x20,0x28,0x41,
    0x53,0x43,0x49,0x49,0x29,0x0d,0x0a,0x20,0x20,0x72,
    0x65,0x61,0x64,0x6d,0x65,0x2e,0x65,0x75,0x63,0x20,
    0x2d,0x2d,0x2d,0x20,0xe3,0x81,0x93,0xe3,0x81,0xae,
    0xe3,0x83,0x95,0xe3,0x82,0xa1,0xe3,0x82,0xa4,0xe3,
    0x83,0xab,0x20,0x20,0x20,0x28,0x45,0x55,0x43,0x2d,
    0x4a,0x50,0x29,0x0d,0x0a,0x20,0x20,0x72,0x65,0x61,
    0x64,0x6d,0x65,0x2e,0x6a,0x69,0x73,0x20,0x2d,0x2d,
    0x2d,0x20,0xe6,0x97,0xa5,0xe6,0x9c,0xac,0xe8,0xaa,
    0x9e,0x52,0x45,0x41,0x44,0x4d,0x45,0x20,0x20,0x20,
    0x28,0x4a,0x49,0x53,0x29,0x0d,0x0a,0x20,0x20,0x72,
    0x65,0x61,0x64,0x6d,0x65,0x2e,0x73,0x6a,0x73,0x20,
    0x2d,0x2d,0x2d,0x20,0xe6,0x97,0xa5,0xe6,0x9c,0xac,
    0xe8,0xaa,0x9e,0x52,0x45,0x41,0x44,0x4d,0x45,0x20,
    0x20,0x20,0x28,0x53,0x68,0x69,0x66,0x74,0x5f,0x4a,
    0x49,0x53,0x29,0x0d,0x0a,0x0d,0x0a,0x6a,0x74,0x65,
    0x78,0x74,0x2f,0x63,0x72,0x2f,0x0d,0x0a,0x6a,0x74,
    0x65,0x78,0x74,0x2f,0x63,0x72,0x6c,0x66,0x2f,0x0d,
    0x0a,0x6a,0x74,0x65,0x78,0x74,0x2f,0x6c,0x66,0x2f,
    0x0d,0x0a,0x0d,0x0a,0x20,0x20,0x61,0x73,0x63,0x69,
    0x69,0x2e,0x74,0x78,0x74,0x20,0x2d,0x2d,0x2d,0x2d,
    0x20,0x41,0x53,0x43,0x49,0x49,0xe3,0x81,0xa7,0xe6,
    0x9b,0xb8,0xe3,0x81,0x84,0xe3,0x81,0x9f,0xe6,0x97,
    0xa5,0xe6,0x9c,0xac,0xe8,0xaa,0x9e,0x28,0xe3,0x83,
    0xad,0xe3,0x83,0xbc,0xe3,0x83,0x9e,0xe5,0xad,0x97,
    0x29,0x0d,0x0a,0x0d,0x0a,0x20,0x20,0x6a,0x30,0x32,
    0x30,0x31,0x2d,0x38,0x62,0x2e,0x74,0x78,0x74,0x20,
    0x2d,0x20,0x4a,0x49,0x53,0x20,0x58,0x30,0x32,0x30,
    0x31,0xe3,0x81,0xae,0xe7,0x89,0x87,0xe4,0xbb,0xae,
    0xe5,0x90,0x8d,0x20,0xe3,0x82,0x92,0x20,0x38,0xe5,
    0x8d,0x98,0xe4,0xbd,0x8d,0xe7,0xac,0xa6,0xe5,0x8f,
    0xb7,0xe5,0x8c,0x96,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x53,0x68,0x69,0x66,0x74,0x5f,0x4a,0x49,0x53,
    0xe3,0x81,0xa8,0xe5,0x90,0x8c,0xe3,0x81,0x98,0x0d,
    0x0a,0x20,0x20,0x6a,0x30,0x32,0x30,0x31,0x2d,0x65,
    0x73,0x2e,0x74,0x78,0x74,0x20,0x2d,0x20,0x4a,0x49,
    0x53,0x20,0x58,0x30,0x32,0x30,0x31,0xe3,0x81,0xae,
    0xe7,0x89,0x87,0xe4,0xbb,0xae,0xe5,0x90,0x8d,0x20,
    0xe3,0x82,0x92,0x20,0x45,0x53,0x43,0x28,0x49,0xe3,
    0x81,0xa7,0xe7,0xac,0xa6,0xe5,0x8f,0xb7,0xe5,0x8c,
    0x96,0x0d,0x0a,0x20,0x20,0x6a,0x30,0x32,0x30,0x31,
    0x2d,0x73,0x6f,0x2e,0x74,0x78,0x74,0x20,0x2d,0x20,
    0x4a,0x49,0x53,0x20,0x58,0x30,0x32,0x30,0x31,0xe3,
    0x81,0xae,0xe7,0x89,0x87,0xe4,0xbb,0xae,0xe5,0x90,
    0x8d,0x20,0xe3,0x82,0x92,0x20,0x53,0x4f,0x2f,0x53,
    0x49,0xe3,0x81,0xa7,0xe7,0xac,0xa6,0xe5,0x8f,0xb7,
    0xe5,0x8c,0x96,0x0d,0x0a,0x0d,0x0a,0x20,0x20,0x6a,
    0x30,0x32,0x30,0x38,0x2d,0x38,0x62,0x2e,0x74,0x78,
    0x74,0x20,0x2d,0x20,0x4a,0x49,0x53,0x20,0x58,0x30,
    0x32,0x30,0x38,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0xe3,0x82,0x92,0x20,0x38,0xe5,0x8d,0x98,
    0xe4,0xbd,0x8d,0xe7,0xac,0xa6,0xe5,0x8f,0xb7,0xe5,
    0x8c,0x96,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x45,
    0x55,0x43,0x2d,0x4a,0x50,0xe3,0x81,0xa8,0xe5,0x90,
    0x8c,0xe3,0x81,0x98,0x0d,0x0a,0x20,0x20,0x6a,0x30,
    0x32,0x30,0x38,0x2d,0x37,0x38,0x2e,0x74,0x78,0x74,
    0x20,0x2d,0x20,0x4a,0x49,0x53,0x20,0x58,0x30,0x32,
    0x30,0x38,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0xe3,0x82,0x92,0x20,0x45,0x53,0x43,0x24,0x40,
    0xe3,0x81,0xa7,0xe7,0xac,0xa6,0xe5,0x8f,0xb7,0xe5,
    0x8c,0x96,0x20,0x20,0x20,0x20,0x20,0xe3,0x81,0x84,
    0xe3,0x82,0x8f,0xe3,0x82,0x86,0xe3,0x82,0x8b,0xe6,
    0x97,0xa7,0x4a,0x49,0x53,0x0d,0x0a,0x20,0x20,0x6a,
    0x30,0x32,0x30,0x38,0x2d,0x38,0x33,0x2e,0x74,0x78,
    0x74,0x20,0x2d,0x20,0x4a,0x49,0x53,0x20,0x58,0x30,
    0x32,0x30,0x38,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0xe3,0x82,0x92,0x20,0x45,0x53,0x43,0x24,
    0x42,0xe3,0x81,0xa7,0xe7,0xac,0xa6,0xe5,0x8f,0xb7,
    0xe5,0x8c,0x96,0x20,0x20,0x20,0x20,0x20,0xe3,0x81,
    0x84,0xe3,0x82,0x8f,0xe3,0x82,0x86,0xe3,0x82,0x8b,
    0xe6,0x96,0xb0,0x4a,0x49,0x53,0x0d,0x0a,0x0d,0x0a,
    0x20,0x20,0x65,0x30,0x32,0x30,0x31,0x2e,0x74,0x78,
    0x74,0x20,0x2d,0x2d,0x2d,0x2d,0x20,0x4a,0x49,0x53,
    0x20,0x58,0x30,0x32,0x30,0x31,0xe3,0x81,0xae,0xe7,
    0x89,0x87,0xe4,0xbb,0xae,0xe5,0x90,0x8d,0x20,0xe3,
    0x82,0x92,0x20,0x45,0x55,0x43,0x2d,0x4a,0x50,0xe3,
    0x81,0xa7,0xe7,0xac,0xa6,0xe5,0x8f,0xb7,0xe5,0x8c,
    0x96,0x0d,0x0a,0x20,0x20,0x65,0x30,0x32,0x30,0x38,
    0x2e,0x74,0x78,0x74,0x20,0x2d,0x2d,0x2d,0x2d,0x20,
    0x4a,0x49,0x53,0x20,0x58,0x30,0x32,0x30,0x38,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0xe3,0x82,
    0x92,0x20,0x45,0x55,0x43,0x2d,0x4a,0x50,0xe3,0x81,
    0xa7,0xe7,0xac,0xa6,0xe5,0x8f,0xb7,0xe5,0x8c,0x96,
    0x20,0x20,0x20,0x20,0x38,0xe3,0x83,0x93,0xe3,0x83,
    0x83,0xe3,0x83,0x88,0x4a,0x49,0x53,0x58,0x30,0x32,
    0x30,0x38,0xe3,0x81,0xa8,0xe5,0x90,0x8c,0xe3,0x81,
    0x98,0x0d,0x0a,0x0d,0x0a,0x20,0x20,0x73,0x30,0x32,
    0x30,0x31,0x2e,0x74,0x78,0x74,0x20,0x2d,0x2d,0x2d,
    0x2d,0x20,0x4a,0x49,0x53,0x20,0x58,0x30,0x32,0x30,
    0x31,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0xe3,0x82,0x92,0x20,0x53,0x68,0x69,0x66,0x74,0x5f,
    0x4a,0x49,0x53,0xe3,0x81,0xa7,0xe7,0xac,0xa6,0xe5,
    0x8f,0xb7,0xe5,0x8c,0x96,0x20,0x38,0xe3,0x83,0x93,
    0xe3,0x83,0x83,0xe3,0x83,0x88,0x4a,0x49,0x53,0x58,
    0x30,0x32,0x30,0x31,0xe3,0x81,0xa8,0xe5,0x90,0x8c,
    0xe3,0x81,0x98,0x0d,0x0a,0x20,0x20,0x73,0x30,0x32,
    0x30,0x38,0x2e,0x74,0x78,0x74,0x20,0x2d,0x2d,0x2d,
    0x2d,0x20,0x4a,0x49,0x53,0x20,0x58,0x30,0x32,0x30,
    0x38,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0xe3,0x82,0x92,0x20,0x53,0x68,0x69,0x66,0x74,0x5f,
    0x4a,0x49,0x53,0xe3,0x81,0xa7,0xe7,0xac,0xa6,0xe5,
    0x8f,0xb7,0xe5,0x8c,0x96,0x0d,0x0a,0x0d,0x0a,0x6a,
    0x74,0x65,0x78,0x74,0x2f,0x6f,0x74,0x68,0x65,0x72,
    0x73,0x2f,0x0d,0x0a,0x0d,0x0a,0x20,0x20,0x62,0x36,
    0x34,0x6a,0x69,0x73,0x2e,0x74,0x78,0x74,0x20,0x2d,
    0x2d,0x2d,0x20,0x49,0x53,0x4f,0x2d,0x32,0x30,0x32,
    0x32,0x2d,0x4a,0x50,0x20,0x28,0x4a,0x49,0x53,0x29,
    0x20,0xe3,0x82,0x92,0x20,0x62,0x61,0x73,0x65,0x36,
    0x34,0xe3,0x81,0xa7,0xe7,0xac,0xa6,0xe5,0x8f,0xb7,
    0xe5,0x8c,0x96,0x0d,0x0a,0x20,0x20,0x71,0x74,0x6a,
    0x69,0x73,0x2e,0x74,0x78,0x74,0x20,0x2d,0x2d,0x2d,
    0x2d,0x20,0x49,0x53,0x4f,0x2d,0x32,0x30,0x32,0x32,
    0x2d,0x4a,0x50,0x20,0x28,0x4a,0x49,0x53,0x29,0x20,
    0xe3,0x82,0x92,0x20,0x71,0x75,0x6f,0x74,0x65,0x64,
    0x2d,0x70,0x72,0x69,0x6e,0x74,0x61,0x62,0x6c,0x65,
    0xe3,0x81,0xa7,0xe7,0xac,0xa6,0xe5,0x8f,0xb7,0xe5,
    0x8c,0x96,0x0d,0x0a,0x0d,0x0a,0x20,0x20,0x62,0x6b,
    0x65,0x75,0x63,0x2e,0x74,0x78,0x74,0x20,0x2d,0x2d,
    0x2d,0x2d,0x20,0xe5,0xa3,0x8a,0xe3,0x82,0x8c,0xe3,
    0x81,0x9f,0x45,0x55,0x43,0x2d,0x4a,0x50,0x20,0x20,
    0x20,0x20,0x20,0x20,0xe5,0x85,0x88,0xe9,0xa0,0xad,
    0xe3,0x83,0x93,0xe3,0x83,0x83,0xe3,0x83,0x88,0xe3,
    0x81,0x8c,0xe3,0x82,0xbc,0xe3,0x83,0xad,0x0d,0x0a,
    0x20,0x20,0x62,0x6b,0x6a,0x69,0x73,0x2e,0x74,0x78,
    0x74,0x20,0x2d,0x2d,0x2d,0x2d,0x20,0xe5,0xa3,0x8a,
    0xe3,0x82,0x8c,0xe3,0x81,0x9f,0x4a,0x49,0x53,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x45,0x53,
    0x43,0xe3,0x82,0xb3,0xe3,0x83,0xbc,0xe3,0x83,0x89,
    0xe3,0x81,0x8c,0xe6,0xac,0xa0,0xe3,0x81,0x91,0xe3,
    0x81,0x9f,0x0d,0x0a,0x20,0x20,0x62,0x6b,0x73,0x6a,
    0x69,0x73,0x2e,0x74,0x78,0x74,0x2d,0x2d,0x2d,0x2d,
    0x20,0xe5,0xa3,0x8a,0xe3,0x82,0x8c,0xe3,0x81,0x9f,
    0x53,0x68,0x69,0x66,0x74,0x5f,0x4a,0x49,0x53,0x20,
    0x20,0x20,0xe5,0x85,0x88,0xe9,0xa0,0xad,0xe3,0x83,
    0x93,0xe3,0x83,0x83,0xe3,0x83,0x88,0xe3,0x81,0x8c,
    0xe3,0x82,0xbc,0xe3,0x83,0xad,0x0d,0x0a,0x0d,0x0a,
    0x20,0x20,0x63,0x74,0x72,0x6c,0x5f,0x7a,0x2e,0x74,
    0x78,0x74,0x20,0x20,0x20,0x20,0x20,0x53,0x68,0x69,
    0x66,0x74,0x5f,0x4a,0x49,0x53,0x20,0x20,0x20,0x20,
    0x20,0x20,0x5e,0x5a,0xe3,0x82,0xad,0xe3,0x83,0xa3,
    0xe3,0x83,0xa9,0xe3,0x82,0xaf,0xe3,0x82,0xbf,0xe4,
    0xbb,0x98,0xe3,0x81,0x8d,0x20,0x20,0x20,0x28,0x44,
    0x4f,0x53,0xe9,0xa2,0xa8,0x29,0x0d,0x0a,0x20,0x20,
    0x6d,0x61,0x63,0x74,0x78,0x74,0x2e,0x62,0x69,0x6e,
    0x20,0x20,0x20,0x20,0x20,0xe3,0x83,0x9e,0xe3,0x83,
    0x83,0xe3,0x82,0xaf,0xe3,0x83,0x90,0xe3,0x82,0xa4,
    0xe3,0x83,0x8a,0xe3,0x83,0xaa,0x49,0x49,0xe3,0x83,
    0x95,0xe3,0x82,0xa9,0xe3,0x83,0xbc,0xe3,0x83,0x9e,
    0xe3,0x83,0x83,0xe3,0x83,0x88,0x0d,0xa
 };
#endif /* ifdef _ICONV_FROM_ENCODING_UTF_8 */

#ifdef _ICONV_FROM_ENCODING_EUC_JP
 static const char euc_jp[] =
 {
    0xbf,0xa7,0xa1,0xb9,0xa5,0xc6,0xa5,0xad,0xa5,0xb9,
    0xa5,0xc8,0xa5,0xd5,0xa5,0xa1,0xa5,0xa4,0xa5,0xeb,
    0xbd,0xb8,0x20,0x56,0x65,0x72,0x33,0x2e,0x33,0x20,
    0x28,0x43,0x29,0x48,0x41,0x54,0x0d,0x0a,0x0d,0x0a,
    0xa4,0xb3,0xa4,0xce,0xa5,0xa2,0xa1,0xbc,0xa5,0xab,
    0xa5,0xa4,0xa5,0xd6,0xa4,0xce,0xba,0xc7,0xbf,0xb7,
    0xc8,0xc7,0xa4,0xcf,0xa4,0xb3,0xa4,0xb3,0xa4,0xcb,
    0xa4,0xa2,0xa4,0xea,0xa4,0xde,0xa4,0xb9,0xa1,0xa3,
    0x0d,0x0a,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,
    0x77,0x77,0x30,0x32,0x2e,0x73,0x6f,0x2d,0x6e,0x65,
    0x74,0x2e,0x6e,0x65,0x2e,0x6a,0x70,0x2f,0x25,0x37,
    0x45,0x68,0x61,0x74,0x2f,0x66,0x69,0x6c,0x65,0x73,
    0x2f,0x69,0x6e,0x64,0x65,0x78,0x2d,0x6a,0x2e,0x68,
    0x74,0x6d,0x6c,0x0d,0x0a,0x0d,0x0a,0x63,0x72,0x2c,
    0x20,0x63,0x72,0x6c,0x66,0x2c,0x20,0x6c,0x66,0xa5,
    0xc7,0xa5,0xa3,0xa5,0xec,0xa5,0xaf,0xa5,0xc8,0xa5,
    0xea,0x28,0xa5,0xd5,0xa5,0xa9,0xa5,0xeb,0xa5,0xc0,
    0x29,0xa4,0xce,0xc6,0xe2,0xcd,0xc6,0xa4,0xcf,0xc6,
    0xb1,0xa4,0xb8,0xa4,0xc7,0xa4,0xb9,0xa4,0xac,0xa1,
    0xa2,0xb9,0xd4,0xa4,0xce,0xb6,0xe8,0xc0,0xda,0xa4,
    0xea,0xa4,0xac,0xa4,0xbd,0xa4,0xec,0xa4,0xbe,0xa4,
    0xec,0x0d,0x0a,0x43,0x52,0x28,0x4d,0x61,0x63,0xc9,
    0xf7,0x29,0xa1,0xa2,0x43,0x52,0x2b,0x4c,0x46,0x28,
    0x44,0x4f,0x53,0xc9,0xf7,0x29,0xa1,0xa2,0x4c,0x46,
    0x28,0x55,0x4e,0x49,0x58,0xc9,0xf7,0x29,0xa4,0xcb,
    0xa4,0xca,0xa4,0xc3,0xa4,0xc6,0xa4,0xa4,0xa4,0xde,
    0xa4,0xb9,0xa1,0xa3,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,
    0x6a,0x74,0x65,0x78,0x74,0x2f,0x0d,0x0a,0x0d,0x0a,
    0x20,0x20,0x72,0x65,0x61,0x64,0x6d,0x65,0x2e,0x74,
    0x78,0x74,0x20,0x2d,0x2d,0x2d,0x20,0xb1,0xd1,0xb8,
    0xec,0x52,0x45,0x41,0x44,0x4d,0x45,0x20,0x20,0x20,
    0x20,0x20,0x28,0x41,0x53,0x43,0x49,0x49,0x29,0x0d,
    0x0a,0x20,0x20,0x72,0x65,0x61,0x64,0x6d,0x65,0x2e,
    0x65,0x75,0x63,0x20,0x2d,0x2d,0x2d,0x20,0xa4,0xb3,
    0xa4,0xce,0xa5,0xd5,0xa5,0xa1,0xa5,0xa4,0xa5,0xeb,
    0x20,0x20,0x20,0x28,0x45,0x55,0x43,0x2d,0x4a,0x50,
    0x29,0x0d,0x0a,0x20,0x20,0x72,0x65,0x61,0x64,0x6d,
    0x65,0x2e,0x6a,0x69,0x73,0x20,0x2d,0x2d,0x2d,0x20,
    0xc6,0xfc,0xcb,0xdc,0xb8,0xec,0x52,0x45,0x41,0x44,
    0x4d,0x45,0x20,0x20,0x20,0x28,0x4a,0x49,0x53,0x29,
    0x0d,0x0a,0x20,0x20,0x72,0x65,0x61,0x64,0x6d,0x65,
    0x2e,0x73,0x6a,0x73,0x20,0x2d,0x2d,0x2d,0x20,0xc6,
    0xfc,0xcb,0xdc,0xb8,0xec,0x52,0x45,0x41,0x44,0x4d,
    0x45,0x20,0x20,0x20,0x28,0x53,0x68,0x69,0x66,0x74,
    0x5f,0x4a,0x49,0x53,0x29,0x0d,0x0a,0x0d,0x0a,0x6a,
    0x74,0x65,0x78,0x74,0x2f,0x63,0x72,0x2f,0x0d,0x0a,
    0x6a,0x74,0x65,0x78,0x74,0x2f,0x63,0x72,0x6c,0x66,
    0x2f,0x0d,0x0a,0x6a,0x74,0x65,0x78,0x74,0x2f,0x6c,
    0x66,0x2f,0x0d,0x0a,0x0d,0x0a,0x20,0x20,0x61,0x73,
    0x63,0x69,0x69,0x2e,0x74,0x78,0x74,0x20,0x2d,0x2d,
    0x2d,0x2d,0x20,0x41,0x53,0x43,0x49,0x49,0xa4,0xc7,
    0xbd,0xf1,0xa4,0xa4,0xa4,0xbf,0xc6,0xfc,0xcb,0xdc,
    0xb8,0xec,0x28,0xa5,0xed,0xa1,0xbc,0xa5,0xde,0xbb,
    0xfa,0x29,0x0d,0x0a,0x0d,0x0a,0x20,0x20,0x6a,0x30,
    0x32,0x30,0x31,0x2d,0x38,0x62,0x2e,0x74,0x78,0x74,
    0x20,0x2d,0x20,0x4a,0x49,0x53,0x20,0x58,0x30,0x32,
    0x30,0x31,0xa4,0xce,0xca,0xd2,0xb2,0xbe,0xcc,0xbe,
    0x20,0xa4,0xf2,0x20,0x38,0xc3,0xb1,0xb0,0xcc,0xc9,
    0xe4,0xb9,0xe6,0xb2,0xbd,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x53,0x68,0x69,0x66,0x74,0x5f,0x4a,0x49,
    0x53,0xa4,0xc8,0xc6,0xb1,0xa4,0xb8,0x0d,0x0a,0x20,
    0x20,0x6a,0x30,0x32,0x30,0x31,0x2d,0x65,0x73,0x2e,
    0x74,0x78,0x74,0x20,0x2d,0x20,0x4a,0x49,0x53,0x20,
    0x58,0x30,0x32,0x30,0x31,0xa4,0xce,0xca,0xd2,0xb2,
    0xbe,0xcc,0xbe,0x20,0xa4,0xf2,0x20,0x45,0x53,0x43,
    0x28,0x49,0xa4,0xc7,0xc9,0xe4,0xb9,0xe6,0xb2,0xbd,
    0x0d,0x0a,0x20,0x20,0x6a,0x30,0x32,0x30,0x31,0x2d,
    0x73,0x6f,0x2e,0x74,0x78,0x74,0x20,0x2d,0x20,0x4a,
    0x49,0x53,0x20,0x58,0x30,0x32,0x30,0x31,0xa4,0xce,
    0xca,0xd2,0xb2,0xbe,0xcc,0xbe,0x20,0xa4,0xf2,0x20,
    0x53,0x4f,0x2f,0x53,0x49,0xa4,0xc7,0xc9,0xe4,0xb9,
    0xe6,0xb2,0xbd,0x0d,0x0a,0x0d,0x0a,0x20,0x20,0x6a,
    0x30,0x32,0x30,0x38,0x2d,0x38,0x62,0x2e,0x74,0x78,
    0x74,0x20,0x2d,0x20,0x4a,0x49,0x53,0x20,0x58,0x30,
    0x32,0x30,0x38,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0xa4,0xf2,0x20,0x38,0xc3,0xb1,0xb0,0xcc,
    0xc9,0xe4,0xb9,0xe6,0xb2,0xbd,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x45,0x55,0x43,0x2d,0x4a,0x50,0xa4,
    0xc8,0xc6,0xb1,0xa4,0xb8,0x0d,0x0a,0x20,0x20,0x6a,
    0x30,0x32,0x30,0x38,0x2d,0x37,0x38,0x2e,0x74,0x78,
    0x74,0x20,0x2d,0x20,0x4a,0x49,0x53,0x20,0x58,0x30,
    0x32,0x30,0x38,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0xa4,0xf2,0x20,0x45,0x53,0x43,0x24,0x40,
    0xa4,0xc7,0xc9,0xe4,0xb9,0xe6,0xb2,0xbd,0x20,0x20,
    0x20,0x20,0x20,0xa4,0xa4,0xa4,0xef,0xa4,0xe6,0xa4,
    0xeb,0xb5,0xec,0x4a,0x49,0x53,0x0d,0x0a,0x20,0x20,
    0x6a,0x30,0x32,0x30,0x38,0x2d,0x38,0x33,0x2e,0x74,
    0x78,0x74,0x20,0x2d,0x20,0x4a,0x49,0x53,0x20,0x58,
    0x30,0x32,0x30,0x38,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0xa4,0xf2,0x20,0x45,0x53,0x43,0x24,
    0x42,0xa4,0xc7,0xc9,0xe4,0xb9,0xe6,0xb2,0xbd,0x20,
    0x20,0x20,0x20,0x20,0xa4,0xa4,0xa4,0xef,0xa4,0xe6,
    0xa4,0xeb,0xbf,0xb7,0x4a,0x49,0x53,0x0d,0x0a,0x0d,
    0x0a,0x20,0x20,0x65,0x30,0x32,0x30,0x31,0x2e,0x74,
    0x78,0x74,0x20,0x2d,0x2d,0x2d,0x2d,0x20,0x4a,0x49,
    0x53,0x20,0x58,0x30,0x32,0x30,0x31,0xa4,0xce,0xca,
    0xd2,0xb2,0xbe,0xcc,0xbe,0x20,0xa4,0xf2,0x20,0x45,
    0x55,0x43,0x2d,0x4a,0x50,0xa4,0xc7,0xc9,0xe4,0xb9,
    0xe6,0xb2,0xbd,0x0d,0x0a,0x20,0x20,0x65,0x30,0x32,
    0x30,0x38,0x2e,0x74,0x78,0x74,0x20,0x2d,0x2d,0x2d,
    0x2d,0x20,0x4a,0x49,0x53,0x20,0x58,0x30,0x32,0x30,
    0x38,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0xa4,0xf2,0x20,0x45,0x55,0x43,0x2d,0x4a,0x50,0xa4,
    0xc7,0xc9,0xe4,0xb9,0xe6,0xb2,0xbd,0x20,0x20,0x20,
    0x20,0x38,0xa5,0xd3,0xa5,0xc3,0xa5,0xc8,0x4a,0x49,
    0x53,0x58,0x30,0x32,0x30,0x38,0xa4,0xc8,0xc6,0xb1,
    0xa4,0xb8,0x0d,0x0a,0x0d,0x0a,0x20,0x20,0x73,0x30,
    0x32,0x30,0x31,0x2e,0x74,0x78,0x74,0x20,0x2d,0x2d,
    0x2d,0x2d,0x20,0x4a,0x49,0x53,0x20,0x58,0x30,0x32,
    0x30,0x31,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0xa4,0xf2,0x20,0x53,0x68,0x69,0x66,0x74,0x5f,
    0x4a,0x49,0x53,0xa4,0xc7,0xc9,0xe4,0xb9,0xe6,0xb2,
    0xbd,0x20,0x38,0xa5,0xd3,0xa5,0xc3,0xa5,0xc8,0x4a,
    0x49,0x53,0x58,0x30,0x32,0x30,0x31,0xa4,0xc8,0xc6,
    0xb1,0xa4,0xb8,0x0d,0x0a,0x20,0x20,0x73,0x30,0x32,
    0x30,0x38,0x2e,0x74,0x78,0x74,0x20,0x2d,0x2d,0x2d,
    0x2d,0x20,0x4a,0x49,0x53,0x20,0x58,0x30,0x32,0x30,
    0x38,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0xa4,0xf2,0x20,0x53,0x68,0x69,0x66,0x74,0x5f,0x4a,
    0x49,0x53,0xa4,0xc7,0xc9,0xe4,0xb9,0xe6,0xb2,0xbd,
    0x0d,0x0a,0x0d,0x0a,0x6a,0x74,0x65,0x78,0x74,0x2f,
    0x6f,0x74,0x68,0x65,0x72,0x73,0x2f,0x0d,0x0a,0x0d,
    0x0a,0x20,0x20,0x62,0x36,0x34,0x6a,0x69,0x73,0x2e,
    0x74,0x78,0x74,0x20,0x2d,0x2d,0x2d,0x20,0x49,0x53,
    0x4f,0x2d,0x32,0x30,0x32,0x32,0x2d,0x4a,0x50,0x20,
    0x28,0x4a,0x49,0x53,0x29,0x20,0xa4,0xf2,0x20,0x62,
    0x61,0x73,0x65,0x36,0x34,0xa4,0xc7,0xc9,0xe4,0xb9,
    0xe6,0xb2,0xbd,0x0d,0x0a,0x20,0x20,0x71,0x74,0x6a,
    0x69,0x73,0x2e,0x74,0x78,0x74,0x20,0x2d,0x2d,0x2d,
    0x2d,0x20,0x49,0x53,0x4f,0x2d,0x32,0x30,0x32,0x32,
    0x2d,0x4a,0x50,0x20,0x28,0x4a,0x49,0x53,0x29,0x20,
    0xa4,0xf2,0x20,0x71,0x75,0x6f,0x74,0x65,0x64,0x2d,
    0x70,0x72,0x69,0x6e,0x74,0x61,0x62,0x6c,0x65,0xa4,
    0xc7,0xc9,0xe4,0xb9,0xe6,0xb2,0xbd,0x0d,0x0a,0x0d,
    0x0a,0x20,0x20,0x62,0x6b,0x65,0x75,0x63,0x2e,0x74,
    0x78,0x74,0x20,0x2d,0x2d,0x2d,0x2d,0x20,0xb2,0xf5,
    0xa4,0xec,0xa4,0xbf,0x45,0x55,0x43,0x2d,0x4a,0x50,
    0x20,0x20,0x20,0x20,0x20,0x20,0xc0,0xe8,0xc6,0xac,
    0xa5,0xd3,0xa5,0xc3,0xa5,0xc8,0xa4,0xac,0xa5,0xbc,
    0xa5,0xed,0x0d,0x0a,0x20,0x20,0x62,0x6b,0x6a,0x69,
    0x73,0x2e,0x74,0x78,0x74,0x20,0x2d,0x2d,0x2d,0x2d,
    0x20,0xb2,0xf5,0xa4,0xec,0xa4,0xbf,0x4a,0x49,0x53,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x45,
    0x53,0x43,0xa5,0xb3,0xa1,0xbc,0xa5,0xc9,0xa4,0xac,
    0xb7,0xe7,0xa4,0xb1,0xa4,0xbf,0x0d,0x0a,0x20,0x20,
    0x62,0x6b,0x73,0x6a,0x69,0x73,0x2e,0x74,0x78,0x74,
    0x2d,0x2d,0x2d,0x2d,0x20,0xb2,0xf5,0xa4,0xec,0xa4,
    0xbf,0x53,0x68,0x69,0x66,0x74,0x5f,0x4a,0x49,0x53,
    0x20,0x20,0x20,0xc0,0xe8,0xc6,0xac,0xa5,0xd3,0xa5,
    0xc3,0xa5,0xc8,0xa4,0xac,0xa5,0xbc,0xa5,0xed,0x0d,
    0x0a,0x0d,0x0a,0x20,0x20,0x63,0x74,0x72,0x6c,0x5f,
    0x7a,0x2e,0x74,0x78,0x74,0x20,0x20,0x20,0x20,0x20,
    0x53,0x68,0x69,0x66,0x74,0x5f,0x4a,0x49,0x53,0x20,
    0x20,0x20,0x20,0x20,0x20,0x5e,0x5a,0xa5,0xad,0xa5,
    0xe3,0xa5,0xe9,0xa5,0xaf,0xa5,0xbf,0xc9,0xd5,0xa4,
    0xad,0x20,0x20,0x20,0x28,0x44,0x4f,0x53,0xc9,0xf7,
    0x29,0x0d,0x0a,0x20,0x20,0x6d,0x61,0x63,0x74,0x78,
    0x74,0x2e,0x62,0x69,0x6e,0x20,0x20,0x20,0x20,0x20,
    0xa5,0xde,0xa5,0xc3,0xa5,0xaf,0xa5,0xd0,0xa5,0xa4,
    0xa5,0xca,0xa5,0xea,0x49,0x49,0xa5,0xd5,0xa5,0xa9,
    0xa1,0xbc,0xa5,0xde,0xa5,0xc3,0xa5,0xc8,0x0d,0x0a
};
#endif /* #ifdef _ICONV_FROM_ENCODING_EUC_JP */

#ifdef _ICONV_FROM_ENCODING_SHIFT_JIS
static const char shift_jis[] =
{
    0x90,0x46,0x81,0x58,0x83,0x65,0x83,0x4c,0x83,0x58,
    0x83,0x67,0x83,0x74,0x83,0x40,0x83,0x43,0x83,0x8b,
    0x8f,0x57,0x20,0x56,0x65,0x72,0x33,0x2e,0x33,0x20,
    0x28,0x43,0x29,0x48,0x41,0x54,0x0d,0x0a,0x0d,0x0a,
    0x82,0xb1,0x82,0xcc,0x83,0x41,0x81,0x5b,0x83,0x4a,
    0x83,0x43,0x83,0x75,0x82,0xcc,0x8d,0xc5,0x90,0x56,
    0x94,0xc5,0x82,0xcd,0x82,0xb1,0x82,0xb1,0x82,0xc9,
    0x82,0xa0,0x82,0xe8,0x82,0xdc,0x82,0xb7,0x81,0x42,
    0x0d,0x0a,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,
    0x77,0x77,0x30,0x32,0x2e,0x73,0x6f,0x2d,0x6e,0x65,
    0x74,0x2e,0x6e,0x65,0x2e,0x6a,0x70,0x2f,0x25,0x37,
    0x45,0x68,0x61,0x74,0x2f,0x66,0x69,0x6c,0x65,0x73,
    0x2f,0x69,0x6e,0x64,0x65,0x78,0x2d,0x6a,0x2e,0x68,
    0x74,0x6d,0x6c,0x0d,0x0a,0x0d,0x0a,0x63,0x72,0x2c,
    0x20,0x63,0x72,0x6c,0x66,0x2c,0x20,0x6c,0x66,0x83,
    0x66,0x83,0x42,0x83,0x8c,0x83,0x4e,0x83,0x67,0x83,
    0x8a,0x28,0x83,0x74,0x83,0x48,0x83,0x8b,0x83,0x5f,
    0x29,0x82,0xcc,0x93,0xe0,0x97,0x65,0x82,0xcd,0x93,
    0xaf,0x82,0xb6,0x82,0xc5,0x82,0xb7,0x82,0xaa,0x81,
    0x41,0x8d,0x73,0x82,0xcc,0x8b,0xe6,0x90,0xd8,0x82,
    0xe8,0x82,0xaa,0x82,0xbb,0x82,0xea,0x82,0xbc,0x82,
    0xea,0x0d,0x0a,0x43,0x52,0x28,0x4d,0x61,0x63,0x95,
    0x97,0x29,0x81,0x41,0x43,0x52,0x2b,0x4c,0x46,0x28,
    0x44,0x4f,0x53,0x95,0x97,0x29,0x81,0x41,0x4c,0x46,
    0x28,0x55,0x4e,0x49,0x58,0x95,0x97,0x29,0x82,0xc9,
    0x82,0xc8,0x82,0xc1,0x82,0xc4,0x82,0xa2,0x82,0xdc,
    0x82,0xb7,0x81,0x42,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,
    0x6a,0x74,0x65,0x78,0x74,0x2f,0x0d,0x0a,0x0d,0x0a,
    0x20,0x20,0x72,0x65,0x61,0x64,0x6d,0x65,0x2e,0x74,
    0x78,0x74,0x20,0x2d,0x2d,0x2d,0x20,0x89,0x70,0x8c,
    0xea,0x52,0x45,0x41,0x44,0x4d,0x45,0x20,0x20,0x20,
    0x20,0x20,0x28,0x41,0x53,0x43,0x49,0x49,0x29,0x0d,
    0x0a,0x20,0x20,0x72,0x65,0x61,0x64,0x6d,0x65,0x2e,
    0x65,0x75,0x63,0x20,0x2d,0x2d,0x2d,0x20,0x82,0xb1,
    0x82,0xcc,0x83,0x74,0x83,0x40,0x83,0x43,0x83,0x8b,
    0x20,0x20,0x20,0x28,0x45,0x55,0x43,0x2d,0x4a,0x50,
    0x29,0x0d,0x0a,0x20,0x20,0x72,0x65,0x61,0x64,0x6d,
    0x65,0x2e,0x6a,0x69,0x73,0x20,0x2d,0x2d,0x2d,0x20,
    0x93,0xfa,0x96,0x7b,0x8c,0xea,0x52,0x45,0x41,0x44,
    0x4d,0x45,0x20,0x20,0x20,0x28,0x4a,0x49,0x53,0x29,
    0x0d,0x0a,0x20,0x20,0x72,0x65,0x61,0x64,0x6d,0x65,
    0x2e,0x73,0x6a,0x73,0x20,0x2d,0x2d,0x2d,0x20,0x93,
    0xfa,0x96,0x7b,0x8c,0xea,0x52,0x45,0x41,0x44,0x4d,
    0x45,0x20,0x20,0x20,0x28,0x53,0x68,0x69,0x66,0x74,
    0x5f,0x4a,0x49,0x53,0x29,0x0d,0x0a,0x0d,0x0a,0x6a,
    0x74,0x65,0x78,0x74,0x2f,0x63,0x72,0x2f,0x0d,0x0a,
    0x6a,0x74,0x65,0x78,0x74,0x2f,0x63,0x72,0x6c,0x66,
    0x2f,0x0d,0x0a,0x6a,0x74,0x65,0x78,0x74,0x2f,0x6c,
    0x66,0x2f,0x0d,0x0a,0x0d,0x0a,0x20,0x20,0x61,0x73,
    0x63,0x69,0x69,0x2e,0x74,0x78,0x74,0x20,0x2d,0x2d,
    0x2d,0x2d,0x20,0x41,0x53,0x43,0x49,0x49,0x82,0xc5,
    0x8f,0x91,0x82,0xa2,0x82,0xbd,0x93,0xfa,0x96,0x7b,
    0x8c,0xea,0x28,0x83,0x8d,0x81,0x5b,0x83,0x7d,0x8e,
    0x9a,0x29,0x0d,0x0a,0x0d,0x0a,0x20,0x20,0x6a,0x30,
    0x32,0x30,0x31,0x2d,0x38,0x62,0x2e,0x74,0x78,0x74,
    0x20,0x2d,0x20,0x4a,0x49,0x53,0x20,0x58,0x30,0x32,
    0x30,0x31,0x82,0xcc,0x95,0xd0,0x89,0xbc,0x96,0xbc,
    0x20,0x82,0xf0,0x20,0x38,0x92,0x50,0x88,0xca,0x95,
    0x84,0x8d,0x86,0x89,0xbb,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x53,0x68,0x69,0x66,0x74,0x5f,0x4a,0x49,
    0x53,0x82,0xc6,0x93,0xaf,0x82,0xb6,0x0d,0x0a,0x20,
    0x20,0x6a,0x30,0x32,0x30,0x31,0x2d,0x65,0x73,0x2e,
    0x74,0x78,0x74,0x20,0x2d,0x20,0x4a,0x49,0x53,0x20,
    0x58,0x30,0x32,0x30,0x31,0x82,0xcc,0x95,0xd0,0x89,
    0xbc,0x96,0xbc,0x20,0x82,0xf0,0x20,0x45,0x53,0x43,
    0x28,0x49,0x82,0xc5,0x95,0x84,0x8d,0x86,0x89,0xbb,
    0x0d,0x0a,0x20,0x20,0x6a,0x30,0x32,0x30,0x31,0x2d,
    0x73,0x6f,0x2e,0x74,0x78,0x74,0x20,0x2d,0x20,0x4a,
    0x49,0x53,0x20,0x58,0x30,0x32,0x30,0x31,0x82,0xcc,
    0x95,0xd0,0x89,0xbc,0x96,0xbc,0x20,0x82,0xf0,0x20,
    0x53,0x4f,0x2f,0x53,0x49,0x82,0xc5,0x95,0x84,0x8d,
    0x86,0x89,0xbb,0x0d,0x0a,0x0d,0x0a,0x20,0x20,0x6a,
    0x30,0x32,0x30,0x38,0x2d,0x38,0x62,0x2e,0x74,0x78,
    0x74,0x20,0x2d,0x20,0x4a,0x49,0x53,0x20,0x58,0x30,
    0x32,0x30,0x38,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x82,0xf0,0x20,0x38,0x92,0x50,0x88,0xca,
    0x95,0x84,0x8d,0x86,0x89,0xbb,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x45,0x55,0x43,0x2d,0x4a,0x50,0x82,
    0xc6,0x93,0xaf,0x82,0xb6,0x0d,0x0a,0x20,0x20,0x6a,
    0x30,0x32,0x30,0x38,0x2d,0x37,0x38,0x2e,0x74,0x78,
    0x74,0x20,0x2d,0x20,0x4a,0x49,0x53,0x20,0x58,0x30,
    0x32,0x30,0x38,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x82,0xf0,0x20,0x45,0x53,0x43,0x24,0x40,
    0x82,0xc5,0x95,0x84,0x8d,0x86,0x89,0xbb,0x20,0x20,
    0x20,0x20,0x20,0x82,0xa2,0x82,0xed,0x82,0xe4,0x82,
    0xe9,0x8b,0x8c,0x4a,0x49,0x53,0x0d,0x0a,0x20,0x20,
    0x6a,0x30,0x32,0x30,0x38,0x2d,0x38,0x33,0x2e,0x74,
    0x78,0x74,0x20,0x2d,0x20,0x4a,0x49,0x53,0x20,0x58,
    0x30,0x32,0x30,0x38,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x82,0xf0,0x20,0x45,0x53,0x43,0x24,
    0x42,0x82,0xc5,0x95,0x84,0x8d,0x86,0x89,0xbb,0x20,
    0x20,0x20,0x20,0x20,0x82,0xa2,0x82,0xed,0x82,0xe4,
    0x82,0xe9,0x90,0x56,0x4a,0x49,0x53,0x0d,0x0a,0x0d,
    0x0a,0x20,0x20,0x65,0x30,0x32,0x30,0x31,0x2e,0x74,
    0x78,0x74,0x20,0x2d,0x2d,0x2d,0x2d,0x20,0x4a,0x49,
    0x53,0x20,0x58,0x30,0x32,0x30,0x31,0x82,0xcc,0x95,
    0xd0,0x89,0xbc,0x96,0xbc,0x20,0x82,0xf0,0x20,0x45,
    0x55,0x43,0x2d,0x4a,0x50,0x82,0xc5,0x95,0x84,0x8d,
    0x86,0x89,0xbb,0x0d,0x0a,0x20,0x20,0x65,0x30,0x32,
    0x30,0x38,0x2e,0x74,0x78,0x74,0x20,0x2d,0x2d,0x2d,
    0x2d,0x20,0x4a,0x49,0x53,0x20,0x58,0x30,0x32,0x30,
    0x38,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x82,0xf0,0x20,0x45,0x55,0x43,0x2d,0x4a,0x50,0x82,
    0xc5,0x95,0x84,0x8d,0x86,0x89,0xbb,0x20,0x20,0x20,
    0x20,0x38,0x83,0x72,0x83,0x62,0x83,0x67,0x4a,0x49,
    0x53,0x58,0x30,0x32,0x30,0x38,0x82,0xc6,0x93,0xaf,
    0x82,0xb6,0x0d,0x0a,0x0d,0x0a,0x20,0x20,0x73,0x30,
    0x32,0x30,0x31,0x2e,0x74,0x78,0x74,0x20,0x2d,0x2d,
    0x2d,0x2d,0x20,0x4a,0x49,0x53,0x20,0x58,0x30,0x32,
    0x30,0x31,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x82,0xf0,0x20,0x53,0x68,0x69,0x66,0x74,0x5f,
    0x4a,0x49,0x53,0x82,0xc5,0x95,0x84,0x8d,0x86,0x89,
    0xbb,0x20,0x38,0x83,0x72,0x83,0x62,0x83,0x67,0x4a,
    0x49,0x53,0x58,0x30,0x32,0x30,0x31,0x82,0xc6,0x93,
    0xaf,0x82,0xb6,0x0d,0x0a,0x20,0x20,0x73,0x30,0x32,
    0x30,0x38,0x2e,0x74,0x78,0x74,0x20,0x2d,0x2d,0x2d,
    0x2d,0x20,0x4a,0x49,0x53,0x20,0x58,0x30,0x32,0x30,
    0x38,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x82,0xf0,0x20,0x53,0x68,0x69,0x66,0x74,0x5f,0x4a,
    0x49,0x53,0x82,0xc5,0x95,0x84,0x8d,0x86,0x89,0xbb,
    0x0d,0x0a,0x0d,0x0a,0x6a,0x74,0x65,0x78,0x74,0x2f,
    0x6f,0x74,0x68,0x65,0x72,0x73,0x2f,0x0d,0x0a,0x0d,
    0x0a,0x20,0x20,0x62,0x36,0x34,0x6a,0x69,0x73,0x2e,
    0x74,0x78,0x74,0x20,0x2d,0x2d,0x2d,0x20,0x49,0x53,
    0x4f,0x2d,0x32,0x30,0x32,0x32,0x2d,0x4a,0x50,0x20,
    0x28,0x4a,0x49,0x53,0x29,0x20,0x82,0xf0,0x20,0x62,
    0x61,0x73,0x65,0x36,0x34,0x82,0xc5,0x95,0x84,0x8d,
    0x86,0x89,0xbb,0x0d,0x0a,0x20,0x20,0x71,0x74,0x6a,
    0x69,0x73,0x2e,0x74,0x78,0x74,0x20,0x2d,0x2d,0x2d,
    0x2d,0x20,0x49,0x53,0x4f,0x2d,0x32,0x30,0x32,0x32,
    0x2d,0x4a,0x50,0x20,0x28,0x4a,0x49,0x53,0x29,0x20,
    0x82,0xf0,0x20,0x71,0x75,0x6f,0x74,0x65,0x64,0x2d,
    0x70,0x72,0x69,0x6e,0x74,0x61,0x62,0x6c,0x65,0x82,
    0xc5,0x95,0x84,0x8d,0x86,0x89,0xbb,0x0d,0x0a,0x0d,
    0x0a,0x20,0x20,0x62,0x6b,0x65,0x75,0x63,0x2e,0x74,
    0x78,0x74,0x20,0x2d,0x2d,0x2d,0x2d,0x20,0x89,0xf3,
    0x82,0xea,0x82,0xbd,0x45,0x55,0x43,0x2d,0x4a,0x50,
    0x20,0x20,0x20,0x20,0x20,0x20,0x90,0xe6,0x93,0xaa,
    0x83,0x72,0x83,0x62,0x83,0x67,0x82,0xaa,0x83,0x5b,
    0x83,0x8d,0x0d,0x0a,0x20,0x20,0x62,0x6b,0x6a,0x69,
    0x73,0x2e,0x74,0x78,0x74,0x20,0x2d,0x2d,0x2d,0x2d,
    0x20,0x89,0xf3,0x82,0xea,0x82,0xbd,0x4a,0x49,0x53,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x45,
    0x53,0x43,0x83,0x52,0x81,0x5b,0x83,0x68,0x82,0xaa,
    0x8c,0x87,0x82,0xaf,0x82,0xbd,0x0d,0x0a,0x20,0x20,
    0x62,0x6b,0x73,0x6a,0x69,0x73,0x2e,0x74,0x78,0x74,
    0x2d,0x2d,0x2d,0x2d,0x20,0x89,0xf3,0x82,0xea,0x82,
    0xbd,0x53,0x68,0x69,0x66,0x74,0x5f,0x4a,0x49,0x53,
    0x20,0x20,0x20,0x90,0xe6,0x93,0xaa,0x83,0x72,0x83,
    0x62,0x83,0x67,0x82,0xaa,0x83,0x5b,0x83,0x8d,0x0d,
    0x0a,0x0d,0x0a,0x20,0x20,0x63,0x74,0x72,0x6c,0x5f,
    0x7a,0x2e,0x74,0x78,0x74,0x20,0x20,0x20,0x20,0x20,
    0x53,0x68,0x69,0x66,0x74,0x5f,0x4a,0x49,0x53,0x20,
    0x20,0x20,0x20,0x20,0x20,0x5e,0x5a,0x83,0x4c,0x83,
    0x83,0x83,0x89,0x83,0x4e,0x83,0x5e,0x95,0x74,0x82,
    0xab,0x20,0x20,0x20,0x28,0x44,0x4f,0x53,0x95,0x97,
    0x29,0x0d,0x0a,0x20,0x20,0x6d,0x61,0x63,0x74,0x78,
    0x74,0x2e,0x62,0x69,0x6e,0x20,0x20,0x20,0x20,0x20,
    0x83,0x7d,0x83,0x62,0x83,0x4e,0x83,0x6f,0x83,0x43,
    0x83,0x69,0x83,0x8a,0x49,0x49,0x83,0x74,0x83,0x48,
    0x81,0x5b,0x83,0x7d,0x83,0x62,0x83,0x67,0x0d,0x0a
};
#endif /* _ICONV_FROM_ENCODING_SHIFT_JIS */

#ifdef _ICONV_FROM_ENCODING_UCS_2_INTERNAL
static const short ucs2[] =
{
    0x8272,0x3005,0x30c6,0x30ad,0x30b9,
    0x30c8,0x30d5,0x30a1,0x30a4,0x30eb,
    0x96c6,0x0020,0x0056,0x0065,0x0072,
    0x0033,0x002e,0x0033,0x0020,0x0028,
    0x0043,0x0029,0x0048,0x0041,0x0054,
    0x000d,0x000a,0x000d,0x000a,0x3053,
    0x306e,0x30a2,0x30fc,0x30ab,0x30a4,
    0x30d6,0x306e,0x6700,0x65b0,0x7248,
    0x306f,0x3053,0x3053,0x306b,0x3042,
    0x308a,0x307e,0x3059,0x3002,0x000d,
    0x000a,0x0068,0x0074,0x0074,0x0070,
    0x003a,0x002f,0x002f,0x0077,0x0077,
    0x0077,0x0030,0x0032,0x002e,0x0073,
    0x006f,0x002d,0x006e,0x0065,0x0074,
    0x002e,0x006e,0x0065,0x002e,0x006a,
    0x0070,0x002f,0x0025,0x0037,0x0045,
    0x0068,0x0061,0x0074,0x002f,0x0066,
    0x0069,0x006c,0x0065,0x0073,0x002f,
    0x0069,0x006e,0x0064,0x0065,0x0078,
    0x002d,0x006a,0x002e,0x0068,0x0074,
    0x006d,0x006c,0x000d,0x000a,0x000d,
    0x000a,0x0063,0x0072,0x002c,0x0020,
    0x0063,0x0072,0x006c,0x0066,0x002c,
    0x0020,0x006c,0x0066,0x30c7,0x30a3,
    0x30ec,0x30af,0x30c8,0x30ea,0x0028,
    0x30d5,0x30a9,0x30eb,0x30c0,0x0029,
    0x306e,0x5185,0x5bb9,0x306f,0x540c,
    0x3058,0x3067,0x3059,0x304c,0x3001,
    0x884c,0x306e,0x533a,0x5207,0x308a,
    0x304c,0x305d,0x308c,0x305e,0x308c,
    0x000d,0x000a,0x0043,0x0052,0x0028,
    0x004d,0x0061,0x0063,0x98a8,0x0029,
    0x3001,0x0043,0x0052,0x002b,0x004c,
    0x0046,0x0028,0x0044,0x004f,0x0053,
    0x98a8,0x0029,0x3001,0x004c,0x0046,
    0x0028,0x0055,0x004e,0x0049,0x0058,
    0x98a8,0x0029,0x306b,0x306a,0x3063,
    0x3066,0x3044,0x307e,0x3059,0x3002,
    0x000d,0x000a,0x000d,0x000a,0x000d,
    0x000a,0x006a,0x0074,0x0065,0x0078,
    0x0074,0x002f,0x000d,0x000a,0x000d,
    0x000a,0x0020,0x0020,0x0072,0x0065,
    0x0061,0x0064,0x006d,0x0065,0x002e,
    0x0074,0x0078,0x0074,0x0020,0x002d,
    0x002d,0x002d,0x0020,0x82f1,0x8a9e,
    0x0052,0x0045,0x0041,0x0044,0x004d,
    0x0045,0x0020,0x0020,0x0020,0x0020,
    0x0020,0x0028,0x0041,0x0053,0x0043,
    0x0049,0x0049,0x0029,0x000d,0x000a,
    0x0020,0x0020,0x0072,0x0065,0x0061,
    0x0064,0x006d,0x0065,0x002e,0x0065,
    0x0075,0x0063,0x0020,0x002d,0x002d,
    0x002d,0x0020,0x3053,0x306e,0x30d5,
    0x30a1,0x30a4,0x30eb,0x0020,0x0020,
    0x0020,0x0028,0x0045,0x0055,0x0043,
    0x002d,0x004a,0x0050,0x0029,0x000d,
    0x000a,0x0020,0x0020,0x0072,0x0065,
    0x0061,0x0064,0x006d,0x0065,0x002e,
    0x006a,0x0069,0x0073,0x0020,0x002d,
    0x002d,0x002d,0x0020,0x65e5,0x672c,
    0x8a9e,0x0052,0x0045,0x0041,0x0044,
    0x004d,0x0045,0x0020,0x0020,0x0020,
    0x0028,0x004a,0x0049,0x0053,0x0029,
    0x000d,0x000a,0x0020,0x0020,0x0072,
    0x0065,0x0061,0x0064,0x006d,0x0065,
    0x002e,0x0073,0x006a,0x0073,0x0020,
    0x002d,0x002d,0x002d,0x0020,0x65e5,
    0x672c,0x8a9e,0x0052,0x0045,0x0041,
    0x0044,0x004d,0x0045,0x0020,0x0020,
    0x0020,0x0028,0x0053,0x0068,0x0069,
    0x0066,0x0074,0x005f,0x004a,0x0049,
    0x0053,0x0029,0x000d,0x000a,0x000d,
    0x000a,0x006a,0x0074,0x0065,0x0078,
    0x0074,0x002f,0x0063,0x0072,0x002f,
    0x000d,0x000a,0x006a,0x0074,0x0065,
    0x0078,0x0074,0x002f,0x0063,0x0072,
    0x006c,0x0066,0x002f,0x000d,0x000a,
    0x006a,0x0074,0x0065,0x0078,0x0074,
    0x002f,0x006c,0x0066,0x002f,0x000d,
    0x000a,0x000d,0x000a,0x0020,0x0020,
    0x0061,0x0073,0x0063,0x0069,0x0069,
    0x002e,0x0074,0x0078,0x0074,0x0020,
    0x002d,0x002d,0x002d,0x002d,0x0020,
    0x0041,0x0053,0x0043,0x0049,0x0049,
    0x3067,0x66f8,0x3044,0x305f,0x65e5,
    0x672c,0x8a9e,0x0028,0x30ed,0x30fc,
    0x30de,0x5b57,0x0029,0x000d,0x000a,
    0x000d,0x000a,0x0020,0x0020,0x006a,
    0x0030,0x0032,0x0030,0x0031,0x002d,
    0x0038,0x0062,0x002e,0x0074,0x0078,
    0x0074,0x0020,0x002d,0x0020,0x004a,
    0x0049,0x0053,0x0020,0x0058,0x0030,
    0x0032,0x0030,0x0031,0x306e,0x7247,
    0x4eee,0x540d,0x0020,0x3092,0x0020,
    0x0038,0x5358,0x4f4d,0x7b26,0x53f7,
    0x5316,0x0020,0x0020,0x0020,0x0020,
    0x0020,0x0020,0x0020,0x0053,0x0068,
    0x0069,0x0066,0x0074,0x005f,0x004a,
    0x0049,0x0053,0x3068,0x540c,0x3058,
    0x000d,0x000a,0x0020,0x0020,0x006a,
    0x0030,0x0032,0x0030,0x0031,0x002d,
    0x0065,0x0073,0x002e,0x0074,0x0078,
    0x0074,0x0020,0x002d,0x0020,0x004a,
    0x0049,0x0053,0x0020,0x0058,0x0030,
    0x0032,0x0030,0x0031,0x306e,0x7247,
    0x4eee,0x540d,0x0020,0x3092,0x0020,
    0x0045,0x0053,0x0043,0x0028,0x0049,
    0x3067,0x7b26,0x53f7,0x5316,0x000d,
    0x000a,0x0020,0x0020,0x006a,0x0030,
    0x0032,0x0030,0x0031,0x002d,0x0073,
    0x006f,0x002e,0x0074,0x0078,0x0074,
    0x0020,0x002d,0x0020,0x004a,0x0049,
    0x0053,0x0020,0x0058,0x0030,0x0032,
    0x0030,0x0031,0x306e,0x7247,0x4eee,
    0x540d,0x0020,0x3092,0x0020,0x0053,
    0x004f,0x002f,0x0053,0x0049,0x3067,
    0x7b26,0x53f7,0x5316,0x000d,0x000a,
    0x000d,0x000a,0x0020,0x0020,0x006a,
    0x0030,0x0032,0x0030,0x0038,0x002d,
    0x0038,0x0062,0x002e,0x0074,0x0078,
    0x0074,0x0020,0x002d,0x0020,0x004a,
    0x0049,0x0053,0x0020,0x0058,0x0030,
    0x0032,0x0030,0x0038,0x0020,0x0020,
    0x0020,0x0020,0x0020,0x0020,0x0020,
    0x0020,0x0020,0x3092,0x0020,0x0038,
    0x5358,0x4f4d,0x7b26,0x53f7,0x5316,
    0x0020,0x0020,0x0020,0x0020,0x0020,
    0x0020,0x0020,0x0045,0x0055,0x0043,
    0x002d,0x004a,0x0050,0x3068,0x540c,
    0x3058,0x000d,0x000a,0x0020,0x0020,
    0x006a,0x0030,0x0032,0x0030,0x0038,
    0x002d,0x0037,0x0038,0x002e,0x0074,
    0x0078,0x0074,0x0020,0x002d,0x0020,
    0x004a,0x0049,0x0053,0x0020,0x0058,
    0x0030,0x0032,0x0030,0x0038,0x0020,
    0x0020,0x0020,0x0020,0x0020,0x0020,
    0x0020,0x0020,0x0020,0x3092,0x0020,
    0x0045,0x0053,0x0043,0x0024,0x0040,
    0x3067,0x7b26,0x53f7,0x5316,0x0020,
    0x0020,0x0020,0x0020,0x0020,0x3044,
    0x308f,0x3086,0x308b,0x65e7,0x004a,
    0x0049,0x0053,0x000d,0x000a,0x0020,
    0x0020,0x006a,0x0030,0x0032,0x0030,
    0x0038,0x002d,0x0038,0x0033,0x002e,
    0x0074,0x0078,0x0074,0x0020,0x002d,
    0x0020,0x004a,0x0049,0x0053,0x0020,
    0x0058,0x0030,0x0032,0x0030,0x0038,
    0x0020,0x0020,0x0020,0x0020,0x0020,
    0x0020,0x0020,0x0020,0x0020,0x3092,
    0x0020,0x0045,0x0053,0x0043,0x0024,
    0x0042,0x3067,0x7b26,0x53f7,0x5316,
    0x0020,0x0020,0x0020,0x0020,0x0020,
    0x3044,0x308f,0x3086,0x308b,0x65b0,
    0x004a,0x0049,0x0053,0x000d,0x000a,
    0x000d,0x000a,0x0020,0x0020,0x0065,
    0x0030,0x0032,0x0030,0x0031,0x002e,
    0x0074,0x0078,0x0074,0x0020,0x002d,
    0x002d,0x002d,0x002d,0x0020,0x004a,
    0x0049,0x0053,0x0020,0x0058,0x0030,
    0x0032,0x0030,0x0031,0x306e,0x7247,
    0x4eee,0x540d,0x0020,0x3092,0x0020,
    0x0045,0x0055,0x0043,0x002d,0x004a,
    0x0050,0x3067,0x7b26,0x53f7,0x5316,
    0x000d,0x000a,0x0020,0x0020,0x0065,
    0x0030,0x0032,0x0030,0x0038,0x002e,
    0x0074,0x0078,0x0074,0x0020,0x002d,
    0x002d,0x002d,0x002d,0x0020,0x004a,
    0x0049,0x0053,0x0020,0x0058,0x0030,
    0x0032,0x0030,0x0038,0x0020,0x0020,
    0x0020,0x0020,0x0020,0x0020,0x0020,
    0x0020,0x0020,0x3092,0x0020,0x0045,
    0x0055,0x0043,0x002d,0x004a,0x0050,
    0x3067,0x7b26,0x53f7,0x5316,0x0020,
    0x0020,0x0020,0x0020,0x0038,0x30d3,
    0x30c3,0x30c8,0x004a,0x0049,0x0053,
    0x0058,0x0030,0x0032,0x0030,0x0038,
    0x3068,0x540c,0x3058,0x000d,0x000a,
    0x000d,0x000a,0x0020,0x0020,0x0073,
    0x0030,0x0032,0x0030,0x0031,0x002e,
    0x0074,0x0078,0x0074,0x0020,0x002d,
    0x002d,0x002d,0x002d,0x0020,0x004a,
    0x0049,0x0053,0x0020,0x0058,0x0030,
    0x0032,0x0030,0x0031,0x0020,0x0020,
    0x0020,0x0020,0x0020,0x0020,0x0020,
    0x0020,0x0020,0x3092,0x0020,0x0053,
    0x0068,0x0069,0x0066,0x0074,0x005f,
    0x004a,0x0049,0x0053,0x3067,0x7b26,
    0x53f7,0x5316,0x0020,0x0038,0x30d3,
    0x30c3,0x30c8,0x004a,0x0049,0x0053,
    0x0058,0x0030,0x0032,0x0030,0x0031,
    0x3068,0x540c,0x3058,0x000d,0x000a,
    0x0020,0x0020,0x0073,0x0030,0x0032,
    0x0030,0x0038,0x002e,0x0074,0x0078,
    0x0074,0x0020,0x002d,0x002d,0x002d,
    0x002d,0x0020,0x004a,0x0049,0x0053,
    0x0020,0x0058,0x0030,0x0032,0x0030,
    0x0038,0x0020,0x0020,0x0020,0x0020,
    0x0020,0x0020,0x0020,0x0020,0x0020,
    0x3092,0x0020,0x0053,0x0068,0x0069,
    0x0066,0x0074,0x005f,0x004a,0x0049,
    0x0053,0x3067,0x7b26,0x53f7,0x5316,
    0x000d,0x000a,0x000d,0x000a,0x006a,
    0x0074,0x0065,0x0078,0x0074,0x002f,
    0x006f,0x0074,0x0068,0x0065,0x0072,
    0x0073,0x002f,0x000d,0x000a,0x000d,
    0x000a,0x0020,0x0020,0x0062,0x0036,
    0x0034,0x006a,0x0069,0x0073,0x002e,
    0x0074,0x0078,0x0074,0x0020,0x002d,
    0x002d,0x002d,0x0020,0x0049,0x0053,
    0x004f,0x002d,0x0032,0x0030,0x0032,
    0x0032,0x002d,0x004a,0x0050,0x0020,
    0x0028,0x004a,0x0049,0x0053,0x0029,
    0x0020,0x3092,0x0020,0x0062,0x0061,
    0x0073,0x0065,0x0036,0x0034,0x3067,
    0x7b26,0x53f7,0x5316,0x000d,0x000a,
    0x0020,0x0020,0x0071,0x0074,0x006a,
    0x0069,0x0073,0x002e,0x0074,0x0078,
    0x0074,0x0020,0x002d,0x002d,0x002d,
    0x002d,0x0020,0x0049,0x0053,0x004f,
    0x002d,0x0032,0x0030,0x0032,0x0032,
    0x002d,0x004a,0x0050,0x0020,0x0028,
    0x004a,0x0049,0x0053,0x0029,0x0020,
    0x3092,0x0020,0x0071,0x0075,0x006f,
    0x0074,0x0065,0x0064,0x002d,0x0070,
    0x0072,0x0069,0x006e,0x0074,0x0061,
    0x0062,0x006c,0x0065,0x3067,0x7b26,
    0x53f7,0x5316,0x000d,0x000a,0x000d,
    0x000a,0x0020,0x0020,0x0062,0x006b,
    0x0065,0x0075,0x0063,0x002e,0x0074,
    0x0078,0x0074,0x0020,0x002d,0x002d,
    0x002d,0x002d,0x0020,0x58ca,0x308c,
    0x305f,0x0045,0x0055,0x0043,0x002d,
    0x004a,0x0050,0x0020,0x0020,0x0020,
    0x0020,0x0020,0x0020,0x5148,0x982d,
    0x30d3,0x30c3,0x30c8,0x304c,0x30bc,
    0x30ed,0x000d,0x000a,0x0020,0x0020,
    0x0062,0x006b,0x006a,0x0069,0x0073,
    0x002e,0x0074,0x0078,0x0074,0x0020,
    0x002d,0x002d,0x002d,0x002d,0x0020,
    0x58ca,0x308c,0x305f,0x004a,0x0049,
    0x0053,0x0020,0x0020,0x0020,0x0020,
    0x0020,0x0020,0x0020,0x0020,0x0020,
    0x0045,0x0053,0x0043,0x30b3,0x30fc,
    0x30c9,0x304c,0x6b20,0x3051,0x305f,
    0x000d,0x000a,0x0020,0x0020,0x0062,
    0x006b,0x0073,0x006a,0x0069,0x0073,
    0x002e,0x0074,0x0078,0x0074,0x002d,
    0x002d,0x002d,0x002d,0x0020,0x58ca,
    0x308c,0x305f,0x0053,0x0068,0x0069,
    0x0066,0x0074,0x005f,0x004a,0x0049,
    0x0053,0x0020,0x0020,0x0020,0x5148,
    0x982d,0x30d3,0x30c3,0x30c8,0x304c,
    0x30bc,0x30ed,0x000d,0x000a,0x000d,
    0x000a,0x0020,0x0020,0x0063,0x0074,
    0x0072,0x006c,0x005f,0x007a,0x002e,
    0x0074,0x0078,0x0074,0x0020,0x0020,
    0x0020,0x0020,0x0020,0x0053,0x0068,
    0x0069,0x0066,0x0074,0x005f,0x004a,
    0x0049,0x0053,0x0020,0x0020,0x0020,
    0x0020,0x0020,0x0020,0x005e,0x005a,
    0x30ad,0x30e3,0x30e9,0x30af,0x30bf,
    0x4ed8,0x304d,0x0020,0x0020,0x0020,
    0x0028,0x0044,0x004f,0x0053,0x98a8,
    0x0029,0x000d,0x000a,0x0020,0x0020,
    0x006d,0x0061,0x0063,0x0074,0x0078,
    0x0074,0x002e,0x0062,0x0069,0x006e,
    0x0020,0x0020,0x0020,0x0020,0x0020,
    0x30de,0x30c3,0x30af,0x30d0,0x30a4,
    0x30ca,0x30ea,0x0049,0x0049,0x30d5,
    0x30a9,0x30fc,0x30de,0x30c3,0x30c8,
    0x000d,0x000a
};
#endif

struct iconv_data
{
    size_t len;
    char *name;
    char *data;
};

#define CONVERSIONS 4

static const struct iconv_data data[] =
{
#if defined(_ICONV_FROM_ENCODING_EUC_JP) && defined(_ICONV_TO_ENCODING_EUC_JP)
    {sizeof(euc_jp), "EUC-JP", (char *)euc_jp},
#endif
#if defined(_ICONV_FROM_ENCODING_SHIFT_JIS) && defined(_ICONV_TO_ENCODING_SHIFT_JIS)
    {sizeof(shift_jis), "SHIFT-JIS", (char *)shift_jis},
#endif
#if defined(_ICONV_FROM_ENCODING_UTF_8) && defined(_ICONV_TO_ENCODING_UTF_8)
    {sizeof(utf8), "UTF-8", (char *)utf8},
#endif
#if defined(_ICONV_FROM_ENCODING_UCS_2_INTERNAL) && defined(_ICONV_TO_ENCODING_UCS_2_INTERNAL)
    {sizeof(ucs2), "UCS-2-INTERNAL", (char *)ucs2},
#endif
    {0, NULL, NULL}
};

#define OUTBUF_LEN 2800
char ob[OUTBUF_LEN];

iconv_t descs[CONVERSIONS*CONVERSIONS];

#define ERROR 0

#ifndef TEST_NLSPATH
#define TEST_NLSPATH "./"
#endif

int main(void)
{
    int i, j, d = 0;
    unsigned k;
    size_t n;
    char *outbuf, *inbuf;
    int conversions = sizeof(data)/sizeof(struct iconv_data) - 1;

    CHECK(setenv("NLSPATH", TEST_NLSPATH, 0) != -1);

    puts("JP iconv test");

    for (i = 0; i < conversions; i++)
    {
        for (j = 0; j < conversions; j++)
	{
	    descs[d] = iconv_open(data[j].name, data[i].name);
	    if (descs[d++] == (iconv_t)-1)
	    {
	        printf("iconv_open(%s, %s)\n", data[i].name, data[j].name);
	        perror("");
                CHECK(ERROR);
	    }
	}
    }

    d = 0;
    for (i = 0; i < conversions; i++)
    {
        for (j = 0; j < conversions; j++)
	{
	    size_t inbytes = data[i].len;
	    size_t outbytes = OUTBUF_LEN;
	    inbuf = data[i].data;
	    outbuf = (char *)ob;

	    if (iconv(descs[d], NULL, NULL, (char **)&outbuf, &outbytes)                                                                       == (size_t)-1)
            {
                perror("Can't reset shift state");
                CHECK(ERROR);
            }

            n = iconv(descs[d++], (const char **)&(inbuf), &inbytes,
	                          (char **)&outbuf, &outbytes);
            if (n == (size_t)-1)
            {
	        printf("Conversion from %s to %s FAILED - iconv() "
                       "returned -1\n", data[i].name, data[j].name);
		perror("");
                CHECK(ERROR);
            }

	    if (data[j].len != OUTBUF_LEN - outbytes)
	    {
                printf("Conversion from %s to %s FAILED",
                       data[i].name, data[j].name);
	        printf(" - bad output buffer length (%ld instead of %lu)\n",
		       OUTBUF_LEN - (long) outbytes, (unsigned long) data[j].len);
                CHECK(ERROR);
	    }

	    for (k = 0; k < data[j].len; k++)
	    {
	        if (ob[k] != data[j].data[k])
		{
                    printf("Conversion from %s to %s FAILED",
                           data[i].name, data[j].name);
   	            printf("Error: byte %d is wrong\n", k);
		    printf("outbuf value: %#x, inbuf value %#x, "
		           "right value: %#x\n",
          	           (int)ob[k], (int)(data[i].data[k]),
		           (int)(data[j].data[k]));
                    CHECK(ERROR);
		}
	    }

	    printf("iconv from %s to %s was successfully done\n",
                   data[i].name, data[j].name);

	}
    }

    d = 0;
    for (i = 0; i < conversions; i++)
        for (j = 0; j < conversions; j++)
            CHECK(iconv_close(descs[d++]) != -1);

    exit(0);
}

#else /* #if defined(_ICONV_FROM_ENCODING_UTF_8) || ... */
int main(void)
{
    puts("None of UTF-8, EUC-JP, SHIFT-JIS and UCS-2_INTERNAL converters "
         "linked, SKIP test");
    exit(0);
}
#endif /* #if defined(_ICONV_FROM_ENCODING_UTF_8) || ... */
