///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __ATOM_TYPE_COLOR_MODIFIER_H
#define __ATOM_TYPE_COLOR_MODIFIER_H

#include <core/Core.h>
#include <atomviz/AtomViz.h>
#include "../AtomsObjectModifierBase.h"

namespace AtomViz {

/******************************************************************************
* The color modifier assigns colors to the based on their type.
******************************************************************************/
class ATOMVIZ_DLLEXPORT AtomTypeColorModifier : public AtomsObjectModifierBase
{
public:

	/// Default constructor.
	AtomTypeColorModifier(bool isLoading = false) : AtomsObjectModifierBase(isLoading) {}

	/// Asks the modifier for its validity interval at the given time.
	virtual TimeInterval modifierValidity(TimeTicks time) { return TimeForever; }

protected:

	/// Modifies the atoms object. The time interval passed
	/// to the function is reduced to the interval where the modified object is valid/constant.
	virtual EvaluationStatus modifyAtomsObject(TimeTicks time, TimeInterval& validityInterval);

private:

	Q_OBJECT
	DECLARE_SERIALIZABLE_PLUGIN_CLASS(AtomTypeColorModifier)
};

};	// End of namespace AtomViz

#endif // __ATOM_TYPE_COLOR_MODIFIER_H
