/*
 * Purpose: Firmware download for Midiman MIDISport 2x2
 */
/*
 *
 * This file is part of Open Sound System.
 *
 * Copyright (C) 4Front Technologies 1996-2008.
 *
 * This this source file is released under GPL v2 license (no other versions).
 * See the COPYING file included in the main directory of this source
 * distribution for the license terms and conditions.
 *
 */
struct setup_request
{
  unsigned char bmRequestType;
  unsigned char bRequest;
  unsigned short wValue;
  unsigned short wIndex;
  unsigned short wLength;
  unsigned short cbData;
  const /*unsigned */ char *pData;
};

const struct setup_request midisport2x2_setupRequest[] = {
  {0x00, 0x05, 0x0002, 0x0000, 0x0000, 0x0000, ""},
  {0x40, 0xA0, 0x7F92, 0x0000, 0x0001, 0x0001, "\x01"},
  {0x40, 0xA0, 0x7F92, 0x0000, 0x0001, 0x0001, "\x01"},
  {0x40, 0xA0, 0x146C, 0x0000, 0x0010, 0x0010,
   "\xC2\x00\x90\x7F\xA5\xE0\x54\x18\xFF\x13\x13\x13\x54\x1F\x44\x50"},
  {0x40, 0xA0, 0x147C, 0x0000, 0x0010, 0x0010,
   "\xF5\x1C\x13\x92\x01\xD2\xE8\x90\x7F\xAB\x74\xFF\xF0\x90\x7F\xA9"},
  {0x40, 0xA0, 0x148C, 0x0000, 0x0010, 0x0010,
   "\xF0\x90\x7F\xAA\xF0\x53\x91\xEF\x90\x7F\x95\xE0\x44\xC0\xF0\x90"},
  {0x40, 0xA0, 0x149C, 0x0000, 0x0010, 0x0010,
   "\x7F\xAF\xE0\x44\x01\xF0\x90\x7F\xAE\xE0\x44\x05\xF0\xD2\xAF\x12"},
  {0x40, 0xA0, 0x14AC, 0x0000, 0x000D, 0x000D,
   "\x17\x5F\x30\x00\xFD\x12\x11\x00\xC2\x00\x80\xF6\x22"},
  {0x40, 0xA0, 0x1100, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xE9\xE0\x24\x5D\x60\x0D\x14\x70\x03\x02\x12\x44\x24\x02"},
  {0x40, 0xA0, 0x1110, 0x0000, 0x0010, 0x0010,
   "\x60\x03\x02\x12\x4A\x90\x7F\xEA\xE0\x75\x08\x00\xF5\x09\xA3\xE0"},
  {0x40, 0xA0, 0x1120, 0x0000, 0x0010, 0x0010,
   "\xFE\xE4\x25\x09\xF5\x09\xEE\x35\x08\xF5\x08\x90\x7F\xEE\xE0\x75"},
  {0x40, 0xA0, 0x1130, 0x0000, 0x0010, 0x0010,
   "\x0A\x00\xF5\x0B\xA3\xE0\xFE\xE4\x25\x0B\xF5\x0B\xEE\x35\x0A\xF5"},
  {0x40, 0xA0, 0x1140, 0x0000, 0x0010, 0x0010,
   "\x0A\x90\x7F\xE8\xE0\x64\xC0\x60\x03\x02\x11\xD4\xE5\x0B\x45\x0A"},
  {0x40, 0xA0, 0x1150, 0x0000, 0x0010, 0x0010,
   "\x70\x03\x02\x12\x4A\xC3\xE5\x0B\x94\x40\xE5\x0A\x94\x00\x50\x08"},
  {0x40, 0xA0, 0x1160, 0x0000, 0x0010, 0x0010,
   "\x85\x0A\x0C\x85\x0B\x0D\x80\x06\x75\x0C\x00\x75\x0D\x40\x90\x7F"},
  {0x40, 0xA0, 0x1170, 0x0000, 0x0010, 0x0010,
   "\xE9\xE0\xB4\xA3\x25\xAE\x0C\xAF\x0D\xAA\x08\xA9\x09\x7B\x01\xC0"},
  {0x40, 0xA0, 0x1180, 0x0000, 0x0010, 0x0010,
   "\x03\xC0\x02\xC0\x01\x7A\x7F\x79\x00\x78\x00\x7C\x7F\xAD\x03\xD0"},
  {0x40, 0xA0, 0x1190, 0x0000, 0x0010, 0x0010,
   "\x01\xD0\x02\xD0\x03\x12\x13\x56\x80\x0F\xAF\x09\xAE\x08\xAD\x0D"},
  {0x40, 0xA0, 0x11A0, 0x0000, 0x0010, 0x0010,
   "\x7A\x7F\x79\x00\x7B\x00\x12\x15\xA4\x90\x7F\xB5\xE5\x0D\xF0\xE5"},
  {0x40, 0xA0, 0x11B0, 0x0000, 0x0010, 0x0010,
   "\x0D\x25\x09\xF5\x09\xE5\x0C\x35\x08\xF5\x08\xC3\xE5\x0B\x95\x0D"},
  {0x40, 0xA0, 0x11C0, 0x0000, 0x0010, 0x0010,
   "\xF5\x0B\xE5\x0A\x95\x0C\xF5\x0A\x90\x7F\xB4\xE0\x20\xE2\x03\x02"},
  {0x40, 0xA0, 0x11D0, 0x0000, 0x0010, 0x0010,
   "\x11\x4C\x80\xF4\x90\x7F\xE8\xE0\x64\x40\x70\x6E\xE5\x0B\x45\x0A"},
  {0x40, 0xA0, 0x11E0, 0x0000, 0x0010, 0x0010,
   "\x60\x68\xE4\x90\x7F\xC5\xF0\x90\x7F\xB4\xE0\x20\xE3\xF9\x90\x7F"},
  {0x40, 0xA0, 0x11F0, 0x0000, 0x0010, 0x0010,
   "\xC5\xE0\x75\x0C\x00\xF5\x0D\x90\x7F\xE9\xE0\xB4\xA3\x15\xAE\x0C"},
  {0x40, 0xA0, 0x1200, 0x0000, 0x0010, 0x0010,
   "\xAF\x0D\xA8\x09\xAC\x08\x7D\x01\x7B\x01\x7A\x7E\x79\xC0\x12\x13"},
  {0x40, 0xA0, 0x1210, 0x0000, 0x0010, 0x0010,
   "\x56\x80\x0F\xAF\x09\xAE\x08\xAD\x0D\x7A\x7F\x79\x00\x7B\x00\x12"},
  {0x40, 0xA0, 0x1220, 0x0000, 0x0010, 0x0010,
   "\x14\xB9\xE5\x0D\x25\x09\xF5\x09\xE5\x0C\x35\x08\xF5\x08\xC3\xE5"},
  {0x40, 0xA0, 0x1230, 0x0000, 0x0010, 0x0010,
   "\x0B\x95\x0D\xF5\x0B\xE5\x0A\x95\x0C\xF5\x0A\x90\x7F\xB4\xE0\x44"},
  {0x40, 0xA0, 0x1240, 0x0000, 0x000A, 0x000A,
   "\x02\xF0\x80\x98\x90\x7F\xEA\xE0\xF5\x1C"},
  {0x40, 0xA0, 0x124A, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x1558, 0x0000, 0x0006, 0x0006, "\xAB\x07\xAA\x06\xAC\x05"},
  {0x40, 0xA0, 0x155E, 0x0000, 0x0010, 0x0010,
   "\xE4\xFD\x30\x01\x11\xEA\xFF\xAE\x05\x0D\xEE\x24\x00\xF5\x82\xE4"},
  {0x40, 0xA0, 0x156E, 0x0000, 0x0010, 0x0010,
   "\x34\xE0\xF5\x83\xEF\xF0\xEB\xAE\x05\x0D\x74\x00\x2E\xF5\x82\xE4"},
  {0x40, 0xA0, 0x157E, 0x0000, 0x0010, 0x0010,
   "\x34\xE0\xF5\x83\xEB\xF0\xAF\x05\x0D\x74\x00\x2F\xF5\x82\xE4\x34"},
  {0x40, 0xA0, 0x158E, 0x0000, 0x0010, 0x0010,
   "\xE0\xF5\x83\xEC\xF0\xAF\x1C\x7A\xE0\x7B\x00\x12\x17\x20\x7F\x0A"},
  {0x40, 0xA0, 0x159E, 0x0000, 0x0005, 0x0005, "\x7E\x00\x12\x17\x3C"},
  {0x40, 0xA0, 0x15A3, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x14B9, 0x0000, 0x000A, 0x000A,
   "\x8E\x0E\x8F\x0F\x8D\x10\x8A\x11\x8B\x12"},
  {0x40, 0xA0, 0x14C3, 0x0000, 0x0010, 0x0010,
   "\xE4\xF5\x13\xE5\x13\xC3\x95\x10\x50\x20\x05\x0F\xE5\x0F\xAE\x0E"},
  {0x40, 0xA0, 0x14D3, 0x0000, 0x0010, 0x0010,
   "\x70\x02\x05\x0E\x14\xFF\xE5\x12\x25\x13\xF5\x82\xE4\x35\x11\xF5"},
  {0x40, 0xA0, 0x14E3, 0x0000, 0x000A, 0x000A,
   "\x83\xE0\xFD\x12\x15\x58\x05\x13\x80\xD9"},
  {0x40, 0xA0, 0x14ED, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x15A4, 0x0000, 0x000A, 0x000A,
   "\x8E\x0E\x8F\x0F\x8D\x10\x8A\x11\x8B\x12"},
  {0x40, 0xA0, 0x15AE, 0x0000, 0x0010, 0x0010,
   "\xE4\xFD\x30\x01\x12\xE5\x0E\xFF\xAE\x05\x0D\xEE\x24\x03\xF5\x82"},
  {0x40, 0xA0, 0x15BE, 0x0000, 0x0010, 0x0010,
   "\xE4\x34\xE0\xF5\x83\xEF\xF0\xE5\x0F\xAE\x05\x0D\x74\x03\x2E\xF5"},
  {0x40, 0xA0, 0x15CE, 0x0000, 0x0010, 0x0010,
   "\x82\xE4\x34\xE0\xF5\x83\xE5\x0F\xF0\xAF\x1C\x7A\xE0\x7B\x03\x12"},
  {0x40, 0xA0, 0x15DE, 0x0000, 0x000D, 0x000D,
   "\x17\x20\xAF\x1C\xAD\x10\xAB\x12\xAA\x11\x12\x17\x04"},
  {0x40, 0xA0, 0x15EB, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x166E, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\xD2"},
  {0x40, 0xA0, 0x167E, 0x0000, 0x0010, 0x0010,
   "\x00\x53\x91\xEF\x90\x7F\xAB\x74\x01\xF0\xD0\x86\xD0\x84\xD0\x85"},
  {0x40, 0xA0, 0x168E, 0x0000, 0x0007, 0x0007,
   "\xD0\x82\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x1644, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\x90"},
  {0x40, 0xA0, 0x1654, 0x0000, 0x0010, 0x0010,
   "\x7F\xC4\xE4\xF0\x53\x91\xEF\x90\x7F\xAB\x74\x04\xF0\xD0\x86\xD0"},
  {0x40, 0xA0, 0x1664, 0x0000, 0x000A, 0x000A,
   "\x84\xD0\x85\xD0\x82\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x1695, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\x53"},
  {0x40, 0xA0, 0x16A5, 0x0000, 0x0010, 0x0010,
   "\x91\xEF\x90\x7F\xAB\x74\x02\xF0\xD0\x86\xD0\x84\xD0\x85\xD0\x82"},
  {0x40, 0xA0, 0x16B5, 0x0000, 0x0005, 0x0005, "\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x16BA, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\x53"},
  {0x40, 0xA0, 0x16CA, 0x0000, 0x0010, 0x0010,
   "\x91\xEF\x90\x7F\xAB\x74\x10\xF0\xD0\x86\xD0\x84\xD0\x85\xD0\x82"},
  {0x40, 0xA0, 0x16DA, 0x0000, 0x0005, 0x0005, "\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x14FF, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x16DF, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\x53"},
  {0x40, 0xA0, 0x16EF, 0x0000, 0x0010, 0x0010,
   "\x91\xEF\x90\x7F\xAB\x74\x08\xF0\xD0\x86\xD0\x84\xD0\x85\xD0\x82"},
  {0x40, 0xA0, 0x16FF, 0x0000, 0x0005, 0x0005, "\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x1767, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x1768, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x1769, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x176A, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x176B, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x176C, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x176D, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x176E, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x176F, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x1770, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x1771, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x1772, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x1773, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x1774, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x1775, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x1776, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0043, 0x0000, 0x0003, 0x0003, "\x02\x15\x00"},
  {0x40, 0xA0, 0x1500, 0x0000, 0x0010, 0x0010,
   "\x02\x16\x6E\x00\x02\x16\x95\x00\x02\x16\x44\x00\x02\x16\xDF\x00"},
  {0x40, 0xA0, 0x1510, 0x0000, 0x0010, 0x0010,
   "\x02\x16\xBA\x00\x02\x14\xFF\x00\x02\x17\x67\x00\x02\x17\x68\x00"},
  {0x40, 0xA0, 0x1520, 0x0000, 0x0010, 0x0010,
   "\x02\x17\x69\x00\x02\x17\x6A\x00\x02\x17\x6B\x00\x02\x17\x6C\x00"},
  {0x40, 0xA0, 0x1530, 0x0000, 0x0010, 0x0010,
   "\x02\x17\x6D\x00\x02\x17\x6E\x00\x02\x17\x6F\x00\x02\x17\x70\x00"},
  {0x40, 0xA0, 0x1540, 0x0000, 0x0010, 0x0010,
   "\x02\x17\x71\x00\x02\x17\x72\x00\x02\x17\x73\x00\x02\x17\x74\x00"},
  {0x40, 0xA0, 0x1550, 0x0000, 0x0008, 0x0008,
   "\x02\x17\x75\x00\x02\x17\x76\x00"},
  {0x40, 0xA0, 0x173C, 0x0000, 0x0010, 0x0010,
   "\x8E\x14\x8F\x15\xE5\x15\x15\x15\xAE\x14\x70\x02\x15\x14\x4E\x60"},
  {0x40, 0xA0, 0x174C, 0x0000, 0x0007, 0x0007,
   "\x05\x12\x14\xEE\x80\xEE\x22"},
  {0x40, 0xA0, 0x175F, 0x0000, 0x0008, 0x0008,
   "\xE4\xF5\x1B\xD2\xE9\xD2\xAF\x22"},
  {0x40, 0xA0, 0x1619, 0x0000, 0x0010, 0x0010,
   "\xA9\x07\xE5\x1B\x70\x23\x90\x7F\xA5\xE0\x44\x80\xF0\xE9\x25\xE0"},
  {0x40, 0xA0, 0x1629, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xA6\xF0\x8D\x16\xAF\x03\xA9\x07\x75\x17\x01\x8A\x18\x89"},
  {0x40, 0xA0, 0x1639, 0x0000, 0x000B, 0x000B,
   "\x19\xE4\xF5\x1A\x75\x1B\x01\xD3\x22\xC3\x22"},
  {0x40, 0xA0, 0x15EC, 0x0000, 0x0010, 0x0010,
   "\xA9\x07\xE5\x1B\x70\x25\x90\x7F\xA5\xE0\x44\x80\xF0\xE9\x25\xE0"},
  {0x40, 0xA0, 0x15FC, 0x0000, 0x0010, 0x0010,
   "\x44\x01\x90\x7F\xA6\xF0\x8D\x16\xAF\x03\xA9\x07\x75\x17\x01\x8A"},
  {0x40, 0xA0, 0x160C, 0x0000, 0x000D, 0x000D,
   "\x18\x89\x19\xE4\xF5\x1A\x75\x1B\x03\xD3\x22\xC3\x22"},
  {0x40, 0xA0, 0x004B, 0x0000, 0x0003, 0x0003, "\x02\x13\x7F"},
  {0x40, 0xA0, 0x137F, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\xC0"},
  {0x40, 0xA0, 0x138F, 0x0000, 0x0010, 0x0010,
   "\xD0\x75\xD0\x00\xC0\x00\xC0\x01\xC0\x02\xC0\x03\xC0\x06\xC0\x07"},
  {0x40, 0xA0, 0x139F, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xA5\xE0\x30\xE2\x06\x75\x1B\x06\x02\x14\x4E\x90\x7F\xA5"},
  {0x40, 0xA0, 0x13AF, 0x0000, 0x0010, 0x0010,
   "\xE0\x20\xE1\x0C\xE5\x1B\x64\x02\x60\x06\x75\x1B\x07\x02\x14\x4E"},
  {0x40, 0xA0, 0x13BF, 0x0000, 0x0010, 0x0010,
   "\xAF\x1B\xEF\x24\xFE\x60\x48\x14\x60\x2C\x24\xFE\x60\x77\x24\x04"},
  {0x40, 0xA0, 0x13CF, 0x0000, 0x0010, 0x0010,
   "\x60\x03\x02\x14\x4E\xAB\x17\xAA\x18\xA9\x19\xAF\x1A\x05\x1A\x8F"},
  {0x40, 0xA0, 0x13DF, 0x0000, 0x0010, 0x0010,
   "\x82\x75\x83\x00\x12\x12\x4B\x90\x7F\xA6\xF0\xE5\x1A\x65\x16\x70"},
  {0x40, 0xA0, 0x13EF, 0x0000, 0x0010, 0x0010,
   "\x5E\x75\x1B\x05\x80\x59\x90\x7F\xA6\xE0\xAB\x17\xAA\x18\xA9\x19"},
  {0x40, 0xA0, 0x13FF, 0x0000, 0x0010, 0x0010,
   "\xAE\x1A\x8E\x82\x75\x83\x00\x12\x12\x78\x75\x1B\x02\x80\x40\xE5"},
  {0x40, 0xA0, 0x140F, 0x0000, 0x0010, 0x0010,
   "\x16\x24\xFE\xB5\x1A\x07\x90\x7F\xA5\xE0\x44\x20\xF0\xE5\x16\x14"},
  {0x40, 0xA0, 0x141F, 0x0000, 0x0010, 0x0010,
   "\xB5\x1A\x0A\x90\x7F\xA5\xE0\x44\x40\xF0\x75\x1B\x00\x90\x7F\xA6"},
  {0x40, 0xA0, 0x142F, 0x0000, 0x0010, 0x0010,
   "\xE0\xAB\x17\xAA\x18\xA9\x19\xAE\x1A\x8E\x82\x75\x83\x00\x12\x12"},
  {0x40, 0xA0, 0x143F, 0x0000, 0x0010, 0x0010,
   "\x78\x05\x1A\x80\x0A\x90\x7F\xA5\xE0\x44\x40\xF0\x75\x1B\x00\x53"},
  {0x40, 0xA0, 0x144F, 0x0000, 0x0010, 0x0010,
   "\x91\xDF\xD0\x07\xD0\x06\xD0\x03\xD0\x02\xD0\x01\xD0\x00\xD0\xD0"},
  {0x40, 0xA0, 0x145F, 0x0000, 0x000D, 0x000D,
   "\xD0\x86\xD0\x84\xD0\x85\xD0\x82\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x1704, 0x0000, 0x0010, 0x0010,
   "\x12\x15\xEC\xE5\x1B\x24\xFA\x60\x0E\x14\x60\x06\x24\x07\x70\xF3"},
  {0x40, 0xA0, 0x1714, 0x0000, 0x000C, 0x000C,
   "\xD3\x22\xE4\xF5\x1B\xD3\x22\xE4\xF5\x1B\xD3\x22"},
  {0x40, 0xA0, 0x1720, 0x0000, 0x0010, 0x0010,
   "\x12\x16\x19\xE5\x1B\x24\xFA\x60\x0E\x14\x60\x06\x24\x07\x70\xF3"},
  {0x40, 0xA0, 0x1730, 0x0000, 0x000C, 0x000C,
   "\xD3\x22\xE4\xF5\x1B\xD3\x22\xE4\xF5\x1B\xD3\x22"},
  {0x40, 0xA0, 0x14EE, 0x0000, 0x0010, 0x0010,
   "\x74\x00\xF5\x86\x90\xFD\xA5\x7C\x05\xA3\xE5\x82\x45\x83\x70\xF9"},
  {0x40, 0xA0, 0x14FE, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x0000, 0x0000, 0x0003, 0x0003, "\x02\x17\x53"},
  {0x40, 0xA0, 0x1753, 0x0000, 0x000C, 0x000C,
   "\x78\x7F\xE4\xF6\xD8\xFD\x75\x81\x20\x02\x14\x6C"},
  {0x40, 0xA0, 0x124B, 0x0000, 0x0010, 0x0010,
   "\xBB\x01\x0C\xE5\x82\x29\xF5\x82\xE5\x83\x3A\xF5\x83\xE0\x22\x50"},
  {0x40, 0xA0, 0x125B, 0x0000, 0x0010, 0x0010,
   "\x06\xE9\x25\x82\xF8\xE6\x22\xBB\xFE\x06\xE9\x25\x82\xF8\xE2\x22"},
  {0x40, 0xA0, 0x126B, 0x0000, 0x000D, 0x000D,
   "\xE5\x82\x29\xF5\x82\xE5\x83\x3A\xF5\x83\xE4\x93\x22"},
  {0x40, 0xA0, 0x1278, 0x0000, 0x0010, 0x0010,
   "\xF8\xBB\x01\x0D\xE5\x82\x29\xF5\x82\xE5\x83\x3A\xF5\x83\xE8\xF0"},
  {0x40, 0xA0, 0x1288, 0x0000, 0x0010, 0x0010,
   "\x22\x50\x06\xE9\x25\x82\xC8\xF6\x22\xBB\xFE\x05\xE9\x25\x82\xC8"},
  {0x40, 0xA0, 0x1298, 0x0000, 0x0002, 0x0002, "\xF2\x22"},
  {0x40, 0xA0, 0x129A, 0x0000, 0x0010, 0x0010,
   "\xE7\x09\xF6\x08\xDF\xFA\x80\x46\xE7\x09\xF2\x08\xDF\xFA\x80\x3E"},
  {0x40, 0xA0, 0x12AA, 0x0000, 0x0010, 0x0010,
   "\x88\x82\x8C\x83\xE7\x09\xF0\xA3\xDF\xFA\x80\x32\xE3\x09\xF6\x08"},
  {0x40, 0xA0, 0x12BA, 0x0000, 0x0010, 0x0010,
   "\xDF\xFA\x80\x6E\xE3\x09\xF2\x08\xDF\xFA\x80\x66\x88\x82\x8C\x83"},
  {0x40, 0xA0, 0x12CA, 0x0000, 0x0010, 0x0010,
   "\xE3\x09\xF0\xA3\xDF\xFA\x80\x5A\x89\x82\x8A\x83\xE0\xA3\xF6\x08"},
  {0x40, 0xA0, 0x12DA, 0x0000, 0x0010, 0x0010,
   "\xDF\xFA\x80\x4E\x89\x82\x8A\x83\xE0\xA3\xF2\x08\xDF\xFA\x80\x42"},
  {0x40, 0xA0, 0x12EA, 0x0000, 0x0010, 0x0010,
   "\x80\xD2\x80\xFA\x80\xC6\x80\xD4\x80\x55\x80\xF2\x80\x29\x80\x10"},
  {0x40, 0xA0, 0x12FA, 0x0000, 0x0010, 0x0010,
   "\x80\xA6\x80\xEA\x80\x9A\x80\xA8\x80\xDA\x80\xE2\x80\xCA\x80\x29"},
  {0x40, 0xA0, 0x130A, 0x0000, 0x0010, 0x0010,
   "\x88\x84\x8C\x85\x89\x82\x8A\x83\xE4\x93\xA3\x05\x86\xF0\xA3\x05"},
  {0x40, 0xA0, 0x131A, 0x0000, 0x0010, 0x0010,
   "\x86\xDF\xF5\xDE\xF3\x80\x0B\x89\x82\x8A\x83\xE4\x93\xA3\xF6\x08"},
  {0x40, 0xA0, 0x132A, 0x0000, 0x0010, 0x0010,
   "\xDF\xF9\xEC\xFA\xA9\xF0\xED\xFB\x22\x88\x84\x8C\x85\x89\x82\x8A"},
  {0x40, 0xA0, 0x133A, 0x0000, 0x0010, 0x0010,
   "\x83\xE0\xA3\x05\x86\xF0\xA3\x05\x86\xDF\xF6\xDE\xF4\x80\xE3\x89"},
  {0x40, 0xA0, 0x134A, 0x0000, 0x0010, 0x0010,
   "\x82\x8A\x83\xE4\x93\xA3\xF2\x08\xDF\xF9\x80\xD6\x88\xF0\xED\x24"},
  {0x40, 0xA0, 0x135A, 0x0000, 0x0010, 0x0010,
   "\x02\xB4\x04\x00\x50\xCC\xF5\x82\xEB\x24\x02\xB4\x04\x00\x50\xC2"},
  {0x40, 0xA0, 0x136A, 0x0000, 0x0010, 0x0010,
   "\x23\x23\x45\x82\xF5\x82\xEF\x4E\x60\xB8\xEF\x60\x01\x0E\xE5\x82"},
  {0x40, 0xA0, 0x137A, 0x0000, 0x0005, 0x0005, "\x23\x90\x12\xEA\x73"},
  {0x40, 0xA0, 0x7F92, 0x0000, 0x0001, 0x0001, "\x00"},
  {0x40, 0xA0, 0x7F92, 0x0000, 0x0001, 0x0001, "\x01"},
  {0x40, 0xA0, 0x0100, 0x0000, 0x0010, 0x0010,
   "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"},
  {0x40, 0xA0, 0x0110, 0x0000, 0x0010, 0x0010,
   "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"},
  {0x40, 0xA0, 0x0120, 0x0000, 0x0010, 0x0010,
   "\x4D\x69\x64\x69\x6D\x61\x6E\x20\x55\x53\x42\x20\x4D\x69\x64\x69"},
  {0x40, 0xA0, 0x0130, 0x0000, 0x0010, 0x0010,
   "\x53\x70\x6F\x72\x74\x20\x32\x78\x32\x20\x20\x20\x20\x20\x20\x20"},
  {0x40, 0xA0, 0x0140, 0x0000, 0x0010, 0x0010,
   "\x46\x69\x72\x6D\x77\x61\x72\x65\x20\x52\x65\x6C\x65\x61\x73\x65"},
  {0x40, 0xA0, 0x0150, 0x0000, 0x0010, 0x0010,
   "\x20\x31\x2E\x32\x31\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"},
  {0x40, 0xA0, 0x0160, 0x0000, 0x0010, 0x0010,
   "\x28\x63\x29\x20\x31\x39\x39\x39\x2D\x32\x30\x30\x31\x2C\x20\x4D"},
  {0x40, 0xA0, 0x0170, 0x0000, 0x0010, 0x0010,
   "\x69\x64\x69\x6D\x61\x6E\x20\x49\x6E\x63\x2E\x20\x20\x20\x20\x20"},
  {0x40, 0xA0, 0x0180, 0x0000, 0x0010, 0x0010,
   "\x41\x6C\x6C\x20\x72\x69\x67\x68\x74\x73\x20\x72\x65\x73\x65\x72"},
  {0x40, 0xA0, 0x0190, 0x0000, 0x0010, 0x0010,
   "\x76\x65\x64\x2E\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"},
  {0x40, 0xA0, 0x01A0, 0x0000, 0x0010, 0x0010,
   "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"},
  {0x40, 0xA0, 0x01B0, 0x0000, 0x0010, 0x0010,
   "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"},
  {0x40, 0xA0, 0x0962, 0x0000, 0x0003, 0x0003, "\x01\x40\x00"},
  {0x40, 0xA0, 0x041B, 0x0000, 0x0010, 0x0010,
   "\xC2\x01\xC2\x00\xC2\x05\xC2\x04\x12\x0A\xBA\xD2\xE8\x43\xD8\x20"},
  {0x40, 0xA0, 0x042B, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xAB\x74\xFF\xF0\x90\x7F\xA9\xF0\x90\x7F\xAA\xF0\x53\x91"},
  {0x40, 0xA0, 0x043B, 0x0000, 0x0010, 0x0010,
   "\xEF\x90\x7F\x95\xE0\x44\xC0\xF0\x90\x7F\xAF\xE0\x44\x01\xF0\x90"},
  {0x40, 0xA0, 0x044B, 0x0000, 0x0010, 0x0010,
   "\x7F\xAE\xE0\x44\x1D\xF0\x90\x7F\x92\xE0\x44\x02\xF0\x90\x7F\x94"},
  {0x40, 0xA0, 0x045B, 0x0000, 0x0010, 0x0010,
   "\xE0\x44\x04\xF0\x90\x7F\x9D\xE0\x54\xFB\xF0\x90\x7F\x95\xE0\x44"},
  {0x40, 0xA0, 0x046B, 0x0000, 0x0010, 0x0010,
   "\x01\xF0\x90\x7F\x9E\xE0\x54\xFE\xF0\x90\x7F\x94\xE0\x44\x08\xF0"},
  {0x40, 0xA0, 0x047B, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\x9D\xE0\x44\x08\xF0\x90\x7F\x95\xE0\x44\x02\xF0\x90\x7F"},
  {0x40, 0xA0, 0x048B, 0x0000, 0x0010, 0x0010,
   "\x9E\xE0\x44\x02\xF0\x90\x7F\x95\xE0\x54\x83\xF0\x90\x7F\x9E\xE0"},
  {0x40, 0xA0, 0x049B, 0x0000, 0x0010, 0x0010,
   "\x44\x7C\xF0\x90\x7F\x94\xE0\x54\xFE\xF0\x90\x7F\x9D\xE0\x44\x01"},
  {0x40, 0xA0, 0x04AB, 0x0000, 0x0010, 0x0010,
   "\xF0\x90\x7F\x9A\xE0\x44\x01\x90\x7F\x97\xF0\x43\x08\x20\x43\x08"},
  {0x40, 0xA0, 0x04BB, 0x0000, 0x0010, 0x0010,
   "\x08\x43\x08\x10\x43\x08\x04\x43\x08\x40\x53\x89\xF0\xE4\xF5\x8C"},
  {0x40, 0xA0, 0x04CB, 0x0000, 0x0010, 0x0010,
   "\xF5\x8A\xD2\x8C\xD2\xA9\x12\x00\x36\xD2\xAF\xE5\x89\x54\x0F\x24"},
  {0x40, 0xA0, 0x04DB, 0x0000, 0x0010, 0x0010,
   "\x20\xF5\x89\x75\x8D\xFE\x75\x8B\xFE\xD2\x8E\xC2\xAC\x75\x98\x50"},
  {0x40, 0xA0, 0x04EB, 0x0000, 0x0010, 0x0010,
   "\xC2\x98\xC2\x99\xD2\xAC\xC2\xAE\x75\xC0\x50\xC2\xC0\xC2\xC1\xD2"},
  {0x40, 0xA0, 0x04FB, 0x0000, 0x0010, 0x0010,
   "\xAE\x53\x08\xDF\x53\x08\xEF\x53\x08\xF7\x53\x08\xFB\x53\x08\xBF"},
  {0x40, 0xA0, 0x050B, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\x9A\xE0\x54\xFE\x90\x7F\x97\xF0\x90\x7F\x98\xE5\x08\xF0"},
  {0x40, 0xA0, 0x051B, 0x0000, 0x0010, 0x0010,
   "\x75\x0D\x3D\xE5\x0D\x70\xFC\x43\x08\x20\x43\x08\x10\x43\x08\x08"},
  {0x40, 0xA0, 0x052B, 0x0000, 0x0010, 0x0010,
   "\x43\x08\x04\x43\x08\x40\x90\x7F\x98\xE5\x08\xF0\x20\x01\x11\x75"},
  {0x40, 0xA0, 0x053B, 0x0000, 0x0010, 0x0010,
   "\x0D\xF4\xE5\x0D\x70\xFC\x20\x01\xF3\xD2\x07\x12\x0C\x21\x80\xEC"},
  {0x40, 0xA0, 0x054B, 0x0000, 0x0010, 0x0010,
   "\x30\x01\x0C\x12\x02\x0D\xC2\x01\x90\x7F\xAE\xE0\x44\x02\xF0\x30"},
  {0x40, 0xA0, 0x055B, 0x0000, 0x0010, 0x0010,
   "\x05\x1A\x12\x0A\xF4\x50\x13\x12\x0C\x46\x20\x04\x07\x90\x7F\xD6"},
  {0x40, 0xA0, 0x056B, 0x0000, 0x0010, 0x0010,
   "\xE0\x20\xE7\xF3\x12\x0C\x67\x12\x00\x41\xC2\x05\x05\x40\xE5\x40"},
  {0x40, 0xA0, 0x057B, 0x0000, 0x0010, 0x0010,
   "\xC3\x94\x08\x40\x03\xE4\xF5\x40\xE5\x40\x75\xF0\x03\xA4\x24\x23"},
  {0x40, 0xA0, 0x058B, 0x0000, 0x000C, 0x000C,
   "\xF8\x08\xE6\xFA\x08\xE6\xF9\x12\x07\xEC\x80\xB4"},
  {0x40, 0xA0, 0x0597, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x0033, 0x0000, 0x0003, 0x0003, "\x02\x00\x1F"},
  {0x40, 0xA0, 0x001F, 0x0000, 0x0004, 0x0004, "\x53\xD8\xEF\x32"},
  {0x40, 0xA0, 0x0023, 0x0000, 0x0003, 0x0003, "\x02\x08\x6E"},
  {0x40, 0xA0, 0x086E, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\xC0"},
  {0x40, 0xA0, 0x087E, 0x0000, 0x000C, 0x000C,
   "\xD0\x75\xD0\x00\xC0\x00\xC0\x05\xC0\x06\xC0\x07"},
  {0x40, 0xA0, 0x088A, 0x0000, 0x0010, 0x0010,
   "\x30\x99\x23\xC2\x99\xE5\x14\x60\x1B\xAF\x11\x05\x11\x74\x00\x2F"},
  {0x40, 0xA0, 0x089A, 0x0000, 0x0010, 0x0010,
   "\xF5\x82\xE4\x34\x0E\xF5\x83\xE0\xF5\x99\x15\x14\x53\x08\xEF\x75"},
  {0x40, 0xA0, 0x08AA, 0x0000, 0x0010, 0x0010,
   "\x0B\x0C\x80\x02\xD2\x02\x30\x98\x1E\xC2\x98\xAF\x99\xE5\x10\x04"},
  {0x40, 0xA0, 0x08BA, 0x0000, 0x0010, 0x0010,
   "\x54\x3F\xFE\x65\x0E\x60\x0A\xAD\x10\x74\x42\x2D\xF8\xA6\x07\x8E"},
  {0x40, 0xA0, 0x08CA, 0x0000, 0x0007, 0x0007,
   "\x10\x53\x08\xDF\x75\x09\x0C"},
  {0x40, 0xA0, 0x08D1, 0x0000, 0x0010, 0x0010,
   "\xD0\x07\xD0\x06\xD0\x05\xD0\x00\xD0\xD0\xD0\x86\xD0\x84\xD0\x85"},
  {0x40, 0xA0, 0x08E1, 0x0000, 0x0007, 0x0007,
   "\xD0\x82\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x003B, 0x0000, 0x0003, 0x0003, "\x02\x08\xE8"},
  {0x40, 0xA0, 0x08E8, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\xC0"},
  {0x40, 0xA0, 0x08F8, 0x0000, 0x000C, 0x000C,
   "\xD0\x75\xD0\x00\xC0\x00\xC0\x05\xC0\x06\xC0\x07"},
  {0x40, 0xA0, 0x0904, 0x0000, 0x0010, 0x0010,
   "\x30\xC1\x23\xC2\xC1\xE5\x15\x60\x1B\xAF\x13\x05\x13\x74\x00\x2F"},
  {0x40, 0xA0, 0x0914, 0x0000, 0x0010, 0x0010,
   "\xF5\x82\xE4\x34\x0F\xF5\x83\xE0\xF5\xC1\x15\x15\x53\x08\xFB\x75"},
  {0x40, 0xA0, 0x0924, 0x0000, 0x0010, 0x0010,
   "\x0C\x0C\x80\x02\xD2\x03\x30\xC0\x1E\xC2\xC0\xAF\xC1\xE5\x12\x04"},
  {0x40, 0xA0, 0x0934, 0x0000, 0x0010, 0x0010,
   "\x54\x3F\xFE\x65\x0F\x60\x0A\xAD\x12\x74\x82\x2D\xF8\xA6\x07\x8E"},
  {0x40, 0xA0, 0x0944, 0x0000, 0x0007, 0x0007,
   "\x12\x53\x08\xF7\x75\x0A\x0C"},
  {0x40, 0xA0, 0x094B, 0x0000, 0x0010, 0x0010,
   "\xD0\x07\xD0\x06\xD0\x05\xD0\x00\xD0\xD0\xD0\x86\xD0\x84\xD0\x85"},
  {0x40, 0xA0, 0x095B, 0x0000, 0x0007, 0x0007,
   "\xD0\x82\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x00D2, 0x0000, 0x0010, 0x0010,
   "\xA2\xAC\x92\x07\xC2\xAC\x30\x02\x0C\xC2\x02\x8F\x99\x53\x08\xEF"},
  {0x40, 0xA0, 0x00E2, 0x0000, 0x0010, 0x0010,
   "\x75\x0B\x0C\x80\x12\xAE\x16\x05\x16\x74\x00\x2E\xF5\x82\xE4\x34"},
  {0x40, 0xA0, 0x00F2, 0x0000, 0x000B, 0x000B,
   "\x0E\xF5\x83\xEF\xF0\x05\x14\xA2\x07\x92\xAC"},
  {0x40, 0xA0, 0x00FD, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x0B58, 0x0000, 0x0010, 0x0010,
   "\xA2\xAE\x92\x07\xC2\xAE\x30\x03\x0C\xC2\x03\x8F\xC1\x53\x08\xFB"},
  {0x40, 0xA0, 0x0B68, 0x0000, 0x0010, 0x0010,
   "\x75\x0C\x0C\x80\x12\xAE\x17\x05\x17\x74\x00\x2E\xF5\x82\xE4\x34"},
  {0x40, 0xA0, 0x0B78, 0x0000, 0x000B, 0x000B,
   "\x0F\xF5\x83\xEF\xF0\x05\x15\xA2\x07\x92\xAE"},
  {0x40, 0xA0, 0x0B83, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x01C0, 0x0000, 0x0010, 0x0010,
   "\x12\x01\x00\x01\x00\x00\x00\x40\x63\x07\x02\x10\x21\x01\x00\x00"},
  {0x40, 0xA0, 0x01D0, 0x0000, 0x0010, 0x0010,
   "\x00\x01\x09\x02\x35\x00\x01\x01\x00\xA0\x00\x09\x04\x00\x00\x05"},
  {0x40, 0xA0, 0x01E0, 0x0000, 0x0010, 0x0010,
   "\xFF\x00\x00\x00\x07\x05\x81\x03\x20\x00\x01\x07\x05\x82\x02\x20"},
  {0x40, 0xA0, 0x01F0, 0x0000, 0x0010, 0x0010,
   "\x00\x00\x07\x05\x02\x02\x20\x00\x00\x07\x05\x84\x02\x20\x00\x00"},
  {0x40, 0xA0, 0x0200, 0x0000, 0x000D, 0x000D,
   "\x07\x05\x04\x02\x20\x00\x00\x04\x03\x09\x04\x00\x00"},
  {0x40, 0xA0, 0x0965, 0x0000, 0x0010, 0x0010,
   "\x01\x0D\x00\xC1\x01\x01\x09\x00\x01\x0A\x00\x01\x08\xFF\x01\x0B"},
  {0x40, 0xA0, 0x0975, 0x0000, 0x0010, 0x0010,
   "\x00\x01\x0C\x00\xC1\x82\xC1\x83\x01\x0E\x00\x01\x10\x00\x01\x0F"},
  {0x40, 0xA0, 0x0985, 0x0000, 0x0010, 0x0010,
   "\x00\x01\x12\x00\x01\x11\x00\x01\x16\x00\x01\x14\x00\x01\x13\x00"},
  {0x40, 0xA0, 0x0995, 0x0000, 0x0006, 0x0006, "\x01\x17\x00\x01\x15\x00"},
  {0x40, 0xA0, 0x0043, 0x0000, 0x0003, 0x0003, "\x02\x0B\x00"},
  {0x40, 0xA0, 0x0B00, 0x0000, 0x0010, 0x0010,
   "\x02\x0B\xAE\x00\x02\x09\xCA\x00\x02\x0B\x84\x00\x02\x0B\xD5\x00"},
  {0x40, 0xA0, 0x0B10, 0x0000, 0x0010, 0x0010,
   "\x02\x0B\xFC\x00\x02\x00\x3A\x00\x02\x0A\xFF\x00\x02\x0C\xC2\x00"},
  {0x40, 0xA0, 0x0B20, 0x0000, 0x0010, 0x0010,
   "\x02\x0C\xC3\x00\x02\x0C\xC4\x00\x02\x0C\xC5\x00\x02\x0C\xC6\x00"},
  {0x40, 0xA0, 0x0B30, 0x0000, 0x0010, 0x0010,
   "\x02\x0C\xC7\x00\x02\x0C\xC8\x00\x02\x0C\xC9\x00\x02\x0C\xCA\x00"},
  {0x40, 0xA0, 0x0B40, 0x0000, 0x0010, 0x0010,
   "\x02\x0C\xCB\x00\x02\x0C\xCC\x00\x02\x0C\xCD\x00\x02\x0C\xCE\x00"},
  {0x40, 0xA0, 0x0B50, 0x0000, 0x0008, 0x0008,
   "\x02\x0C\xCF\x00\x02\x0C\xD0\x00"},
  {0x40, 0xA0, 0x099B, 0x0000, 0x0010, 0x0010,
   "\x18\x23\xFF\x05\x98\xFF\x06\x58\xFF\x06\xE3\xFF\x07\xF2\xFF\x05"},
  {0x40, 0xA0, 0x09AB, 0x0000, 0x0010, 0x0010,
   "\x98\xFF\x06\x58\xFF\x06\xE3\xFF\x00\x0E\x01\x21\xFF\x01\x22\x00"},
  {0x40, 0xA0, 0x0598, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xB6\xE0\x30\xE1\x03\x02\x06\x57\x7A\x7E\x79\x80\x7E\x7E"},
  {0x40, 0xA0, 0x05A8, 0x0000, 0x0010, 0x0010,
   "\x7F\x80\x74\x7E\x90\x7F\xE3\xF0\x74\x80\x90\x7F\xE4\xF0\xE4\xFF"},
  {0x40, 0xA0, 0x05B8, 0x0000, 0x0010, 0x0010,
   "\xE5\x10\x65\x0E\x60\x43\xEF\xC3\x94\x04\x50\x3D\xE4\xFD\xE5\x10"},
  {0x40, 0xA0, 0x05C8, 0x0000, 0x0010, 0x0010,
   "\x65\x0E\x60\x1B\xED\xC3\x94\x03\x50\x15\x74\x42\x25\x0E\xF8\xE6"},
  {0x40, 0xA0, 0x05D8, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xE5\xF0\x05\x0E\xE5\x0E\x54\x3F\xF5\x0E\x0D\x80\xDF\xED"},
  {0x40, 0xA0, 0x05E8, 0x0000, 0x0010, 0x0010,
   "\x60\xCE\xFC\xEC\xC3\x94\x03\x50\x08\xE4\x90\x7F\xE5\xF0\x0C\x80"},
  {0x40, 0xA0, 0x05F8, 0x0000, 0x0010, 0x0010,
   "\xF2\x90\x7F\xE5\xED\xF0\x0F\x80\xB7\xE5\x12\x65\x0F\x60\x45\xEF"},
  {0x40, 0xA0, 0x0608, 0x0000, 0x0010, 0x0010,
   "\xC3\x94\x08\x50\x3F\xE4\xFD\xE5\x12\x65\x0F\x60\x1B\xED\xC3\x94"},
  {0x40, 0xA0, 0x0618, 0x0000, 0x0010, 0x0010,
   "\x03\x50\x15\x74\x82\x25\x0F\xF8\xE6\x90\x7F\xE5\xF0\x05\x0F\xE5"},
  {0x40, 0xA0, 0x0628, 0x0000, 0x0010, 0x0010,
   "\x0F\x54\x3F\xF5\x0F\x0D\x80\xDF\xED\x60\xCE\xFC\xEC\xC3\x94\x03"},
  {0x40, 0xA0, 0x0638, 0x0000, 0x0010, 0x0010,
   "\x50\x08\xE4\x90\x7F\xE5\xF0\x0C\x80\xF2\xED\x24\x10\x90\x7F\xE5"},
  {0x40, 0xA0, 0x0648, 0x0000, 0x000F, 0x000F,
   "\xF0\x0F\x80\xB5\xEF\x60\x08\x25\xE0\x25\xE0\x90\x7F\xB7\xF0"},
  {0x40, 0xA0, 0x0657, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x07F2, 0x0000, 0x0010, 0x0010,
   "\xE5\x21\x60\x1C\x14\x60\x30\x14\x60\x44\x14\x60\x58\x80\x00\x12"},
  {0x40, 0xA0, 0x0802, 0x0000, 0x0010, 0x0010,
   "\x00\x3E\xEF\x65\x22\x60\x64\x12\x00\x3E\x8F\x22\xE4\xF5\x21\x22"},
  {0x40, 0xA0, 0x0812, 0x0000, 0x0010, 0x0010,
   "\xE5\x09\x60\x10\xD5\x09\x0D\xA2\xAF\x92\x07\xC2\xAF\x43\x08\x20"},
  {0x40, 0xA0, 0x0822, 0x0000, 0x0010, 0x0010,
   "\xA2\x07\x92\xAF\x05\x21\x22\xE5\x0A\x60\x10\xD5\x0A\x0D\xA2\xAF"},
  {0x40, 0xA0, 0x0832, 0x0000, 0x0010, 0x0010,
   "\x92\x07\xC2\xAF\x43\x08\x08\xA2\x07\x92\xAF\x05\x21\x22\xE5\x0B"},
  {0x40, 0xA0, 0x0842, 0x0000, 0x0010, 0x0010,
   "\x60\x10\xD5\x0B\x0D\xA2\xAF\x92\x07\xC2\xAF\x43\x08\x10\xA2\x07"},
  {0x40, 0xA0, 0x0852, 0x0000, 0x0010, 0x0010,
   "\x92\xAF\x05\x21\x22\xE5\x0C\x60\x10\xD5\x0C\x0D\xA2\xAF\x92\x07"},
  {0x40, 0xA0, 0x0862, 0x0000, 0x000B, 0x000B,
   "\xC2\xAF\x43\x08\x04\xA2\x07\x92\xAF\x05\x21"},
  {0x40, 0xA0, 0x086D, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x000E, 0x0000, 0x0010, 0x0010,
   "\xA2\xAF\x92\x07\xC2\xAF\x90\x7F\x98\xE5\x08\xF0\xA2\x07\x92\xAF"},
  {0x40, 0xA0, 0x001E, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x0658, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xC8\xE0\x30\xE1\x03\x02\x06\xE2\x90\x7F\xC9\xE0\xF5\x18"},
  {0x40, 0xA0, 0x0668, 0x0000, 0x0010, 0x0010,
   "\xC3\xE4\x95\x14\xFF\x74\x01\x94\x00\xFE\xC3\xE5\x18\x9F\xE4\x9E"},
  {0x40, 0xA0, 0x0678, 0x0000, 0x0010, 0x0010,
   "\x50\x68\xE4\xF5\x19\xE5\x19\xC3\x95\x18\x50\x59\x74\xC3\x25\x19"},
  {0x40, 0xA0, 0x0688, 0x0000, 0x0010, 0x0010,
   "\xF5\x82\xE4\x34\x7D\xF5\x83\xE0\x54\x0F\xFD\x60\x48\x74\xC0\x25"},
  {0x40, 0xA0, 0x0698, 0x0000, 0x0010, 0x0010,
   "\x19\xF5\x82\xE4\x34\x7D\x90\x7F\xE3\xF0\x74\xC0\x25\x19\xF5\x82"},
  {0x40, 0xA0, 0x06A8, 0x0000, 0x0010, 0x0010,
   "\xE4\x34\x7D\xE5\x82\x90\x7F\xE4\xF0\xAF\x05\xED\x14\x60\x16\x14"},
  {0x40, 0xA0, 0x06B8, 0x0000, 0x0010, 0x0010,
   "\x60\x0B\x14\x70\x18\x90\x7F\xE5\xE0\xFF\x12\x00\xD2\x90\x7F\xE5"},
  {0x40, 0xA0, 0x06C8, 0x0000, 0x0010, 0x0010,
   "\xE0\xFF\x12\x00\xD2\x90\x7F\xE5\xE0\xFF\x12\x00\xD2\x74\x04\x25"},
  {0x40, 0xA0, 0x06D8, 0x0000, 0x000A, 0x000A,
   "\x19\xF5\x19\x80\xA0\xE4\x90\x7F\xC9\xF0"},
  {0x40, 0xA0, 0x06E2, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x06E3, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xCC\xE0\x30\xE1\x03\x02\x07\x6D\x90\x7F\xCD\xE0\xF5\x18"},
  {0x40, 0xA0, 0x06F3, 0x0000, 0x0010, 0x0010,
   "\xC3\xE4\x95\x15\xFF\x74\x01\x94\x00\xFE\xC3\xE5\x18\x9F\xE4\x9E"},
  {0x40, 0xA0, 0x0703, 0x0000, 0x0010, 0x0010,
   "\x50\x68\xE4\xF5\x19\xE5\x19\xC3\x95\x18\x50\x59\x74\xC3\x25\x19"},
  {0x40, 0xA0, 0x0713, 0x0000, 0x0010, 0x0010,
   "\xF5\x82\xE4\x34\x7C\xF5\x83\xE0\x54\x0F\xFD\x60\x48\x74\xC0\x25"},
  {0x40, 0xA0, 0x0723, 0x0000, 0x0010, 0x0010,
   "\x19\xF5\x82\xE4\x34\x7C\x90\x7F\xE3\xF0\x74\xC0\x25\x19\xF5\x82"},
  {0x40, 0xA0, 0x0733, 0x0000, 0x0010, 0x0010,
   "\xE4\x34\x7C\xE5\x82\x90\x7F\xE4\xF0\xAF\x05\xED\x14\x60\x16\x14"},
  {0x40, 0xA0, 0x0743, 0x0000, 0x0010, 0x0010,
   "\x60\x0B\x14\x70\x18\x90\x7F\xE5\xE0\xFF\x12\x0B\x58\x90\x7F\xE5"},
  {0x40, 0xA0, 0x0753, 0x0000, 0x0010, 0x0010,
   "\xE0\xFF\x12\x0B\x58\x90\x7F\xE5\xE0\xFF\x12\x0B\x58\x74\x04\x25"},
  {0x40, 0xA0, 0x0763, 0x0000, 0x000A, 0x000A,
   "\x19\xF5\x19\x80\xA0\xE4\x90\x7F\xCD\xF0"},
  {0x40, 0xA0, 0x076D, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x09BB, 0x0000, 0x0003, 0x0003, "\x01\x41\x00"},
  {0x40, 0xA0, 0x000B, 0x0000, 0x0003, 0x0003, "\x02\x00\x26"},
  {0x40, 0xA0, 0x0026, 0x0000, 0x000D, 0x000D,
   "\xC0\xE0\x05\x41\xE5\x0D\x60\x02\x15\x0D\xD0\xE0\x32"},
  {0x40, 0xA0, 0x003E, 0x0000, 0x0003, 0x0003, "\xAF\x41\x22"},
  {0x40, 0xA0, 0x0036, 0x0000, 0x0004, 0x0004, "\xE4\xF5\x41\x22"},
  {0x40, 0xA0, 0x09BE, 0x0000, 0x000B, 0x000B,
   "\x01\x3B\x01\x01\x3C\x01\xC1\x86\x01\x3D\x03"},
  {0x40, 0xA0, 0x020D, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xE9\xE0\x70\x03\x02\x02\xE2\x14\x70\x03\x02\x03\x5D\x24"},
  {0x40, 0xA0, 0x021D, 0x0000, 0x0010, 0x0010,
   "\xFE\x70\x03\x02\x03\xB6\x24\xFB\x70\x03\x02\x02\xDC\x14\x70\x03"},
  {0x40, 0xA0, 0x022D, 0x0000, 0x0010, 0x0010,
   "\x02\x02\xD6\x14\x70\x03\x02\x02\xCA\x14\x70\x03\x02\x02\xD0\x24"},
  {0x40, 0xA0, 0x023D, 0x0000, 0x0010, 0x0010,
   "\x05\x60\x03\x02\x04\x08\x12\x00\xFE\x40\x03\x02\x04\x13\x90\x7F"},
  {0x40, 0xA0, 0x024D, 0x0000, 0x0010, 0x0010,
   "\xEB\xE0\x24\xFE\x60\x16\x14\x60\x3F\x24\x02\x70\x67\x74\x01\x90"},
  {0x40, 0xA0, 0x025D, 0x0000, 0x0010, 0x0010,
   "\x7F\xD4\xF0\x74\xC0\x90\x7F\xD5\xF0\x02\x04\x13\x90\x7F\xEA\xE0"},
  {0x40, 0xA0, 0x026D, 0x0000, 0x0010, 0x0010,
   "\xFF\x12\x0A\x2A\x8B\x18\x8A\x19\x89\x1A\xEA\x49\x60\x11\xAE\x02"},
  {0x40, 0xA0, 0x027D, 0x0000, 0x0010, 0x0010,
   "\xEE\x90\x7F\xD4\xF0\xAF\x01\xEF\x90\x7F\xD5\xF0\x02\x04\x13\x90"},
  {0x40, 0xA0, 0x028D, 0x0000, 0x0010, 0x0010,
   "\x7F\xC4\x74\x01\xF0\x02\x04\x13\x90\x7F\xEA\xE0\xFF\x12\x0A\x79"},
  {0x40, 0xA0, 0x029D, 0x0000, 0x0010, 0x0010,
   "\x8B\x18\x8A\x19\x89\x1A\xEA\x49\x60\x11\xAE\x02\xEE\x90\x7F\xD4"},
  {0x40, 0xA0, 0x02AD, 0x0000, 0x0010, 0x0010,
   "\xF0\xAF\x01\xEF\x90\x7F\xD5\xF0\x02\x04\x13\x90\x7F\xC4\x74\x01"},
  {0x40, 0xA0, 0x02BD, 0x0000, 0x0010, 0x0010,
   "\xF0\x02\x04\x13\x90\x7F\xC4\x74\x01\xF0\x02\x04\x13\x12\x0C\xA6"},
  {0x40, 0xA0, 0x02CD, 0x0000, 0x0010, 0x0010,
   "\x02\x04\x13\x12\x0C\xB4\x02\x04\x13\x12\x00\x03\x02\x04\x13\x12"},
  {0x40, 0xA0, 0x02DD, 0x0000, 0x0010, 0x0010,
   "\x0C\x98\x02\x04\x13\x12\x0A\xFD\x40\x03\x02\x04\x13\x90\x7F\xE8"},
  {0x40, 0xA0, 0x02ED, 0x0000, 0x0010, 0x0010,
   "\xE0\x24\x7F\x60\x24\x14\x60\x31\x24\x02\x70\x5B\xA2\x04\xE4\x33"},
  {0x40, 0xA0, 0x02FD, 0x0000, 0x0010, 0x0010,
   "\xFF\x25\xE0\xFF\xA2\x00\xE4\x33\x4F\x90\x7F\x00\xF0\xE4\xA3\xF0"},
  {0x40, 0xA0, 0x030D, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xB5\x74\x02\xF0\x02\x04\x13\xE4\x90\x7F\x00\xF0\xA3\xF0"},
  {0x40, 0xA0, 0x031D, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xB5\x74\x02\xF0\x02\x04\x13\x90\x7F\xEC\xE0\xF4\x54\x80"},
  {0x40, 0xA0, 0x032D, 0x0000, 0x0010, 0x0010,
   "\xFF\xC4\x54\x0F\xFF\xE0\x54\x07\x2F\x25\xE0\x24\xB4\xF5\x82\xE4"},
  {0x40, 0xA0, 0x033D, 0x0000, 0x0010, 0x0010,
   "\x34\x7F\xF5\x83\xE0\x54\xFD\x90\x7F\x00\xF0\xE4\xA3\xF0\x90\x7F"},
  {0x40, 0xA0, 0x034D, 0x0000, 0x0010, 0x0010,
   "\xB5\x74\x02\xF0\x02\x04\x13\x90\x7F\xC4\x74\x01\xF0\x02\x04\x13"},
  {0x40, 0xA0, 0x035D, 0x0000, 0x0010, 0x0010,
   "\x12\x0C\xBC\x40\x03\x02\x04\x13\x90\x7F\xE8\xE0\x24\xFE\x60\x1C"},
  {0x40, 0xA0, 0x036D, 0x0000, 0x0010, 0x0010,
   "\x24\x02\x60\x03\x02\x04\x13\x90\x7F\xEA\xE0\xB4\x01\x05\xC2\x04"},
  {0x40, 0xA0, 0x037D, 0x0000, 0x0010, 0x0010,
   "\x02\x04\x13\x90\x7F\xC4\x74\x01\xF0\x02\x04\x13\x90\x7F\xEA\xE0"},
  {0x40, 0xA0, 0x038D, 0x0000, 0x0010, 0x0010,
   "\x70\x1F\x90\x7F\xEC\xE0\xF4\x54\x80\xFF\xC4\x54\x0F\xFF\xE0\x54"},
  {0x40, 0xA0, 0x039D, 0x0000, 0x0010, 0x0010,
   "\x07\x2F\x25\xE0\x24\xB4\xF5\x82\xE4\x34\x7F\xF5\x83\xE4\xF0\x80"},
  {0x40, 0xA0, 0x03AD, 0x0000, 0x0010, 0x0010,
   "\x65\x90\x7F\xC4\x74\x01\xF0\x80\x5D\x12\x0C\xBE\x50\x58\x90\x7F"},
  {0x40, 0xA0, 0x03BD, 0x0000, 0x0010, 0x0010,
   "\xE8\xE0\x24\xFE\x60\x17\x24\x02\x70\x4C\x90\x7F\xEA\xE0\xB4\x01"},
  {0x40, 0xA0, 0x03CD, 0x0000, 0x0010, 0x0010,
   "\x04\xD2\x04\x80\x41\x90\x7F\xC4\x74\x01\xF0\x80\x39\x90\x7F\xEA"},
  {0x40, 0xA0, 0x03DD, 0x0000, 0x0010, 0x0010,
   "\xE0\x70\x20\x90\x7F\xEC\xE0\xF4\x54\x80\xFF\xC4\x54\x0F\xFF\xE0"},
  {0x40, 0xA0, 0x03ED, 0x0000, 0x0010, 0x0010,
   "\x54\x07\x2F\x25\xE0\x24\xB4\xF5\x82\xE4\x34\x7F\xF5\x83\x74\x01"},
  {0x40, 0xA0, 0x03FD, 0x0000, 0x0010, 0x0010,
   "\xF0\x80\x13\x90\x7F\xC4\x74\x01\xF0\x80\x0B\x12\x0C\xC0\x50\x06"},
  {0x40, 0xA0, 0x040D, 0x0000, 0x000D, 0x000D,
   "\x90\x7F\xC4\x74\x01\xF0\x90\x7F\xB4\xE0\x44\x02\xF0"},
  {0x40, 0xA0, 0x041A, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x0ABA, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xDE\x74\x16\xF0\x90\x7F\xDF\x74\x14\xF0\x90\x7F\xDD\x74"},
  {0x40, 0xA0, 0x0ACA, 0x0000, 0x0010, 0x0010,
   "\x18\xF0\x90\x7F\xB6\x74\x02\xF0\x90\x7F\xB8\xF0\x90\x7F\xBA\xF0"},
  {0x40, 0xA0, 0x0ADA, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xBC\xF0\x90\x7F\xBE\xF0\x90\x7F\xC0\xF0\x90\x7F\xC2\xF0"},
  {0x40, 0xA0, 0x0AEA, 0x0000, 0x000A, 0x000A,
   "\xE4\x90\x7F\xC9\xF0\x90\x7F\xCD\xF0\x22"},
  {0x40, 0xA0, 0x0AF4, 0x0000, 0x0009, 0x0009,
   "\x90\x7F\xAF\xE0\x44\x08\xF0\xD3\x22"},
  {0x40, 0xA0, 0x0041, 0x0000, 0x0002, 0x0002, "\xD3\x22"},
  {0x40, 0xA0, 0x00FE, 0x0000, 0x0002, 0x0002, "\xD3\x22"},
  {0x40, 0xA0, 0x0003, 0x0000, 0x0008, 0x0008,
   "\x90\x7F\xEA\xE0\xF5\x3F\xD3\x22"},
  {0x40, 0xA0, 0x0C98, 0x0000, 0x000E, 0x000E,
   "\x90\x7F\x00\xE5\x3F\xF0\x90\x7F\xB5\x74\x01\xF0\xD3\x22"},
  {0x40, 0xA0, 0x0CB4, 0x0000, 0x0008, 0x0008,
   "\x90\x7F\xEA\xE0\xF5\x3E\xD3\x22"},
  {0x40, 0xA0, 0x0CA6, 0x0000, 0x000E, 0x000E,
   "\x90\x7F\x00\xE5\x3E\xF0\x90\x7F\xB5\x74\x01\xF0\xD3\x22"},
  {0x40, 0xA0, 0x0AFD, 0x0000, 0x0002, 0x0002, "\xD3\x22"},
  {0x40, 0xA0, 0x0CBC, 0x0000, 0x0002, 0x0002, "\xD3\x22"},
  {0x40, 0xA0, 0x0CBE, 0x0000, 0x0002, 0x0002, "\xD3\x22"},
  {0x40, 0xA0, 0x0CC0, 0x0000, 0x0002, 0x0002, "\xD3\x22"},
  {0x40, 0xA0, 0x0BAE, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\xD2"},
  {0x40, 0xA0, 0x0BBE, 0x0000, 0x0010, 0x0010,
   "\x01\x53\x91\xEF\x90\x7F\xAB\x74\x01\xF0\xD0\x86\xD0\x84\xD0\x85"},
  {0x40, 0xA0, 0x0BCE, 0x0000, 0x0007, 0x0007,
   "\xD0\x82\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x0B84, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\x90"},
  {0x40, 0xA0, 0x0B94, 0x0000, 0x0010, 0x0010,
   "\x7F\xC4\xE4\xF0\x53\x91\xEF\x90\x7F\xAB\x74\x04\xF0\xD0\x86\xD0"},
  {0x40, 0xA0, 0x0BA4, 0x0000, 0x000A, 0x000A,
   "\x84\xD0\x85\xD0\x82\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x09CA, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\xC0"},
  {0x40, 0xA0, 0x09DA, 0x0000, 0x0001, 0x0001, "\xD0"},
  {0x40, 0xA0, 0x09DB, 0x0000, 0x0010, 0x0010,
   "\x53\x91\xEF\x90\x7F\xAB\x74\x02\xF0\x30\x06\x14\x15\x3B\xE5\x3B"},
  {0x40, 0xA0, 0x09EB, 0x0000, 0x0010, 0x0010,
   "\x70\x2E\x43\x08\x40\xC2\x06\xC3\x74\x1E\x95\x3D\xF5\x3B\x80\x20"},
  {0x40, 0xA0, 0x09FB, 0x0000, 0x0010, 0x0010,
   "\xD5\x3B\x1D\x53\x08\xBF\xD2\x06\xE5\x3C\x25\x3D\xF5\x3D\x64\x03"},
  {0x40, 0xA0, 0x0A0B, 0x0000, 0x0010, 0x0010,
   "\x60\x05\xE5\x3D\xB4\x1C\x06\xE5\x3C\xF4\x04\xF5\x3C\x85\x3D\x3B"},
  {0x40, 0xA0, 0x0A1B, 0x0000, 0x000F, 0x000F,
   "\xD0\xD0\xD0\x86\xD0\x84\xD0\x85\xD0\x82\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x0BFC, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\x53"},
  {0x40, 0xA0, 0x0C0C, 0x0000, 0x0010, 0x0010,
   "\x91\xEF\x90\x7F\xAB\x74\x10\xF0\xD0\x86\xD0\x84\xD0\x85\xD0\x82"},
  {0x40, 0xA0, 0x0C1C, 0x0000, 0x0005, 0x0005, "\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x003A, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0BD5, 0x0000, 0x0010, 0x0010,
   "\xC0\xE0\xC0\x83\xC0\x82\xC0\x85\xC0\x84\xC0\x86\x75\x86\x00\xD2"},
  {0x40, 0xA0, 0x0BE5, 0x0000, 0x0010, 0x0010,
   "\x05\x53\x91\xEF\x90\x7F\xAB\x74\x08\xF0\xD0\x86\xD0\x84\xD0\x85"},
  {0x40, 0xA0, 0x0BF5, 0x0000, 0x0007, 0x0007,
   "\xD0\x82\xD0\x83\xD0\xE0\x32"},
  {0x40, 0xA0, 0x0AFF, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0CC2, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0CC3, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0CC4, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0CC5, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0CC6, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0CC7, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0CC8, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0CC9, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0CCA, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0CCB, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0CCC, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0CCD, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0CCE, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0CCF, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0CD0, 0x0000, 0x0001, 0x0001, "\x32"},
  {0x40, 0xA0, 0x0C67, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xD6\xE0\x30\xE7\x12\xE0\x44\x01\xF0\x7F\x14\x7E\x00\x12"},
  {0x40, 0xA0, 0x0C77, 0x0000, 0x000A, 0x000A,
   "\x0C\x81\x90\x7F\xD6\xE0\x54\xFE\xF0\x22"},
  {0x40, 0xA0, 0x0C46, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xD6\xE0\x44\x80\xF0\x43\x87\x01\x00\x00\x00\x00\x00\x22"},
  {0x40, 0xA0, 0x0C21, 0x0000, 0x0010, 0x0010,
   "\x90\x7F\xD6\xE0\x54\xFB\xF0\xE0\x44\x08\xF0\x30\x07\x04\xE0\x44"},
  {0x40, 0xA0, 0x0C31, 0x0000, 0x0010, 0x0010,
   "\x02\xF0\x7F\xF4\x7E\x01\x12\x0C\x81\x90\x7F\xD6\xE0\x54\xF7\xF0"},
  {0x40, 0xA0, 0x0C41, 0x0000, 0x0005, 0x0005, "\xE0\x44\x04\xF0\x22"},
  {0x40, 0xA0, 0x0A79, 0x0000, 0x0002, 0x0002, "\x8F\x1B"},
  {0x40, 0xA0, 0x0A7B, 0x0000, 0x0010, 0x0010,
   "\xE4\xF5\x1C\x75\x1D\xFF\x75\x1E\x02\x75\x1F\x07\xAB\x1D\xAA\x1E"},
  {0x40, 0xA0, 0x0A8B, 0x0000, 0x0010, 0x0010,
   "\xA9\x1F\x90\x00\x01\x12\x07\x87\xB4\x03\x1D\xAF\x1C\x05\x1C\xEF"},
  {0x40, 0xA0, 0x0A9B, 0x0000, 0x0010, 0x0010,
   "\xB5\x1B\x01\x22\x12\x07\x6E\x7E\x00\x29\xFF\xEE\x3A\xA9\x07\x75"},
  {0x40, 0xA0, 0x0AAB, 0x0000, 0x000E, 0x000E,
   "\x1D\xFF\xF5\x1E\x89\x1F\x80\xD4\x7B\x00\x7A\x00\x79\x00"},
  {0x40, 0xA0, 0x0AB9, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x0A2A, 0x0000, 0x0010, 0x0010,
   "\xE4\xFE\x75\x1D\xFF\x75\x1E\x01\x75\x1F\xD2\xAB\x1D\xAA\x1E\xA9"},
  {0x40, 0xA0, 0x0A3A, 0x0000, 0x0010, 0x0010,
   "\x1F\x90\x00\x01\x12\x07\x87\x64\x02\x70\x2D\xAD\x06\x0E\xED\xB5"},
  {0x40, 0xA0, 0x0A4A, 0x0000, 0x0010, 0x0010,
   "\x07\x01\x22\x90\x00\x02\x12\x07\xB4\x85\xF0\x1B\xF5\x1C\x62\x1B"},
  {0x40, 0xA0, 0x0A5A, 0x0000, 0x0010, 0x0010,
   "\xE5\x1B\x62\x1C\xE5\x1C\x62\x1B\x29\xFD\xE5\x1B\x3A\xA9\x05\x75"},
  {0x40, 0xA0, 0x0A6A, 0x0000, 0x000E, 0x000E,
   "\x1D\xFF\xF5\x1E\x89\x1F\x80\xC3\x7B\x00\x7A\x00\x79\x00"},
  {0x40, 0xA0, 0x0A78, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x0C81, 0x0000, 0x0010, 0x0010,
   "\x8E\x18\x8F\x19\xE5\x19\x15\x19\xAE\x18\x70\x02\x15\x18\x4E\x60"},
  {0x40, 0xA0, 0x0C91, 0x0000, 0x0007, 0x0007,
   "\x05\x12\x0C\x56\x80\xEE\x22"},
  {0x40, 0xA0, 0x0C56, 0x0000, 0x0010, 0x0010,
   "\x74\x00\xF5\x86\x90\xFD\xA5\x7C\x05\xA3\xE5\x82\x45\x83\x70\xF9"},
  {0x40, 0xA0, 0x0C66, 0x0000, 0x0001, 0x0001, "\x22"},
  {0x40, 0xA0, 0x0000, 0x0000, 0x0003, 0x0003, "\x02\x00\x46"},
  {0x40, 0xA0, 0x0046, 0x0000, 0x000C, 0x000C,
   "\x78\x7F\xE4\xF6\xD8\xFD\x75\x81\xC1\x02\x00\x8D"},
  {0x40, 0xA0, 0x076E, 0x0000, 0x0010, 0x0010,
   "\xBB\x01\x06\x89\x82\x8A\x83\xE0\x22\x50\x02\xE7\x22\xBB\xFE\x02"},
  {0x40, 0xA0, 0x077E, 0x0000, 0x0009, 0x0009,
   "\xE3\x22\x89\x82\x8A\x83\xE4\x93\x22"},
  {0x40, 0xA0, 0x0787, 0x0000, 0x0010, 0x0010,
   "\xBB\x01\x0C\xE5\x82\x29\xF5\x82\xE5\x83\x3A\xF5\x83\xE0\x22\x50"},
  {0x40, 0xA0, 0x0797, 0x0000, 0x0010, 0x0010,
   "\x06\xE9\x25\x82\xF8\xE6\x22\xBB\xFE\x06\xE9\x25\x82\xF8\xE2\x22"},
  {0x40, 0xA0, 0x07A7, 0x0000, 0x000D, 0x000D,
   "\xE5\x82\x29\xF5\x82\xE5\x83\x3A\xF5\x83\xE4\x93\x22"},
  {0x40, 0xA0, 0x07B4, 0x0000, 0x0010, 0x0010,
   "\xBB\x01\x10\xE5\x82\x29\xF5\x82\xE5\x83\x3A\xF5\x83\xE0\xF5\xF0"},
  {0x40, 0xA0, 0x07C4, 0x0000, 0x0010, 0x0010,
   "\xA3\xE0\x22\x50\x09\xE9\x25\x82\xF8\x86\xF0\x08\xE6\x22\xBB\xFE"},
  {0x40, 0xA0, 0x07D4, 0x0000, 0x0010, 0x0010,
   "\x0A\xE9\x25\x82\xF8\xE2\xF5\xF0\x08\xE2\x22\xE5\x83\x2A\xF5\x83"},
  {0x40, 0xA0, 0x07E4, 0x0000, 0x0008, 0x0008,
   "\xE9\x93\xF5\xF0\xA3\xE9\x93\x22"},
  {0x40, 0xA0, 0x07EC, 0x0000, 0x0006, 0x0006, "\x8A\x83\x89\x82\xE4\x73"},
  {0x40, 0xA0, 0x0052, 0x0000, 0x0010, 0x0010,
   "\x02\x04\x1B\xE4\x93\xA3\xF8\xE4\x93\xA3\x40\x03\xF6\x80\x01\xF2"},
  {0x40, 0xA0, 0x0062, 0x0000, 0x0010, 0x0010,
   "\x08\xDF\xF4\x80\x29\xE4\x93\xA3\xF8\x54\x07\x24\x0C\xC8\xC3\x33"},
  {0x40, 0xA0, 0x0072, 0x0000, 0x0010, 0x0010,
   "\xC4\x54\x0F\x44\x20\xC8\x83\x40\x04\xF4\x56\x80\x01\x46\xF6\xDF"},
  {0x40, 0xA0, 0x0082, 0x0000, 0x0010, 0x0010,
   "\xE4\x80\x0B\x01\x02\x04\x08\x10\x20\x40\x80\x90\x09\x62\xE4\x7E"},
  {0x40, 0xA0, 0x0092, 0x0000, 0x0010, 0x0010,
   "\x01\x93\x60\xBC\xA3\xFF\x54\x3F\x30\xE5\x09\x54\x1F\xFE\xE4\x93"},
  {0x40, 0xA0, 0x00A2, 0x0000, 0x0010, 0x0010,
   "\xA3\x60\x01\x0E\xCF\x54\xC0\x25\xE0\x60\xA8\x40\xB8\xE4\x93\xA3"},
  {0x40, 0xA0, 0x00B2, 0x0000, 0x0010, 0x0010,
   "\xFA\xE4\x93\xA3\xF8\xE4\x93\xA3\xC8\xC5\x82\xC8\xCA\xC5\x83\xCA"},
  {0x40, 0xA0, 0x00C2, 0x0000, 0x0010, 0x0010,
   "\xF0\xA3\xC8\xC5\x82\xC8\xCA\xC5\x83\xCA\xDF\xE9\xDE\xE7\x80\xBE"},
  {0x40, 0xA0, 0x09C9, 0x0000, 0x0001, 0x0001, "\x00"},
  {0x40, 0xA0, 0x7F92, 0x0000, 0x0001, 0x0001, "\x01"},
  {0x40, 0xA0, 0x7F92, 0x0000, 0x0001, 0x0001, "\x00"},
  {0x00, 0x05, 0x0002, 0x0000, 0x0000, 0x0000, ""},
  {0x00, 0x09, 0x0001, 0x0000, 0x0000, 0x0000, ""},
  {0x00, 0x00, 0x0000, 0x0000, 0x0000, 0x0000, NULL}
};
