
# NAME

osmium-renumber - renumber object IDs


# SYNOPSIS

**osmium renumber** \[*OPTIONS*\] *OSM-DATA-FILE*


# DESCRIPTION

The objects (nodes, ways, and relations) in an OSM file often have very large
IDs. This can make some kinds of postprocessing difficult. This command will
renumber all objects using IDs starting at 1. Referential integrity will be
kept. All objects which appear in the source file will be in the same order
in the output file. IDs of objects which are not in the file but referenced
from ways or relations are not guaranteed to be in the correct order.

This command expects the input file to be ordered in the usual way: First
nodes in order of ID, then ways in order of ID, then relations in order of ID.
Negative IDs are allowed, they must be ordered before the positive IDs. See
the **osmium-sort**(1) man page for details of the ordering.

The input file will be read twice, so it will not work with STDIN. If you
are not renumbering relations (ie. if the option **\--object-type/-t** is used
with nodes and/or ways but not relations) the input file will only be read
once, so in that case it will work with STDIN.

To renumber the IDs in several files, call **osmium renumber** for each file
and specify the **\--index-directory/-i** option each time. See the
**INDEX FILES** section for more details.

You must never upload the data generated by this command to OSM! This would
really confuse the OSM database because it knows the objects under different
IDs.


# OPTIONS

-i, \--index-directory=DIR
:   Directory where the index files for mapping between old and news IDs are
    read from and written to, respectively. Use this if you want to map IDs
    in several OSM files. Without this option, the indexes are not read from
    or written to disk. The directory must exist. Use '.' for the current
    directory. The files written will be named `nodes.idx`, `ways.idx`, and
    `relations.idx`. See also the **INDEX FILES** section below.

\--show-index=TYPE
:   Print the content of the index for TYPE (node, way, or relation) on
    STDOUT. Each line contains the old ID, a space character and then the
    new ID. Any other options (except **\--index-directory/-i**) are ignored
    if this option is used.

-s, \--start-id=FIRST_ID or FIRST_NODE_ID,FIRST_WAY_ID,FIRST_RELATION_ID
:   Set the first ID that should be used. If the ID is positive, IDs are
    counted upwards, if the ID is negative, they are counted downwards.
    This can be set to either a single ID which is used for all object types
    or a comma-separated list of three IDs used for the first node, way, and
    relation, respectively. If this is not set, IDs for all object types
    start at 1.

-t, \--object-type=TYPE
:   Renumber only objects of given type (*node*, *way*, or *relation*). By
    default all objects of all types are renumbered. This option can be given
    multiple times.

@MAN_COMMON_OPTIONS@
@MAN_PROGRESS_OPTIONS@
@MAN_INPUT_OPTIONS@
@MAN_OUTPUT_OPTIONS@


# INDEX FILES

When the **\--index-directory/-i** option is specified, index files named
`nodes.idx`, `ways.idx`, and `relations.idx` are read from and written to the
given directory together with a file called `start_ids` that contains the start
IDs set with **\--start-id/-s**.

This can be used to force consistent mapping over several invocations of
`osmium renumber`, for instance when you want to remap an OSM data file and a
corresponding OSM change file.

The index files are in binary format, but you can print the indexes in text
format using the **\--show-index** option:

    osmium renumber -i idxdir --show-index node     >nodes-index.txt
    osmium renumber -i idxdir --show-index way      >ways-index.txt
    osmium renumber -i idxdir --show-index relation >relations-index.txt


# DIAGNOSTICS

**osmium renumber** exits with exit code

0
  ~ if everything went alright,

1
  ~ if there was an error processing the data, or

2
  ~ if there was a problem with the command line arguments.


# MEMORY USAGE

**osmium renumber** needs quite a bit of main memory to keep the mapping
between old and new IDs. It is intended for small to medium sized extracts.
You will need more than 32 GB RAM to run this on a full planet.

Memory use is at least 8 bytes per node, way, and relation ID in the input
file.


# EXAMPLES

Renumber a PBF file and output to a compressed XML file:

    osmium renumber -o ch.osm.bz2 germany.osm.pbf

Renumbering the about 3 GB Germany PBF file currently (spring 2019) takes less
than three minutes and needs about 7 GB RAM.

Renumber a PBF file starting the node IDs at 1 (and counting upwards), the
way IDs at 100 and the relation IDs at -200 (and counting downwards.

    osmium renumber -o renumbered.osm.pbf -s 1,100,-200 athens.osm.pbf

Renumber an OSM file storing the indexes on disk:

    osmium renumber -i. -o renumbered.osm data.osm

then rewrite a change file, too:

    osmium renumber -i. -o renumbered.osc changes.osc


# SEE ALSO

* **osmium**(1), **osmium-file-formats**(5), **osmium-sort**(1)
* [Osmium website](https://osmcode.org/osmium-tool/)

